/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.config.groups;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.matsim.core.config.ReflectiveConfigGroup;
import org.matsim.core.utils.collections.CollectionUtils;

public final class TravelTimeCalculatorConfigGroup
extends ReflectiveConfigGroup {
    private static final Logger log = Logger.getLogger(TravelTimeCalculatorConfigGroup.class);
    public static final String GROUPNAME = "travelTimeCalculator";
    private static final String TRAVEL_TIME_CALCULATOR = "travelTimeCalculator";
    private static final String TRAVEL_TIME_BIN_SIZE = "travelTimeBinSize";
    private static final String TRAVEL_TIME_AGGREGATOR = "travelTimeAggregator";
    private static final String TRAVEL_TIME_GETTER = "travelTimeGetter";
    private static final String MAX_TIME = "maxTime";
    private static final String CALCULATE_LINK_TRAVELTIMES = "calculateLinkTravelTimes";
    private static final String CALCULATE_LINKTOLINK_TRAVELTIMES = "calculateLinkToLinkTravelTimes";
    private static final String ANALYZEDMODES = "analyzedModes";
    private static final String FILTERMODES = "filterModes";
    private static final String SEPARATEMODES = "separateModes";
    private TravelTimeCalculatorType travelTimeCalculator = TravelTimeCalculatorType.TravelTimeCalculatorArray;
    private String travelTimeAggregator = "optimistic";
    private String travelTimeGetter = "average";
    private int traveltimeBinSize = 900;
    private int maxTime = 108000;
    private boolean calculateLinkTravelTimes = true;
    private boolean calculateLinkToLinkTravelTimes = false;
    private Set<String> analyzedModes = new LinkedHashSet<String>();
    private boolean filterModes = false;
    private boolean separateModes = true;

    public TravelTimeCalculatorConfigGroup() {
        super("travelTimeCalculator");
        this.analyzedModes.add("car");
    }

    @Override
    public final Map<String, String> getComments() {
        Map<String, String> map = super.getComments();
        map.put(TRAVEL_TIME_BIN_SIZE, "The size of the time bin (in sec) into which the link travel times are aggregated for the router");
        map.put(MAX_TIME, "The lenght (in sec) of the time period that is splited into time bins; an additional time bin is created to aggregate all travel times collected after maxTime");
        map.put(TRAVEL_TIME_GETTER, "How to deal with link entry times at different positions during the time bin. Currently supported: average, linearinterpolation");
        map.put(TRAVEL_TIME_AGGREGATOR, "How to deal with congested time bins that have no link entry events. `optimistic' assumes free speed (too optimistic); 'experimental_LastMile' is experimental and probably too pessimistic.");
        map.put(ANALYZEDMODES, "(only for backwards compatibility; only used if separateModes==false && + filterModes==true)  Transport modes that will be respected by the travel time collector. 'car' is default which includes also buses from the pt simulation module.");
        map.put(FILTERMODES, "(only for backwards compatiblity; only used if separateModes==false)  Only modes included in analyzedModes are included.");
        map.put(SEPARATEMODES, "(only for backwards compatibility) If false, link travel times are measured and aggregated over all vehicles using the link.");
        map.put("travelTimeCalculator", "possible values: " + Arrays.stream(TravelTimeCalculatorType.values()).map(type -> type.toString() + ' ').collect(Collectors.joining()));
        return map;
    }

    @ReflectiveConfigGroup.StringSetter(value="travelTimeCalculator")
    public void setTravelTimeCalculatorType(String travelTimeCalculator) {
        this.travelTimeCalculator = TravelTimeCalculatorType.valueOf(travelTimeCalculator);
    }

    @ReflectiveConfigGroup.StringGetter(value="travelTimeCalculator")
    public TravelTimeCalculatorType getTravelTimeCalculatorType() {
        return this.travelTimeCalculator;
    }

    @ReflectiveConfigGroup.StringSetter(value="travelTimeAggregator")
    public void setTravelTimeAggregatorType(String travelTimeAggregator) {
        this.travelTimeAggregator = travelTimeAggregator;
    }

    @ReflectiveConfigGroup.StringGetter(value="travelTimeAggregator")
    public String getTravelTimeAggregatorType() {
        return this.travelTimeAggregator;
    }

    @ReflectiveConfigGroup.StringSetter(value="travelTimeGetter")
    public void setTravelTimeGetterType(String travelTimeGetter) {
        this.travelTimeGetter = travelTimeGetter;
    }

    @ReflectiveConfigGroup.StringGetter(value="travelTimeGetter")
    public String getTravelTimeGetterType() {
        return this.travelTimeGetter;
    }

    @ReflectiveConfigGroup.StringSetter(value="travelTimeBinSize")
    public final void setTraveltimeBinSize(int binSize) {
        this.traveltimeBinSize = binSize;
    }

    @ReflectiveConfigGroup.StringGetter(value="travelTimeBinSize")
    public final int getTraveltimeBinSize() {
        return this.traveltimeBinSize;
    }

    @ReflectiveConfigGroup.StringSetter(value="maxTime")
    public void setMaxTime(int maxTime) {
        this.maxTime = maxTime;
    }

    @ReflectiveConfigGroup.StringGetter(value="maxTime")
    public int getMaxTime() {
        return this.maxTime;
    }

    @ReflectiveConfigGroup.StringGetter(value="calculateLinkTravelTimes")
    public boolean isCalculateLinkTravelTimes() {
        return this.calculateLinkTravelTimes;
    }

    @ReflectiveConfigGroup.StringSetter(value="calculateLinkTravelTimes")
    public void setCalculateLinkTravelTimes(boolean calculateLinkTravelTimes) {
        this.calculateLinkTravelTimes = calculateLinkTravelTimes;
    }

    @ReflectiveConfigGroup.StringGetter(value="calculateLinkToLinkTravelTimes")
    public boolean isCalculateLinkToLinkTravelTimes() {
        return this.calculateLinkToLinkTravelTimes;
    }

    @ReflectiveConfigGroup.StringSetter(value="calculateLinkToLinkTravelTimes")
    public void setCalculateLinkToLinkTravelTimes(boolean calculateLinkToLinkTravelTimes) {
        this.calculateLinkToLinkTravelTimes = calculateLinkToLinkTravelTimes;
    }

    @ReflectiveConfigGroup.StringGetter(value="filterModes")
    public boolean isFilterModes() {
        return this.filterModes;
    }

    @ReflectiveConfigGroup.StringSetter(value="filterModes")
    public void setFilterModes(boolean filterModes) {
        this.filterModes = filterModes;
    }

    @ReflectiveConfigGroup.StringGetter(value="analyzedModes")
    public String getAnalyzedModesAsString() {
        return CollectionUtils.setToString(this.analyzedModes);
    }

    public Set<String> getAnalyzedModes() {
        return this.analyzedModes;
    }

    @ReflectiveConfigGroup.StringSetter(value="analyzedModes")
    public void setAnalyzedModesAsString(String analyzedModes) {
        this.analyzedModes = CollectionUtils.stringToSet(analyzedModes);
    }

    public void setAnalyzedModes(Set<String> analyzedModes) {
        this.analyzedModes = analyzedModes;
    }

    @ReflectiveConfigGroup.StringGetter(value="separateModes")
    public boolean getSeparateModes() {
        return this.separateModes;
    }

    @ReflectiveConfigGroup.StringSetter(value="separateModes")
    public void setSeparateModes(boolean separateModes) {
        this.separateModes = separateModes;
    }

    static enum DifferentModesHandling {
        separateAccordingToAnalyzedModes,
        jointButRestrictedToAnalyzedModes,
        jointAndUsingAllModes;

    }

    public static enum TravelTimeCalculatorType {
        TravelTimeCalculatorArray,
        TravelTimeCalculatorHashMap;

    }
}

