/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.config.groups;

import java.util.Map;
import org.apache.log4j.Logger;
import org.matsim.core.config.Config;
import org.matsim.core.config.ReflectiveConfigGroup;

public final class VspExperimentalConfigGroup
extends ReflectiveConfigGroup {
    private static final Logger log = Logger.getLogger(VspExperimentalConfigGroup.class);
    public static final String GROUP_NAME = "vspExperimental";
    private static final String WRITING_OUTPUT_EVENTS = "writingOutputEvents";
    private boolean writingOutputEvents = true;
    private static final String VSP_DEFAULTS_CHECKING_LEVEL = "vspDefaultsCheckingLevel";
    private VspDefaultsCheckingLevel vspDefaultsCheckingLevel = VspDefaultsCheckingLevel.ignore;
    private static final String LOGIT_SCALE_PARAM_FOR_PLANS_REMOVAL = "logitScaleParamForPlansRemoval";
    private double logitScaleParamForPlansRemoval = 1.0;
    private static final String GENERATING_BOARDING_DENIED_EVENT = "isGeneratingBoardingDeniedEvent";
    private boolean isGeneratingBoardingDeniedEvent = false;
    private static final String ABLE_TO_OVERWRITE_PT_INTERACTION_PARAMS = "isAbleToOverwritePtInteractionParams";
    private boolean isAbleToOverwritePtInteractionParams = false;
    private static final String USING_OPPORTUNITY_COST_OF_TIME_FOR_LOCATION_CHOICE = "isUsingOpportunityCostOfTimeForLocationChoice";
    private boolean isUsingOpportunityCostOfTimeForLocationChoice = true;

    public VspExperimentalConfigGroup() {
        super(GROUP_NAME);
    }

    @ReflectiveConfigGroup.StringGetter(value="vspDefaultsCheckingLevel")
    public VspDefaultsCheckingLevel getVspDefaultsCheckingLevel() {
        return this.vspDefaultsCheckingLevel;
    }

    @ReflectiveConfigGroup.StringSetter(value="vspDefaultsCheckingLevel")
    public void setVspDefaultsCheckingLevel(VspDefaultsCheckingLevel vspDefaultsCheckingLevel) {
        this.testForLocked();
        this.vspDefaultsCheckingLevel = vspDefaultsCheckingLevel;
    }

    @ReflectiveConfigGroup.StringGetter(value="logitScaleParamForPlansRemoval")
    public double getLogitScaleParamForPlansRemoval() {
        return this.logitScaleParamForPlansRemoval;
    }

    @ReflectiveConfigGroup.StringSetter(value="logitScaleParamForPlansRemoval")
    public void setLogitScaleParamForPlansRemoval(double logitScaleParamForPlansRemoval) {
        this.testForLocked();
        this.logitScaleParamForPlansRemoval = logitScaleParamForPlansRemoval;
    }

    @ReflectiveConfigGroup.StringGetter(value="isGeneratingBoardingDeniedEvent")
    public boolean isGeneratingBoardingDeniedEvents() {
        return this.isGeneratingBoardingDeniedEvent;
    }

    @ReflectiveConfigGroup.StringSetter(value="isGeneratingBoardingDeniedEvent")
    public void setGeneratingBoardingDeniedEvent(boolean isGeneratingBoardingDeniedEvent) {
        this.testForLocked();
        this.isGeneratingBoardingDeniedEvent = isGeneratingBoardingDeniedEvent;
    }

    @ReflectiveConfigGroup.StringGetter(value="isAbleToOverwritePtInteractionParams")
    public boolean isAbleToOverwritePtInteractionParams() {
        return this.isAbleToOverwritePtInteractionParams;
    }

    @ReflectiveConfigGroup.StringSetter(value="isAbleToOverwritePtInteractionParams")
    public void setAbleToOverwritePtInteractionParams(boolean isAbleToOverwritePtInteractionParams) {
        this.testForLocked();
        this.isAbleToOverwritePtInteractionParams = isAbleToOverwritePtInteractionParams;
    }

    @ReflectiveConfigGroup.StringGetter(value="isUsingOpportunityCostOfTimeForLocationChoice")
    public boolean isUsingOpportunityCostOfTimeForLocationChoice() {
        return this.isUsingOpportunityCostOfTimeForLocationChoice;
    }

    @ReflectiveConfigGroup.StringSetter(value="isUsingOpportunityCostOfTimeForLocationChoice")
    public void setUsingOpportunityCostOfTimeForLocationChoice(boolean isUsingOpportunityCostOfTimeForLocationChoice) {
        this.testForLocked();
        this.isUsingOpportunityCostOfTimeForLocationChoice = isUsingOpportunityCostOfTimeForLocationChoice;
    }

    @Override
    public Map<String, String> getComments() {
        Map<String, String> map = super.getComments();
        map.put(ABLE_TO_OVERWRITE_PT_INTERACTION_PARAMS, "(do not use except of you have to) There was a problem with pt interaction scoring.  Some people solved it by overwriting the parameters of the pt interaction activity type.  Doing this now throws an Exception.  If you still insist on doing this, set the following to true.");
        map.put(USING_OPPORTUNITY_COST_OF_TIME_FOR_LOCATION_CHOICE, "if an approximation of the opportunity cost of time is included into the radius calculation for location choice.`true' will be faster, but it is an approximation.  Default is `true'; `false' is available for backwards compatibility.");
        map.put(WRITING_OUTPUT_EVENTS, "if true then writes output_events in output directory.  default is `false'. Will only work when lastIteration is multiple of events writing interval");
        StringBuilder options = new StringBuilder();
        for (VspDefaultsCheckingLevel option : VspDefaultsCheckingLevel.values()) {
            options.append((Object)((Object)option) + " | ");
        }
        map.put(VSP_DEFAULTS_CHECKING_LEVEL, "Options: | " + options + ".  When violating VSP defaults, this results in " + "nothing, logfile infos, logfile warnings, or aborts.  Members of VSP should use `abort' or talk to kai.");
        return map;
    }

    @ReflectiveConfigGroup.StringGetter(value="writingOutputEvents")
    public boolean isWritingOutputEvents() {
        return this.writingOutputEvents;
    }

    @ReflectiveConfigGroup.StringSetter(value="writingOutputEvents")
    public void setWritingOutputEvents(boolean writingOutputEvents) {
        this.testForLocked();
        this.writingOutputEvents = writingOutputEvents;
    }

    @Override
    protected void checkConsistency(Config config) {
    }

    public static enum VspDefaultsCheckingLevel {
        ignore,
        info,
        warn,
        abort;

    }
}

