/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.config.groups;

import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.imageio.ImageIO;

public final class ZoomEntry
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Rectangle2D zoomstart;
    private BufferedImage snap;
    private String name;

    public ZoomEntry() {
    }

    public ZoomEntry(BufferedImage snap, Rectangle2D zoomstore, String name) {
        this.snap = snap;
        this.zoomstart = zoomstore;
        this.name = name;
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        s2.writeUTF(this.name);
        s2.writeDouble(this.zoomstart.getX());
        s2.writeDouble(this.zoomstart.getY());
        s2.writeDouble(this.zoomstart.getWidth());
        s2.writeDouble(this.zoomstart.getHeight());
        ImageIO.write((RenderedImage)this.snap, "jpg", s2);
    }

    private void readObject(ObjectInputStream s2) throws IOException {
        this.name = s2.readUTF();
        this.zoomstart = new Rectangle2D.Double(s2.readDouble(), s2.readDouble(), s2.readDouble(), s2.readDouble());
        this.snap = ImageIO.read(s2);
    }

    public Rectangle2D getZoomstart() {
        return this.zoomstart;
    }

    public BufferedImage getSnap() {
        return this.snap;
    }

    public String getName() {
        return this.name;
    }
}

