/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.controler;

import org.apache.log4j.Logger;
import org.matsim.analysis.IterationStopWatch;
import org.matsim.core.config.Config;
import org.matsim.core.controler.ControlerListenerManagerImpl;
import org.matsim.core.controler.ControlerUtils;
import org.matsim.core.controler.MatsimRuntimeModifications;
import org.matsim.core.controler.MatsimServices;
import org.matsim.core.controler.OutputDirectoryHierarchy;
import org.matsim.core.controler.OutputDirectoryLogging;
import org.matsim.core.controler.listener.ControlerListener;
import org.matsim.core.gbl.MatsimRandom;

abstract class AbstractController {
    private static Logger log = Logger.getLogger(AbstractController.class);
    private OutputDirectoryHierarchy controlerIO;
    private final IterationStopWatch stopwatch;
    private ControlerListenerManagerImpl controlerListenerManagerImpl;
    private Integer thisIteration = null;
    final String MARKER = "### ";

    protected AbstractController() {
        this(new ControlerListenerManagerImpl(), new IterationStopWatch(), null);
    }

    AbstractController(ControlerListenerManagerImpl controlerListenerManager, IterationStopWatch stopWatch, MatsimServices matsimServices) {
        log.info("Used Controler-Class: " + this.getClass().getCanonicalName());
        this.controlerListenerManagerImpl = controlerListenerManager;
        this.controlerListenerManagerImpl.setControler(matsimServices);
        this.stopwatch = stopWatch;
    }

    private void resetRandomNumbers(long seed, int iteration) {
        MatsimRandom.reset(seed + (long)iteration);
        MatsimRandom.getRandom().nextDouble();
    }

    final void setupOutputDirectory(OutputDirectoryHierarchy controlerIO) {
        this.controlerIO = controlerIO;
        OutputDirectoryLogging.initLogging(this.getControlerIO());
    }

    protected final void run(final Config config) {
        MatsimRuntimeModifications.MyRunnable runnable = new MatsimRuntimeModifications.MyRunnable(){

            @Override
            public void run() throws MatsimRuntimeModifications.UnexpectedShutdownException {
                AbstractController.this.loadCoreListeners();
                AbstractController.this.controlerListenerManagerImpl.fireControlerStartupEvent();
                ControlerUtils.checkConfigConsistencyAndWriteToLog(config, "config dump before iterations start");
                AbstractController.this.prepareForSim();
                AbstractController.this.doIterations(config);
            }

            @Override
            public void shutdown(boolean unexpected) {
                AbstractController.this.controlerListenerManagerImpl.fireControlerShutdownEvent(unexpected);
            }
        };
        MatsimRuntimeModifications.run(runnable);
        OutputDirectoryLogging.closeOutputDirLogging();
    }

    protected abstract void loadCoreListeners();

    protected abstract void runMobSim();

    protected abstract void prepareForSim();

    protected abstract void prepareForMobsim();

    protected abstract boolean continueIterations(int var1);

    private void doIterations(Config config) throws MatsimRuntimeModifications.UnexpectedShutdownException {
        int iteration = config.controler().getFirstIteration();
        while (this.continueIterations(iteration)) {
            this.iteration(config, iteration);
            ++iteration;
        }
    }

    private void iteration(Config config, final int iteration) throws MatsimRuntimeModifications.UnexpectedShutdownException {
        this.thisIteration = iteration;
        this.getStopwatch().beginIteration(iteration);
        log.info("###################################################");
        log.info("### ITERATION " + iteration + " BEGINS");
        this.getControlerIO().createIterationDirectory(iteration);
        this.resetRandomNumbers(config.global().getRandomSeed(), iteration);
        this.iterationStep("iterationStartsListeners", new Runnable(){

            @Override
            public void run() {
                AbstractController.this.controlerListenerManagerImpl.fireControlerIterationStartsEvent(iteration);
            }
        });
        if (iteration > config.controler().getFirstIteration()) {
            this.iterationStep("replanning", new Runnable(){

                @Override
                public void run() {
                    AbstractController.this.controlerListenerManagerImpl.fireControlerReplanningEvent(iteration);
                }
            });
        }
        this.mobsim(config, iteration);
        this.iterationStep("scoring", new Runnable(){

            @Override
            public void run() {
                log.info("### ITERATION " + iteration + " fires scoring event");
                AbstractController.this.controlerListenerManagerImpl.fireControlerScoringEvent(iteration);
            }
        });
        this.iterationStep("iterationEndsListeners", new Runnable(){

            @Override
            public void run() {
                log.info("### ITERATION " + iteration + " fires iteration end event");
                AbstractController.this.controlerListenerManagerImpl.fireControlerIterationEndsEvent(iteration);
            }
        });
        this.getStopwatch().endIteration();
        this.getStopwatch().writeTextFile(this.getControlerIO().getOutputFilename("stopwatch"));
        if (config.controler().isCreateGraphs()) {
            this.getStopwatch().writeGraphFile(this.getControlerIO().getOutputFilename("stopwatch"));
        }
        log.info("### ITERATION " + iteration + " ENDS");
        log.info("###################################################");
    }

    private void mobsim(final Config config, final int iteration) throws MatsimRuntimeModifications.UnexpectedShutdownException {
        try {
            this.iterationStep("beforeMobsimListeners", new Runnable(){

                @Override
                public void run() {
                    AbstractController.this.controlerListenerManagerImpl.fireControlerBeforeMobsimEvent(iteration);
                }
            });
            this.iterationStep("prepareForMobsim", new Runnable(){

                @Override
                public void run() {
                    AbstractController.this.prepareForMobsim();
                }
            });
            this.iterationStep("mobsim", new Runnable(){

                @Override
                public void run() {
                    AbstractController.this.resetRandomNumbers(config.global().getRandomSeed(), iteration);
                    AbstractController.this.runMobSim();
                }
            });
        }
        catch (Throwable t) {
            try {
                log.error("Mobsim did not complete normally! afterMobsimListeners will be called anyway.", t);
                throw t;
            }
            catch (Throwable throwable) {
                this.iterationStep("afterMobsimListeners", new Runnable(iteration){
                    final /* synthetic */ int val$iteration;
                    {
                        this.val$iteration = n;
                    }

                    @Override
                    public void run() {
                        log.info("### ITERATION " + this.val$iteration + " fires after mobsim event");
                        AbstractController.this.controlerListenerManagerImpl.fireControlerAfterMobsimEvent(this.val$iteration);
                    }
                });
                throw throwable;
            }
        }
        this.iterationStep("afterMobsimListeners", new /* invalid duplicate definition of identical inner class */);
    }

    private void iterationStep(String iterationStepName, Runnable iterationStep) throws MatsimRuntimeModifications.UnexpectedShutdownException {
        this.getStopwatch().beginOperation(iterationStepName);
        iterationStep.run();
        this.getStopwatch().endOperation(iterationStepName);
        if (Thread.interrupted()) {
            throw new MatsimRuntimeModifications.UnexpectedShutdownException();
        }
    }

    public final void addControlerListener(ControlerListener l) {
        this.controlerListenerManagerImpl.addControlerListener(l);
    }

    protected final void addCoreControlerListener(ControlerListener l) {
        this.controlerListenerManagerImpl.addCoreControlerListener(l);
    }

    public final OutputDirectoryHierarchy getControlerIO() {
        return this.controlerIO;
    }

    public final Integer getIterationNumber() {
        return this.thisIteration;
    }

    public IterationStopWatch getStopwatch() {
        return this.stopwatch;
    }
}

