/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.controler;

import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import com.google.inject.binder.AnnotatedBindingBuilder;
import com.google.inject.binder.LinkedBindingBuilder;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.name.Names;
import com.google.inject.util.Modules;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import javax.inject.Provider;
import org.matsim.api.core.v01.population.Person;
import org.matsim.api.core.v01.population.Plan;
import org.matsim.core.api.experimental.events.EventsManager;
import org.matsim.core.config.Config;
import org.matsim.core.controler.listener.ControlerListener;
import org.matsim.core.events.handler.EventHandler;
import org.matsim.core.mobsim.framework.Mobsim;
import org.matsim.core.mobsim.framework.listeners.MobsimListener;
import org.matsim.core.mobsim.qsim.AbstractQSimModule;
import org.matsim.core.replanning.PlanStrategy;
import org.matsim.core.replanning.selectors.PlanSelector;
import org.matsim.core.router.RoutingModule;
import org.matsim.core.router.costcalculators.TravelDisutilityFactory;
import org.matsim.core.router.util.LeastCostPathCalculatorFactory;
import org.matsim.core.router.util.TravelTime;
import org.matsim.core.scoring.ScoringFunctionFactory;
import org.matsim.utils.objectattributes.AttributeConverter;
import org.matsim.vis.snapshotwriters.SnapshotWriter;

public abstract class AbstractModule
implements Module {
    private Binder binder;
    private Multibinder<EventHandler> eventHandlerMultibinder;
    private Multibinder<ControlerListener> controlerListenerMultibinder;
    private Multibinder<MobsimListener> mobsimListenerMultibinder;
    private Multibinder<SnapshotWriter> snapshotWriterMultibinder;
    private MapBinder<Class<?>, AttributeConverter<?>> attributeConverterMapBinder;
    private Multibinder<AbstractQSimModule> qsimModulesMultibinder;
    @Inject
    Injector bootstrapInjector;
    private Config config;

    public AbstractModule() {
    }

    public AbstractModule(Config config) {
        this.config = config;
    }

    @Override
    public final void configure(Binder binder) {
        if (this.config == null) {
            this.config = this.bootstrapInjector.getInstance(Config.class);
        }
        this.binder = binder.skipSources(AbstractModule.class);
        this.mobsimListenerMultibinder = Multibinder.newSetBinder(this.binder, MobsimListener.class);
        this.snapshotWriterMultibinder = Multibinder.newSetBinder(this.binder, SnapshotWriter.class);
        this.eventHandlerMultibinder = Multibinder.newSetBinder(this.binder, EventHandler.class);
        this.controlerListenerMultibinder = Multibinder.newSetBinder(this.binder, ControlerListener.class);
        this.attributeConverterMapBinder = MapBinder.newMapBinder(this.binder, new TypeLiteral<Class<?>>(){}, new TypeLiteral<AttributeConverter<?>>(){});
        this.qsimModulesMultibinder = Multibinder.newSetBinder(this.binder, AbstractQSimModule.class);
        this.install();
    }

    public abstract void install();

    protected final Config getConfig() {
        return this.config;
    }

    protected final void install(Module module) {
        this.bootstrapInjector.injectMembers(module);
        this.binder.install(module);
    }

    protected final LinkedBindingBuilder<EventHandler> addEventHandlerBinding() {
        return this.eventHandlerMultibinder.addBinding();
    }

    protected final void installQSimModule(AbstractQSimModule qsimModule) {
        this.qsimModulesMultibinder.addBinding().toInstance(qsimModule);
    }

    protected final LinkedBindingBuilder<ControlerListener> addControlerListenerBinding() {
        return this.controlerListenerMultibinder.addBinding();
    }

    protected final LinkedBindingBuilder<PlanSelector<Plan, Person>> bindPlanSelectorForRemoval() {
        return this.bind(new TypeLiteral<PlanSelector<Plan, Person>>(){});
    }

    protected final LinkedBindingBuilder<PlanStrategy> addPlanStrategyBinding(String selectorName) {
        return this.binder().bind(PlanStrategy.class).annotatedWith(Names.named(selectorName));
    }

    protected final LinkedBindingBuilder<Mobsim> bindMobsim() {
        return this.bind(Mobsim.class);
    }

    protected final LinkedBindingBuilder<ScoringFunctionFactory> bindScoringFunctionFactory() {
        return this.bind(ScoringFunctionFactory.class);
    }

    protected final LinkedBindingBuilder<MobsimListener> addMobsimListenerBinding() {
        return this.mobsimListenerMultibinder.addBinding();
    }

    protected final LinkedBindingBuilder<SnapshotWriter> addSnapshotWriterBinding() {
        return this.snapshotWriterMultibinder.addBinding();
    }

    protected final LinkedBindingBuilder<AttributeConverter<?>> addAttributeConverterBinding(Class<?> clazz) {
        return this.attributeConverterMapBinder.addBinding(clazz);
    }

    protected final LinkedBindingBuilder<TravelDisutilityFactory> bindCarTravelDisutilityFactory() {
        return this.bind(this.carTravelDisutilityFactoryKey());
    }

    protected final Key<TravelDisutilityFactory> carTravelDisutilityFactoryKey() {
        return Key.get(TravelDisutilityFactory.class, (Annotation)Names.named("car"));
    }

    protected final LinkedBindingBuilder<TravelDisutilityFactory> addTravelDisutilityFactoryBinding(String mode) {
        return this.binder().bind(TravelDisutilityFactory.class).annotatedWith(Names.named(mode));
    }

    protected final LinkedBindingBuilder<LeastCostPathCalculatorFactory> bindLeastCostPathCalculatorFactory() {
        return this.bind(LeastCostPathCalculatorFactory.class);
    }

    protected final LinkedBindingBuilder<TravelTime> addTravelTimeBinding(String mode) {
        return this.binder().bind(TravelTime.class).annotatedWith(Names.named(mode));
    }

    protected final LinkedBindingBuilder<RoutingModule> addRoutingModuleBinding(String mode) {
        return this.binder().bind(RoutingModule.class).annotatedWith(Names.named(mode));
    }

    protected final LinkedBindingBuilder<EventsManager> bindEventsManager() {
        return this.binder().bind(EventsManager.class);
    }

    protected final LinkedBindingBuilder<TravelTime> bindNetworkTravelTime() {
        return this.bind(this.networkTravelTime());
    }

    protected final Key<TravelTime> networkTravelTime() {
        return Key.get(TravelTime.class, (Annotation)Names.named("car"));
    }

    protected <T> AnnotatedBindingBuilder<T> bind(Class<T> aClass) {
        return this.binder.bind(aClass);
    }

    protected <T> AnnotatedBindingBuilder<T> bind(TypeLiteral<T> typeLiteral) {
        return this.binder.bind(typeLiteral);
    }

    protected <T> LinkedBindingBuilder<T> bind(Key<T> key) {
        return this.binder.bind(key);
    }

    protected final Binder binder() {
        return this.binder;
    }

    protected final <T> Provider<T> getProvider(TypeLiteral<T> typeLiteral) {
        return this.binder.getProvider(Key.get(typeLiteral));
    }

    public static AbstractModule override(final Iterable<? extends AbstractModule> modules, final AbstractModule abstractModule) {
        return new AbstractModule(){

            @Override
            public void install() {
                ArrayList<AbstractModule> guiceModules = new ArrayList<AbstractModule>();
                for (AbstractModule module : modules) {
                    this.bootstrapInjector.injectMembers(module);
                    guiceModules.add(module);
                }
                this.bootstrapInjector.injectMembers(abstractModule);
                this.binder().install(Modules.override(guiceModules).with(abstractModule));
            }
        };
    }

    public static AbstractModule emptyModule() {
        return new AbstractModule(){

            @Override
            public void install() {
            }
        };
    }
}

