/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.controler;

import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.matsim.analysis.CalcLinkStats;
import org.matsim.analysis.IterationStopWatch;
import org.matsim.analysis.ScoreStats;
import org.matsim.analysis.VolumesAnalyzer;
import org.matsim.api.core.v01.Scenario;
import org.matsim.api.core.v01.events.Event;
import org.matsim.core.api.experimental.events.EventsManager;
import org.matsim.core.config.Config;
import org.matsim.core.config.ConfigGroup;
import org.matsim.core.config.ConfigUtils;
import org.matsim.core.config.consistency.ConfigConsistencyCheckerImpl;
import org.matsim.core.config.consistency.UnmaterializedConfigGroupChecker;
import org.matsim.core.controler.AbstractModule;
import org.matsim.core.controler.AllowsConfiguration;
import org.matsim.core.controler.ControlerDefaultsModule;
import org.matsim.core.controler.ControlerI;
import org.matsim.core.controler.Injector;
import org.matsim.core.controler.MatsimServices;
import org.matsim.core.controler.NewControlerModule;
import org.matsim.core.controler.OutputDirectoryHierarchy;
import org.matsim.core.controler.TerminationCriterion;
import org.matsim.core.controler.corelisteners.ControlerDefaultCoreListenersModule;
import org.matsim.core.controler.listener.ControlerListener;
import org.matsim.core.events.handler.EventHandler;
import org.matsim.core.gbl.Gbl;
import org.matsim.core.mobsim.qsim.AbstractQSimModule;
import org.matsim.core.mobsim.qsim.components.QSimComponentsConfig;
import org.matsim.core.mobsim.qsim.components.QSimComponentsConfigurator;
import org.matsim.core.mobsim.qsim.components.StandardQSimComponentConfigurator;
import org.matsim.core.replanning.ReplanningContext;
import org.matsim.core.replanning.StrategyManager;
import org.matsim.core.router.TripRouter;
import org.matsim.core.router.costcalculators.TravelDisutilityFactory;
import org.matsim.core.router.util.LeastCostPathCalculatorFactory;
import org.matsim.core.router.util.TravelDisutility;
import org.matsim.core.router.util.TravelTime;
import org.matsim.core.scenario.ScenarioByConfigModule;
import org.matsim.core.scenario.ScenarioByInstanceModule;
import org.matsim.core.scoring.ScoringFunctionFactory;

public final class Controler
implements ControlerI,
MatsimServices,
AllowsConfiguration {
    public static final String DIRECTORY_ITERS = "ITERS";
    public static final String FILENAME_CONFIG = "config.xml";
    public static final String FILENAME_CONFIG_REDUCED = "config_reduced.xml";
    public static final String FILENAME_NETWORK = "network.xml.gz";
    public static final String FILENAME_LANES = "lanes.xml.gz";
    public static final String FILENAME_CHANGE_EVENTS_XML = "change_events.xml.gz";
    public static final String FILENAME_COUNTS = "counts.xml.gz";
    public static final String FILENAME_POPULATION = "plans.xml.gz";
    public static final String FILENAME_EXPERIENCED_PLANS = "experienced_plans.xml.gz";
    public static final String FILENAME_PERSON_ATTRIBUTES = "personAttributes.xml.gz";
    public static final String FILENAME_HOUSEHOLDS = "households.xml.gz";
    public static final String FILENAME_FACILITIES = "facilities.xml.gz";
    public static final String FILENAME_EVENTS_XML = "events.xml.gz";
    public static final String FILENAME_TRANSIT_SCHEDULE = "transitSchedule.xml.gz";
    public static final String FILENAME_TRANSIT_VEHICLES = "transitVehicles.xml.gz";
    public static final String FILENAME_VEHICLES = "vehicles.xml.gz";
    public static final String FILENAME_LINKSTATS = "linkstats.txt.gz";
    public static final String FILENAME_TRAVELDISTANCESTATS = "traveldistancestats";
    public static final String OUTPUT_PREFIX = "output_";
    public static final String DIVIDER = "###################################################";
    private static final Logger log = Logger.getLogger(Controler.class);
    public static final Layout DEFAULTLOG4JLAYOUT = new PatternLayout("%d{ISO8601} %5p %C{1}:%L %m%n");
    private final Config config;
    private Scenario scenario;
    private com.google.inject.Injector injector;
    private boolean injectorCreated = false;
    private List<AbstractModule> modules = Collections.singletonList(new ControlerDefaultsModule());
    private AbstractModule overrides = AbstractModule.emptyModule();
    private List<AbstractQSimModule> overridingQSimModules = new LinkedList<AbstractQSimModule>();

    @Override
    public IterationStopWatch getStopwatch() {
        return this.injector.getInstance(IterationStopWatch.class);
    }

    public static void main(String[] args) {
        if (args == null || args.length == 0) {
            System.out.println("No argument given!");
            System.out.println("Usage: Controler config-file [dtd-file]");
            System.out.println();
        } else {
            Controler controler = new Controler(args);
            controler.run();
        }
        System.exit(0);
    }

    public Controler(String[] args) {
        this(args.length > 0 ? args[0] : null, null, null);
    }

    public Controler(String configFileName) {
        this(configFileName, null, null);
    }

    public Controler(Config config) {
        this(null, config, null);
    }

    public Controler(Scenario scenario) {
        this(null, null, scenario);
    }

    private Controler(String configFileName, Config config, Scenario scenario) {
        if (scenario != null) {
            this.config = scenario.getConfig();
            this.config.addConfigConsistencyChecker(new ConfigConsistencyCheckerImpl());
        } else {
            if (configFileName == null) {
                if (config == null) {
                    throw new IllegalArgumentException("Either the config or the filename of a configfile must be set to initialize the Controler.");
                }
                this.config = config;
            } else {
                this.config = ConfigUtils.loadConfig(configFileName, new ConfigGroup[0]);
            }
            this.config.addConfigConsistencyChecker(new ConfigConsistencyCheckerImpl());
        }
        this.config.parallelEventHandling().makeLocked();
        this.scenario = scenario;
        this.overrides = scenario == null ? new ScenarioByConfigModule() : new ScenarioByInstanceModule(this.scenario);
        this.config.qsim().setLocked();
    }

    @Override
    public final void run() {
        this.injectorCreated = true;
        this.overrides = AbstractModule.override(Collections.singletonList(this.overrides), new AbstractModule(){

            @Override
            public void install() {
                this.bind(Key.get(new TypeLiteral<List<AbstractQSimModule>>(){}, (Annotation)Names.named("overrides"))).toInstance(Controler.this.overridingQSimModules);
            }
        });
        this.config.removeConfigConsistencyChecker(UnmaterializedConfigGroupChecker.class);
        this.config.checkConsistency();
        this.config.addConfigConsistencyChecker(new UnmaterializedConfigGroupChecker());
        Set<2> standardModules = Collections.singleton(new AbstractModule(){

            @Override
            public void install() {
                this.install(new NewControlerModule());
                this.install(new ControlerDefaultCoreListenersModule());
                for (AbstractModule module : Controler.this.modules) {
                    this.install(module);
                }
            }
        });
        this.injector = Injector.createInjector(this.config, AbstractModule.override(standardModules, this.overrides));
        ControlerI controler = this.injector.getInstance(ControlerI.class);
        controler.run();
    }

    @Override
    public final TravelTime getLinkTravelTimes() {
        return this.injector.getInstance(com.google.inject.Injector.class).getInstance(Key.get(new TypeLiteral<Map<String, TravelTime>>(){})).get("car");
    }

    @Override
    public final Provider<TripRouter> getTripRouterProvider() {
        return this.injector.getProvider(TripRouter.class);
    }

    @Override
    public final TravelDisutility createTravelDisutilityCalculator() {
        return this.getTravelDisutilityFactory().createTravelDisutility(this.injector.getInstance(TravelTime.class));
    }

    @Override
    public final LeastCostPathCalculatorFactory getLeastCostPathCalculatorFactory() {
        return this.injector.getInstance(LeastCostPathCalculatorFactory.class);
    }

    @Override
    public final ScoringFunctionFactory getScoringFunctionFactory() {
        return this.injector.getInstance(ScoringFunctionFactory.class);
    }

    @Override
    public final Config getConfig() {
        return this.config;
    }

    @Override
    public final Scenario getScenario() {
        if (this.injectorCreated) {
            Gbl.assertNotNull(this.injector);
            return this.injector.getInstance(Scenario.class);
        }
        if (this.scenario == null) {
            log.error("Trying to get Scenario before it was instanciated.");
            log.error("When passing a config file or a config file path to the Controler constructor,");
            log.error("Scenario will be loaded first when the run() method is invoked.");
            throw new IllegalStateException("Trying to get Scenario before is was instanciated.");
        }
        return this.scenario;
    }

    @Override
    public final EventsManager getEvents() {
        if (this.injector != null) {
            return this.injector.getInstance(EventsManager.class);
        }
        return new EventsManager(){

            @Override
            public void processEvent(Event event) {
                Controler.this.injector.getInstance(EventsManager.class).processEvent(event);
            }

            @Override
            public void addHandler(final EventHandler handler) {
                Controler.this.addOverridingModule(new AbstractModule(){

                    @Override
                    public void install() {
                        this.addEventHandlerBinding().toInstance(handler);
                    }
                });
            }

            @Override
            public void removeHandler(EventHandler handler) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void resetHandlers(int iteration) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void initProcessing() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void afterSimStep(double time) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void finishProcessing() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public final com.google.inject.Injector getInjector() {
        return this.injector;
    }

    @Override
    @Deprecated
    public final CalcLinkStats getLinkStats() {
        return this.injector.getInstance(CalcLinkStats.class);
    }

    @Override
    public final VolumesAnalyzer getVolumes() {
        return this.injector.getInstance(VolumesAnalyzer.class);
    }

    @Override
    public final ScoreStats getScoreStats() {
        return this.injector.getInstance(ScoreStats.class);
    }

    @Override
    public final TravelDisutilityFactory getTravelDisutilityFactory() {
        return this.injector.getInstance(com.google.inject.Injector.class).getInstance(Key.get(new TypeLiteral<Map<String, TravelDisutilityFactory>>(){})).get("car");
    }

    @Override
    @Deprecated
    public final StrategyManager getStrategyManager() {
        return this.injector.getInstance(StrategyManager.class);
    }

    @Override
    public OutputDirectoryHierarchy getControlerIO() {
        return this.injector.getInstance(OutputDirectoryHierarchy.class);
    }

    @Override
    public Integer getIterationNumber() {
        return this.injector.getInstance(ReplanningContext.class).getIteration();
    }

    @Override
    public void addControlerListener(final ControlerListener controlerListener) {
        this.addOverridingModule(new AbstractModule(){

            @Override
            public void install() {
                this.addControlerListenerBinding().toInstance(controlerListener);
            }
        });
    }

    public final void setScoringFunctionFactory(final ScoringFunctionFactory scoringFunctionFactory) {
        this.addOverridingModule(new AbstractModule(){

            @Override
            public void install() {
                this.bindScoringFunctionFactory().toInstance(scoringFunctionFactory);
            }
        });
    }

    public final void setTerminationCriterion(final TerminationCriterion terminationCriterion) {
        this.addOverridingModule(new AbstractModule(){

            @Override
            public void install() {
                this.bind(TerminationCriterion.class).toInstance(terminationCriterion);
            }
        });
    }

    @Deprecated
    public final void setTripRouterFactory(final javax.inject.Provider<TripRouter> factory) {
        this.addOverridingModule(new AbstractModule(){

            @Override
            public void install() {
                this.bind(TripRouter.class).toProvider(factory);
            }
        });
    }

    @Override
    public final Controler addOverridingModule(AbstractModule abstractModule) {
        if (this.injectorCreated) {
            throw new RuntimeException("Too late for configuring the Controler. This can only be done before calling run.");
        }
        this.overrides = AbstractModule.override(Collections.singletonList(this.overrides), abstractModule);
        return this;
    }

    public final void setModules(AbstractModule ... modules) {
        if (this.injectorCreated) {
            throw new RuntimeException("Too late for configuring the Controler. This can only be done before calling run.");
        }
        this.modules = Arrays.asList(modules);
    }

    @Override
    public final Controler addOverridingQSimModule(AbstractQSimModule qsimModule) {
        if (this.injectorCreated) {
            throw new RuntimeException("Too late for configuring the Controler. This can only be done before calling run.");
        }
        this.overridingQSimModules.add(qsimModule);
        return this;
    }

    @Override
    public final Controler addQSimModule(final AbstractQSimModule qsimModule) {
        this.addOverridingModule(new AbstractModule(){

            @Override
            public void install() {
                this.installQSimModule(qsimModule);
            }
        });
        return this;
    }

    @Override
    public final Controler configureQSimComponents(final QSimComponentsConfigurator configurator) {
        this.addOverridingModule(new AbstractModule(){

            @Override
            public void install() {
                QSimComponentsConfig components = new QSimComponentsConfig();
                new StandardQSimComponentConfigurator(Controler.this.config).configure(components);
                configurator.configure(components);
                this.bind(QSimComponentsConfig.class).toInstance(components);
            }
        });
        return this;
    }
}

