/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.controler;

import javax.swing.event.EventListenerList;
import org.apache.log4j.Logger;
import org.matsim.core.controler.ControlerListenerManager;
import org.matsim.core.controler.MatsimServices;
import org.matsim.core.controler.events.AfterMobsimEvent;
import org.matsim.core.controler.events.BeforeMobsimEvent;
import org.matsim.core.controler.events.IterationEndsEvent;
import org.matsim.core.controler.events.IterationStartsEvent;
import org.matsim.core.controler.events.ReplanningEvent;
import org.matsim.core.controler.events.ScoringEvent;
import org.matsim.core.controler.events.ShutdownEvent;
import org.matsim.core.controler.events.StartupEvent;
import org.matsim.core.controler.listener.AfterMobsimListener;
import org.matsim.core.controler.listener.BeforeMobsimListener;
import org.matsim.core.controler.listener.ControlerListener;
import org.matsim.core.controler.listener.IterationEndsListener;
import org.matsim.core.controler.listener.IterationStartsListener;
import org.matsim.core.controler.listener.ReplanningListener;
import org.matsim.core.controler.listener.ScoringListener;
import org.matsim.core.controler.listener.ShutdownListener;
import org.matsim.core.controler.listener.StartupListener;
import org.matsim.core.utils.misc.ClassUtils;

public final class ControlerListenerManagerImpl
implements ControlerListenerManager {
    private static final Logger log = Logger.getLogger(ControlerListenerManagerImpl.class);
    private MatsimServices controler = null;
    private final EventListenerList coreListenerList = new EventListenerList();
    private final EventListenerList listenerList = new EventListenerList();

    void setControler(MatsimServices controler) {
        this.controler = controler;
    }

    protected void addCoreControlerListener(ControlerListener l) {
        for (Class<?> type : ClassUtils.getAllTypes(l.getClass())) {
            if (!type.isInterface() || !ControlerListener.class.isAssignableFrom(type)) continue;
            this.coreListenerList.add(type, l);
        }
    }

    @Override
    public void addControlerListener(ControlerListener l) {
        for (Class<?> type : ClassUtils.getAllTypes(l.getClass())) {
            if (!ControlerListener.class.isAssignableFrom(type)) continue;
            this.listenerList.add(type, l);
        }
    }

    public void removeControlerListener(ControlerListener l) {
        Class<?>[] interfaces;
        for (Class<?> anInterface : interfaces = l.getClass().getInterfaces()) {
            if (!ControlerListener.class.isAssignableFrom(anInterface)) continue;
            this.listenerList.remove(anInterface, l);
        }
    }

    public void fireControlerStartupEvent() {
        StartupListener[] listener;
        StartupEvent event = new StartupEvent(this.controler);
        for (StartupListener aListener : listener = (StartupListener[])this.coreListenerList.getListeners(StartupListener.class)) {
            log.info("calling notifyStartup on " + aListener.getClass().getName());
            aListener.notifyStartup(event);
        }
        for (StartupListener aListener : listener = (StartupListener[])this.listenerList.getListeners(StartupListener.class)) {
            log.info("calling notifyStartup on " + aListener.getClass().getName());
            aListener.notifyStartup(event);
        }
        log.info("all ControlerStartupListeners called.");
    }

    public void fireControlerShutdownEvent(boolean unexpected) {
        ShutdownListener[] listener;
        ShutdownEvent event = new ShutdownEvent(this.controler, unexpected);
        for (ShutdownListener aListener : listener = (ShutdownListener[])this.coreListenerList.getListeners(ShutdownListener.class)) {
            log.info("calling notifyShutdown on " + aListener.getClass().getName());
            aListener.notifyShutdown(event);
        }
        for (ShutdownListener aListener : listener = (ShutdownListener[])this.listenerList.getListeners(ShutdownListener.class)) {
            log.info("calling notifyShutdown on " + aListener.getClass().getName());
            aListener.notifyShutdown(event);
        }
        log.info("all ControlerShutdownListeners called.");
    }

    public void fireControlerIterationStartsEvent(int iteration) {
        IterationStartsListener[] listener;
        IterationStartsEvent event = new IterationStartsEvent(this.controler, iteration);
        for (IterationStartsListener aListener : listener = (IterationStartsListener[])this.coreListenerList.getListeners(IterationStartsListener.class)) {
            log.info("calling notifyIterationStarts on " + aListener.getClass().getName());
            aListener.notifyIterationStarts(event);
        }
        for (IterationStartsListener aListener : listener = (IterationStartsListener[])this.listenerList.getListeners(IterationStartsListener.class)) {
            log.info("calling notifyIterationStarts on " + aListener.getClass().getName());
            aListener.notifyIterationStarts(event);
        }
        log.info("[it." + iteration + "] all ControlerIterationStartsListeners called.");
    }

    public void fireControlerIterationEndsEvent(int iteration) {
        IterationEndsListener[] listener;
        IterationEndsEvent event = new IterationEndsEvent(this.controler, iteration);
        for (IterationEndsListener aListener : listener = (IterationEndsListener[])this.coreListenerList.getListeners(IterationEndsListener.class)) {
            log.info("calling notifyIterationEnds on " + aListener.getClass().getName());
            aListener.notifyIterationEnds(event);
        }
        for (IterationEndsListener aListener : listener = (IterationEndsListener[])this.listenerList.getListeners(IterationEndsListener.class)) {
            log.info("calling notifyIterationEnds on " + aListener.getClass().getName());
            aListener.notifyIterationEnds(event);
        }
        log.info("[it." + iteration + "] all ControlerIterationEndsListeners called.");
    }

    public void fireControlerScoringEvent(int iteration) {
        ScoringListener[] listener;
        ScoringEvent event = new ScoringEvent(this.controler, iteration);
        for (ScoringListener aListener : listener = (ScoringListener[])this.coreListenerList.getListeners(ScoringListener.class)) {
            log.info("calling notifyScoring on " + aListener.getClass().getName());
            aListener.notifyScoring(event);
        }
        for (ScoringListener aListener : listener = (ScoringListener[])this.listenerList.getListeners(ScoringListener.class)) {
            log.info("calling notifyScoring on " + aListener.getClass().getName());
            aListener.notifyScoring(event);
        }
        log.info("[it." + iteration + "] all ControlerScoringListeners called.");
    }

    public void fireControlerReplanningEvent(int iteration) {
        ReplanningListener[] listener;
        ReplanningEvent event = new ReplanningEvent(this.controler, iteration);
        for (ReplanningListener aListener : listener = (ReplanningListener[])this.coreListenerList.getListeners(ReplanningListener.class)) {
            log.info("calling notifyReplanning on " + aListener.getClass().getName());
            aListener.notifyReplanning(event);
        }
        for (ReplanningListener aListener : listener = (ReplanningListener[])this.listenerList.getListeners(ReplanningListener.class)) {
            log.info("calling notifyReplanning on " + aListener.getClass().getName());
            aListener.notifyReplanning(event);
        }
        log.info("[it." + iteration + "] all ControlerReplanningListeners called.");
    }

    public void fireControlerBeforeMobsimEvent(int iteration) {
        BeforeMobsimListener[] listener;
        BeforeMobsimEvent event = new BeforeMobsimEvent(this.controler, iteration);
        for (BeforeMobsimListener aListener : listener = (BeforeMobsimListener[])this.coreListenerList.getListeners(BeforeMobsimListener.class)) {
            log.info("calling notifyBeforeMobsim on " + aListener.getClass().getName());
            aListener.notifyBeforeMobsim(event);
        }
        for (BeforeMobsimListener aListener : listener = (BeforeMobsimListener[])this.listenerList.getListeners(BeforeMobsimListener.class)) {
            log.info("calling notifyBeforeMobsim on " + aListener.getClass().getName());
            aListener.notifyBeforeMobsim(event);
        }
        log.info("[it." + iteration + "] all ControlerBeforeMobsimListeners called.");
    }

    public void fireControlerAfterMobsimEvent(int iteration) {
        AfterMobsimListener[] listener;
        AfterMobsimEvent event = new AfterMobsimEvent(this.controler, iteration);
        for (AfterMobsimListener aListener : listener = (AfterMobsimListener[])this.coreListenerList.getListeners(AfterMobsimListener.class)) {
            log.info("calling notifyAfterMobsim on " + aListener.getClass().getName());
            aListener.notifyAfterMobsim(event);
        }
        for (AfterMobsimListener aListener : listener = (AfterMobsimListener[])this.listenerList.getListeners(AfterMobsimListener.class)) {
            log.info("calling notifyAfterMobsim on " + aListener.getClass().getName());
            aListener.notifyAfterMobsim(event);
        }
        log.info("[it." + iteration + "] all ControlerAfterMobsimListeners called.");
    }
}

