/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.controler;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.log4j.Logger;
import org.matsim.core.config.Config;
import org.matsim.core.config.ConfigWriter;
import org.matsim.core.controler.OutputDirectoryLogging;

public final class ControlerUtils {
    private static final Logger log = Logger.getLogger(ControlerUtils.class);

    private ControlerUtils() {
    }

    public static final void checkConfigConsistencyAndWriteToLog(Config config, String message) {
        log.info(message);
        String newline = System.getProperty("line.separator");
        StringWriter writer = new StringWriter();
        new ConfigWriter(config).writeStream(new PrintWriter(writer), newline);
        log.info(newline + newline + writer.getBuffer().toString());
        log.info("Complete config dump done.");
        log.info("Checking consistency of config...");
        config.checkConsistency();
        log.info("Checking consistency of config done.");
    }

    @Deprecated
    public static final void initializeOutputLogging() {
        OutputDirectoryLogging.catchLogEntries();
    }
}

