/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.controler;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Binding;
import com.google.inject.Guice;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.internal.BindingImpl;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import com.google.inject.spi.DefaultElementVisitor;
import com.google.inject.spi.Element;
import com.google.inject.spi.Elements;
import com.google.inject.spi.LinkedKeyBinding;
import com.google.inject.util.Modules;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.matsim.core.config.Config;
import org.matsim.core.controler.ExplodedConfigModule;
import org.matsim.core.router.RoutingModule;
import org.matsim.core.router.costcalculators.TravelDisutilityFactory;
import org.matsim.core.router.util.TravelTime;

public final class Injector {
    private static Logger logger = Logger.getLogger(Injector.class);

    private Injector() {
    }

    public static com.google.inject.Injector createInjector(final Config config, Module ... modules) {
        com.google.inject.Injector bootstrapInjector = Guice.createInjector(new Module(){

            @Override
            public void configure(Binder binder) {
                binder.requireExplicitBindings();
                binder.install(new ExplodedConfigModule(config));
            }
        });
        ArrayList<Module> guiceModules = new ArrayList<Module>();
        for (Module module : modules) {
            bootstrapInjector.injectMembers(module);
            guiceModules.add(module);
        }
        com.google.inject.Injector realInjector = bootstrapInjector.createChildInjector(Injector.insertMapBindings(guiceModules));
        Injector.printInjector(realInjector, logger);
        return realInjector;
    }

    public static void printInjector(com.google.inject.Injector injector, Logger log) {
        Level level = Level.INFO;
        log.log(level, "=== printInjector start ===");
        for (Map.Entry<Key<?>, Binding<?>> entry : injector.getBindings().entrySet()) {
            if (!entry.getKey().toString().contains("type=org.matsim")) continue;
            Annotation annotation = entry.getKey().getAnnotation();
            log.log(level, entry.getKey().getTypeLiteral() + " " + (annotation != null ? annotation.toString() : ""));
            log.log(level, "  --> provider: " + entry.getValue().getProvider());
            log.log(level, "  --> source: " + entry.getValue().getSource());
            if (entry.getValue() instanceof BindingImpl) {
                log.log(level, "  --> scope: " + ((BindingImpl)entry.getValue()).getScoping());
            }
            if (entry.getValue() instanceof LinkedKeyBinding) {
                log.log(level, "  --> target: " + ((LinkedKeyBinding)entry.getValue()).getLinkedKey());
            }
            log.log(level, "  ==full==> " + entry.getValue());
            log.log(level, "");
        }
        log.log(level, "=== printInjector end ===");
    }

    private static Module insertMapBindings(List<Module> guiceModules) {
        AbstractModule routingModuleBindings = Injector.createMapBindingsForType(guiceModules, RoutingModule.class);
        AbstractModule travelTimeBindings = Injector.createMapBindingsForType(guiceModules, TravelTime.class);
        AbstractModule travelDisutilityFactoryBindings = Injector.createMapBindingsForType(guiceModules, TravelDisutilityFactory.class);
        return Modules.combine(Modules.combine(guiceModules), routingModuleBindings, travelTimeBindings, travelDisutilityFactoryBindings);
    }

    private static <T> AbstractModule createMapBindingsForType(List<Module> guiceModules, final Class<T> aClass) {
        final HashSet modes = new HashSet();
        for (Element element : Elements.getElements(guiceModules)) {
            element.acceptVisitor(new DefaultElementVisitor<Object>(){

                @Override
                public <T> Object visit(Binding<T> binding) {
                    if (binding.getKey().getTypeLiteral().getRawType().equals(aClass) && binding.getKey().getAnnotation() instanceof Named) {
                        modes.add(((Named)binding.getKey().getAnnotation()).value());
                    }
                    return null;
                }
            });
        }
        return new AbstractModule(){

            @Override
            protected void configure() {
                MapBinder routingModuleMultibinder = MapBinder.newMapBinder(this.binder(), String.class, aClass);
                for (String mode : modes) {
                    routingModuleMultibinder.addBinding(mode).to(Key.get(aClass, (Annotation)Names.named(mode)));
                }
            }
        };
    }
}

