/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.controler;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.log4j.Logger;

class MatsimRuntimeModifications {
    private final MyRunnable runnable;
    private volatile Throwable uncaughtException;
    private AtomicBoolean unexpectedShutdown = new AtomicBoolean(false);
    private static Logger log = Logger.getLogger(MatsimRuntimeModifications.class);

    MatsimRuntimeModifications(MyRunnable runnable) {
        this.runnable = runnable;
    }

    static void run(MyRunnable runnable) {
        new MatsimRuntimeModifications(runnable).run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void run() {
        Thread.UncaughtExceptionHandler previousDefaultUncaughtExceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
        final Thread controllerThread = Thread.currentThread();
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                log.error("Getting uncaught Exception in Thread " + t.getName(), e);
                MatsimRuntimeModifications.this.uncaughtException = e;
                MatsimRuntimeModifications.this.unexpectedShutdown.set(true);
                controllerThread.interrupt();
            }
        });
        try {
            this.runnable.run();
        }
        catch (UnexpectedShutdownException e) {
        }
        catch (Throwable e) {
            log.error("Getting uncaught Exception in Thread " + Thread.currentThread().getName(), e);
            this.uncaughtException = e;
            this.unexpectedShutdown.set(true);
        }
        finally {
            block21: {
                log.info("S H U T D O W N   ---   start shutdown.");
                if (this.unexpectedShutdown.get()) {
                    log.error("ERROR --- This is an unexpected shutdown!");
                }
                if (this.uncaughtException != null) {
                    log.error("Shutdown possibly caused by the following Exception:", this.uncaughtException);
                }
                try {
                    this.runnable.shutdown(this.unexpectedShutdown.get());
                }
                catch (Exception e) {
                    this.unexpectedShutdown.set(true);
                    log.error("Exception during shutdown:", e);
                    if (this.uncaughtException != null) break block21;
                    this.uncaughtException = e;
                }
            }
            if (this.unexpectedShutdown.get()) {
                log.error("ERROR --- MATSim unexpectedly terminated. Please check the output or the logfile with warnings and errors for hints.");
                log.error("ERROR --- results should not be used for further analysis.");
            }
            log.info("S H U T D O W N   ---   shutdown completed.");
            if (this.unexpectedShutdown.get()) {
                log.error("ERROR --- This was an unexpected shutdown! See the log file for a possible reason.");
            }
            Thread.setDefaultUncaughtExceptionHandler(previousDefaultUncaughtExceptionHandler);
        }
        if (this.uncaughtException != null) {
            if (this.uncaughtException instanceof RuntimeException) {
                throw (RuntimeException)this.uncaughtException;
            }
            throw new RuntimeException(this.uncaughtException);
        }
    }

    static class UnexpectedShutdownException
    extends Exception {
        UnexpectedShutdownException() {
        }
    }

    static interface MyRunnable {
        public void run() throws UnexpectedShutdownException;

        public void shutdown(boolean var1);
    }
}

