/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.controler;

import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import java.util.Map;
import javax.inject.Inject;
import org.matsim.analysis.CalcLinkStats;
import org.matsim.analysis.IterationStopWatch;
import org.matsim.analysis.ScoreStats;
import org.matsim.analysis.VolumesAnalyzer;
import org.matsim.api.core.v01.Scenario;
import org.matsim.core.api.experimental.events.EventsManager;
import org.matsim.core.config.Config;
import org.matsim.core.controler.ControlerI;
import org.matsim.core.controler.MatsimServices;
import org.matsim.core.controler.NewControler;
import org.matsim.core.controler.OutputDirectoryHierarchy;
import org.matsim.core.controler.listener.ControlerListener;
import org.matsim.core.replanning.ReplanningContext;
import org.matsim.core.replanning.StrategyManager;
import org.matsim.core.router.TripRouter;
import org.matsim.core.router.costcalculators.TravelDisutilityFactory;
import org.matsim.core.router.util.LeastCostPathCalculatorFactory;
import org.matsim.core.router.util.TravelDisutility;
import org.matsim.core.router.util.TravelTime;
import org.matsim.core.scoring.ScoringFunctionFactory;

class MatsimServicesImpl
implements MatsimServices {
    @Inject
    Injector injector;

    MatsimServicesImpl() {
    }

    @Override
    public IterationStopWatch getStopwatch() {
        return this.injector.getInstance(IterationStopWatch.class);
    }

    @Override
    public final TravelTime getLinkTravelTimes() {
        return this.injector.getInstance(Injector.class).getInstance(Key.get(new TypeLiteral<Map<String, TravelTime>>(){})).get("car");
    }

    @Override
    public final Provider<TripRouter> getTripRouterProvider() {
        return this.injector.getProvider(TripRouter.class);
    }

    @Override
    public final TravelDisutility createTravelDisutilityCalculator() {
        return this.getTravelDisutilityFactory().createTravelDisutility(this.injector.getInstance(TravelTime.class));
    }

    @Override
    public final LeastCostPathCalculatorFactory getLeastCostPathCalculatorFactory() {
        return this.injector.getInstance(LeastCostPathCalculatorFactory.class);
    }

    @Override
    public final ScoringFunctionFactory getScoringFunctionFactory() {
        return this.injector.getInstance(ScoringFunctionFactory.class);
    }

    @Override
    public Config getConfig() {
        return this.injector.getInstance(Config.class);
    }

    @Override
    public Scenario getScenario() {
        return this.injector.getInstance(Scenario.class);
    }

    @Override
    public EventsManager getEvents() {
        return this.injector.getInstance(EventsManager.class);
    }

    @Override
    public Injector getInjector() {
        return this.injector;
    }

    @Override
    public final CalcLinkStats getLinkStats() {
        return this.injector.getInstance(CalcLinkStats.class);
    }

    @Override
    public final VolumesAnalyzer getVolumes() {
        return this.injector.getInstance(VolumesAnalyzer.class);
    }

    @Override
    public final ScoreStats getScoreStats() {
        return this.injector.getInstance(ScoreStats.class);
    }

    @Override
    public final TravelDisutilityFactory getTravelDisutilityFactory() {
        return this.injector.getInstance(Injector.class).getInstance(Key.get(new TypeLiteral<Map<String, TravelDisutilityFactory>>(){})).get("car");
    }

    @Override
    public final StrategyManager getStrategyManager() {
        return this.injector.getInstance(StrategyManager.class);
    }

    @Override
    public OutputDirectoryHierarchy getControlerIO() {
        return this.injector.getInstance(OutputDirectoryHierarchy.class);
    }

    @Override
    public void addControlerListener(ControlerListener controlerListener) {
        ((NewControler)this.injector.getInstance(ControlerI.class)).addControlerListener(controlerListener);
    }

    @Override
    public Integer getIterationNumber() {
        return this.injector.getInstance(ReplanningContext.class).getIteration();
    }
}

