/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.controler;

import com.google.inject.Provider;
import java.util.Set;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.matsim.analysis.IterationStopWatch;
import org.matsim.core.config.Config;
import org.matsim.core.config.consistency.ConfigConsistencyCheckerImpl;
import org.matsim.core.config.groups.ControlerConfigGroup;
import org.matsim.core.controler.AbstractController;
import org.matsim.core.controler.ControlerI;
import org.matsim.core.controler.ControlerListenerManagerImpl;
import org.matsim.core.controler.MatsimServices;
import org.matsim.core.controler.OutputDirectoryHierarchy;
import org.matsim.core.controler.OutputDirectoryLogging;
import org.matsim.core.controler.PrepareForMobsim;
import org.matsim.core.controler.PrepareForSim;
import org.matsim.core.controler.TerminationCriterion;
import org.matsim.core.controler.corelisteners.DumpDataAtEnd;
import org.matsim.core.controler.corelisteners.EventsHandling;
import org.matsim.core.controler.corelisteners.PlansDumping;
import org.matsim.core.controler.corelisteners.PlansReplanning;
import org.matsim.core.controler.corelisteners.PlansScoring;
import org.matsim.core.controler.listener.ControlerListener;
import org.matsim.core.mobsim.framework.Mobsim;

class NewControler
extends AbstractController
implements ControlerI {
    private static Logger log = Logger.getLogger(NewControler.class);
    private final Config config;
    private final PrepareForSim prepareForSim;
    private final PrepareForMobsim prepareForMobsim;
    private final EventsHandling eventsHandling;
    private final PlansDumping plansDumping;
    private final PlansReplanning plansReplanning;
    private final Provider<Mobsim> mobsimProvider;
    private final PlansScoring plansScoring;
    private final TerminationCriterion terminationCriterion;
    private final DumpDataAtEnd dumpDataAtEnd;
    private final Set<ControlerListener> controlerListenersDeclaredByModules;
    private final ControlerConfigGroup controlerConfigGroup;
    private final OutputDirectoryHierarchy outputDirectoryHierarchy;

    @Inject
    NewControler(Config config, ControlerListenerManagerImpl controlerListenerManager, MatsimServices matsimServices, IterationStopWatch stopWatch, PrepareForSim prepareForSim, EventsHandling eventsHandling, PlansDumping plansDumping, PlansReplanning plansReplanning, Provider<Mobsim> mobsimProvider, PlansScoring plansScoring, TerminationCriterion terminationCriterion, DumpDataAtEnd dumpDataAtEnd, Set<ControlerListener> controlerListenersDeclaredByModules, ControlerConfigGroup controlerConfigGroup, OutputDirectoryHierarchy outputDirectoryHierarchy, PrepareForMobsim prepareForMobsim) {
        super(controlerListenerManager, stopWatch, matsimServices);
        this.config = config;
        this.prepareForMobsim = prepareForMobsim;
        this.config.addConfigConsistencyChecker(new ConfigConsistencyCheckerImpl());
        this.prepareForSim = prepareForSim;
        this.eventsHandling = eventsHandling;
        this.plansDumping = plansDumping;
        this.plansReplanning = plansReplanning;
        this.mobsimProvider = mobsimProvider;
        this.plansScoring = plansScoring;
        this.terminationCriterion = terminationCriterion;
        this.dumpDataAtEnd = dumpDataAtEnd;
        this.controlerListenersDeclaredByModules = controlerListenersDeclaredByModules;
        this.controlerConfigGroup = controlerConfigGroup;
        this.outputDirectoryHierarchy = outputDirectoryHierarchy;
    }

    @Override
    public final void run() {
        super.setupOutputDirectory(this.outputDirectoryHierarchy);
        super.run(this.config);
        OutputDirectoryLogging.closeOutputDirLogging();
    }

    @Override
    protected final void loadCoreListeners() {
        if (this.controlerConfigGroup.getDumpDataAtEnd()) {
            this.addCoreControlerListener(this.dumpDataAtEnd);
        }
        this.addCoreControlerListener(this.plansScoring);
        this.addCoreControlerListener(this.plansReplanning);
        this.addCoreControlerListener(this.plansDumping);
        this.addCoreControlerListener(this.eventsHandling);
        for (ControlerListener controlerListener : this.controlerListenersDeclaredByModules) {
            this.addControlerListener(controlerListener);
        }
    }

    @Override
    protected final void prepareForSim() {
        this.prepareForSim.run();
    }

    @Override
    protected final void prepareForMobsim() {
        this.prepareForMobsim.run();
    }

    @Override
    protected final void runMobSim() {
        this.mobsimProvider.get().run();
    }

    @Override
    protected final boolean continueIterations(int it) {
        return this.terminationCriterion.continueIterations(it);
    }
}

