/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.controler;

import java.io.File;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.matsim.core.config.groups.ControlerConfigGroup;
import org.matsim.core.utils.io.IOUtils;

public final class OutputDirectoryHierarchy {
    private static final String DIRECTORY_ITERS = "ITERS";
    private static Logger log = Logger.getLogger(OutputDirectoryHierarchy.class);
    private String runId = null;
    private final String outputPath;
    private OverwriteFileSetting overwriteFiles = OverwriteFileSetting.failIfDirectoryExists;

    @Inject
    OutputDirectoryHierarchy(ControlerConfigGroup config) {
        this(config.getOutputDirectory(), config.getRunId(), config.getOverwriteFileSetting());
    }

    public OutputDirectoryHierarchy(String outputPath, OverwriteFileSetting overwriteFiles) {
        this(outputPath, null, overwriteFiles, true);
    }

    public OutputDirectoryHierarchy(String outputPath, String runId, OverwriteFileSetting overwriteFiles) {
        this(outputPath, runId, overwriteFiles, true);
    }

    public OutputDirectoryHierarchy(String outputPath, String runId, OverwriteFileSetting overwriteFiles, boolean createDirectories) {
        this.overwriteFiles = overwriteFiles;
        if (outputPath.endsWith("/")) {
            outputPath = outputPath.substring(0, outputPath.length() - 1);
        }
        this.outputPath = outputPath;
        this.runId = runId;
        if (createDirectories) {
            this.createDirectories();
        }
    }

    public final String getTempPath() {
        return this.outputPath + "/tmp";
    }

    public final String getIterationPath(int iteration) {
        return this.outputPath + "/" + DIRECTORY_ITERS + "/it." + iteration;
    }

    public final String getIterationFilename(int iteration, String filename) {
        StringBuilder s2 = new StringBuilder(this.getIterationPath(iteration));
        s2.append('/');
        if (this.runId != null) {
            s2.append(this.runId);
            s2.append('.');
        }
        s2.append(iteration);
        s2.append(".");
        s2.append(filename);
        return s2.toString();
    }

    public final String getOutputFilename(String filename) {
        StringBuilder s2 = new StringBuilder(this.outputPath);
        s2.append('/');
        if (this.runId != null) {
            s2.append(this.runId);
            s2.append('.');
        }
        s2.append(filename);
        return s2.toString();
    }

    public String getOutputPath() {
        return this.outputPath;
    }

    public final void createIterationDirectory(int iteration) {
        File dir = new File(this.getIterationPath(iteration));
        if (!dir.mkdir()) {
            if (this.overwriteFiles == OverwriteFileSetting.overwriteExistingFiles && dir.exists()) {
                log.info("Iteration directory " + this.getIterationPath(iteration) + " exists already.");
            } else {
                log.warn("Could not create iteration directory " + this.getIterationPath(iteration) + ".");
            }
        }
    }

    private void createDirectories() {
        File outputDir = new File(this.outputPath);
        if (outputDir.exists()) {
            if (outputDir.isFile()) {
                throw new RuntimeException("Cannot create output directory. " + this.outputPath + " is a file and cannot be replaced by a directory.");
            }
            if (outputDir.list().length > 0) {
                switch (this.overwriteFiles) {
                    case failIfDirectoryExists: {
                        throw new RuntimeException("The output directory " + this.outputPath + " already exists and is not empty!" + " Please either delete or empty the directory or" + " configure the services via setOverwriteFileSetting()" + " or the \"overwriteFiles\" parameter of the \"services\" config group.");
                    }
                    case overwriteExistingFiles: {
                        System.out.flush();
                        log.warn("###########################################################");
                        log.warn("### THE CONTROLER WILL OVERWRITE FILES IN:");
                        log.warn("### " + this.outputPath);
                        log.warn("###########################################################");
                        System.err.flush();
                        break;
                    }
                    case deleteDirectoryIfExists: {
                        System.out.flush();
                        log.info("###########################################################");
                        log.info("### THE CONTROLER WILL DELETE THE EXISTING OUTPUT DIRECTORY:");
                        log.info("### " + this.outputPath);
                        log.info("###########################################################");
                        System.out.flush();
                        IOUtils.deleteDirectoryRecursively(outputDir.toPath());
                        break;
                    }
                    default: {
                        throw new RuntimeException("unknown setting " + (Object)((Object)this.overwriteFiles));
                    }
                }
            }
        }
        if (!outputDir.exists() && !outputDir.mkdirs()) {
            throw new RuntimeException("The output directory path " + this.outputPath + " could not be created. Check pathname and permissions! Full path: " + new File(this.outputPath).getAbsolutePath());
        }
        File tmpDir = new File(this.getTempPath());
        if (!tmpDir.mkdir() && !tmpDir.exists()) {
            throw new RuntimeException("The tmp directory " + this.getTempPath() + " could not be created.");
        }
        File itersDir = new File(this.outputPath + "/" + DIRECTORY_ITERS);
        if (!itersDir.mkdir() && !itersDir.exists()) {
            throw new RuntimeException("The iterations directory " + this.outputPath + "/" + DIRECTORY_ITERS + " could not be created.");
        }
    }

    public static enum OverwriteFileSetting {
        failIfDirectoryExists,
        overwriteExistingFiles,
        deleteDirectoryIfExists;

    }
}

