/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.controler;

import java.io.IOException;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;
import org.matsim.core.controler.Controler;
import org.matsim.core.controler.OutputDirectoryHierarchy;
import org.matsim.core.gbl.Gbl;
import org.matsim.core.utils.io.CollectLogMessagesAppender;

public final class OutputDirectoryLogging {
    public static final String LOGFILE = "logfile.log";
    public static final String WARNLOGFILE = "logfileWarningsErrors.log";
    private static Logger log = Logger.getLogger(OutputDirectoryLogging.class);
    private static CollectLogMessagesAppender collectLogMessagesAppender = null;

    private OutputDirectoryLogging() {
    }

    public static void catchLogEntries() {
        if (collectLogMessagesAppender != null) {
            return;
        }
        collectLogMessagesAppender = new CollectLogMessagesAppender();
        Logger.getRootLogger().addAppender(collectLogMessagesAppender);
    }

    public static final void initLogging(OutputDirectoryHierarchy outputDirectoryHierarchy) {
        if (collectLogMessagesAppender != null) {
            Logger.getRootLogger().removeAppender(collectLogMessagesAppender);
        }
        try {
            String outputFilename = outputDirectoryHierarchy.getOutputFilename(LOGFILE);
            String warnLogfileName = outputDirectoryHierarchy.getOutputFilename(WARNLOGFILE);
            OutputDirectoryLogging.initLogging(outputFilename, warnLogfileName);
        }
        catch (IOException e) {
            log.error("Cannot create logfiles: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public static void initLoggingWithOutputDirectory(String outputDirectory) throws IOException {
        if (collectLogMessagesAppender != null) {
            Logger.getRootLogger().removeAppender(collectLogMessagesAppender);
        }
        String logfilename = outputDirectory + System.getProperty("file.separator") + LOGFILE;
        String warnlogfilename = outputDirectory + System.getProperty("file.separator") + WARNLOGFILE;
        OutputDirectoryLogging.initLogging(logfilename, warnlogfilename);
    }

    private static void initLogging(String outputFilename, String warnLogfileName) throws IOException {
        Logger root = Logger.getRootLogger();
        boolean appendToExistingFile = false;
        FileAppender appender = new FileAppender(Controler.DEFAULTLOG4JLAYOUT, outputFilename, false);
        appender.setName(LOGFILE);
        root.addAppender(appender);
        FileAppender warnErrorAppender = new FileAppender(Controler.DEFAULTLOG4JLAYOUT, warnLogfileName, false);
        warnErrorAppender.setName(WARNLOGFILE);
        warnErrorAppender.setThreshold(Level.WARN);
        root.addAppender(warnErrorAppender);
        if (collectLogMessagesAppender != null) {
            for (LoggingEvent e : collectLogMessagesAppender.getLogEvents()) {
                appender.append(e);
                if (!e.getLevel().isGreaterOrEqual(Level.WARN)) continue;
                warnErrorAppender.append(e);
            }
            collectLogMessagesAppender.close();
            collectLogMessagesAppender = null;
        }
        Gbl.printSystemInfo();
        Gbl.printBuildInfo();
    }

    public static void closeOutputDirLogging() {
        String endLoggingInfo = "closing the logfile, i.e. messages sent to the logger after this message are not written to the logfile.";
        log.info(endLoggingInfo);
        Logger root = Logger.getRootLogger();
        Appender app = root.getAppender(LOGFILE);
        if (app != null) {
            root.removeAppender(app);
            app.close();
        }
        if ((app = root.getAppender(WARNLOGFILE)) != null) {
            root.removeAppender(app);
            app.close();
        }
    }
}

