/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.controler;

import java.util.HashSet;
import javax.inject.Inject;
import javax.inject.Provider;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Scenario;
import org.matsim.api.core.v01.network.Network;
import org.matsim.api.core.v01.population.Population;
import org.matsim.core.config.groups.FacilitiesConfigGroup;
import org.matsim.core.config.groups.GlobalConfigGroup;
import org.matsim.core.config.groups.QSimConfigGroup;
import org.matsim.core.controler.PrepareForMobsim;
import org.matsim.core.network.NetworkUtils;
import org.matsim.core.network.algorithms.TransportModeNetworkFilter;
import org.matsim.core.population.algorithms.AbstractPersonAlgorithm;
import org.matsim.core.population.algorithms.ParallelPersonAlgorithmUtils;
import org.matsim.core.population.algorithms.PersonPrepareForSim;
import org.matsim.core.router.PlanRouter;
import org.matsim.core.router.TripRouter;
import org.matsim.facilities.ActivityFacilities;

public final class PrepareForMobsimImpl
implements PrepareForMobsim {
    private static Logger log = Logger.getLogger(PrepareForMobsimImpl.class);
    private final GlobalConfigGroup globalConfigGroup;
    private final Scenario scenario;
    private final Network network;
    private final Population population;
    private final ActivityFacilities activityFacilities;
    private final Provider<TripRouter> tripRouterProvider;
    private final QSimConfigGroup qSimConfigGroup;
    private final FacilitiesConfigGroup facilitiesConfigGroup;

    @Inject
    PrepareForMobsimImpl(GlobalConfigGroup globalConfigGroup, Scenario scenario, Network network, Population population, ActivityFacilities activityFacilities, Provider<TripRouter> tripRouterProvider, QSimConfigGroup qSimConfigGroup, FacilitiesConfigGroup facilitiesConfigGroup) {
        this.globalConfigGroup = globalConfigGroup;
        this.scenario = scenario;
        this.network = network;
        this.population = population;
        this.activityFacilities = activityFacilities;
        this.tripRouterProvider = tripRouterProvider;
        this.qSimConfigGroup = qSimConfigGroup;
        this.facilitiesConfigGroup = facilitiesConfigGroup;
    }

    @Override
    public void run() {
        Network carOnlyNetwork;
        if (NetworkUtils.isMultimodal(this.network)) {
            log.info("Network seems to be multimodal. Create car-only network which is handed over to PersonPrepareForSim.");
            TransportModeNetworkFilter filter = new TransportModeNetworkFilter(this.network);
            carOnlyNetwork = NetworkUtils.createNetwork();
            HashSet<String> modes = new HashSet<String>();
            modes.add("car");
            filter.filter(carOnlyNetwork, modes);
        } else {
            carOnlyNetwork = this.network;
        }
        ParallelPersonAlgorithmUtils.run(this.population, this.globalConfigGroup.getNumberOfThreads(), new ParallelPersonAlgorithmUtils.PersonAlgorithmProvider(){

            @Override
            public AbstractPersonAlgorithm getPersonAlgorithm() {
                return new PersonPrepareForSim(new PlanRouter((TripRouter)PrepareForMobsimImpl.this.tripRouterProvider.get(), PrepareForMobsimImpl.this.activityFacilities), PrepareForMobsimImpl.this.scenario, carOnlyNetwork);
            }
        });
    }
}

