/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.controler;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.Scenario;
import org.matsim.api.core.v01.network.Network;
import org.matsim.api.core.v01.population.Person;
import org.matsim.api.core.v01.population.Population;
import org.matsim.core.config.groups.FacilitiesConfigGroup;
import org.matsim.core.config.groups.GlobalConfigGroup;
import org.matsim.core.config.groups.QSimConfigGroup;
import org.matsim.core.controler.PrepareForMobsim;
import org.matsim.core.controler.PrepareForSim;
import org.matsim.core.controler.XY2LinksForFacilities;
import org.matsim.core.gbl.Gbl;
import org.matsim.core.network.NetworkUtils;
import org.matsim.core.network.algorithms.TransportModeNetworkFilter;
import org.matsim.core.population.algorithms.ParallelPersonAlgorithmUtils;
import org.matsim.core.population.algorithms.PersonPrepareForSim;
import org.matsim.core.router.PlanRouter;
import org.matsim.core.router.TripRouter;
import org.matsim.core.scenario.Lockable;
import org.matsim.facilities.ActivityFacilities;
import org.matsim.facilities.FacilitiesFromPopulation;
import org.matsim.vehicles.Vehicle;
import org.matsim.vehicles.VehicleType;
import org.matsim.vehicles.VehicleUtils;

public final class PrepareForSimImpl
implements PrepareForSim,
PrepareForMobsim {
    private static Logger log = Logger.getLogger(PrepareForSim.class);
    private final GlobalConfigGroup globalConfigGroup;
    private final Scenario scenario;
    private final Network network;
    private final Population population;
    private final ActivityFacilities activityFacilities;
    private final Provider<TripRouter> tripRouterProvider;
    private final QSimConfigGroup qSimConfigGroup;
    private final FacilitiesConfigGroup facilitiesConfigGroup;
    private static boolean hasWarned = false;

    @Inject
    PrepareForSimImpl(GlobalConfigGroup globalConfigGroup, Scenario scenario, Network network, Population population, ActivityFacilities activityFacilities, Provider<TripRouter> tripRouterProvider, QSimConfigGroup qSimConfigGroup, FacilitiesConfigGroup facilitiesConfigGroup) {
        this.globalConfigGroup = globalConfigGroup;
        this.scenario = scenario;
        this.network = network;
        this.population = population;
        this.activityFacilities = activityFacilities;
        this.tripRouterProvider = tripRouterProvider;
        this.qSimConfigGroup = qSimConfigGroup;
        this.facilitiesConfigGroup = facilitiesConfigGroup;
    }

    @Override
    public void run() {
        Network carOnlyNetwork;
        if (NetworkUtils.isMultimodal(this.network)) {
            log.info("Network seems to be multimodal. Create car-only network which is handed over to PersonPrepareForSim.");
            TransportModeNetworkFilter filter = new TransportModeNetworkFilter(this.network);
            carOnlyNetwork = NetworkUtils.createNetwork();
            HashSet<String> modes = new HashSet<String>();
            modes.add("car");
            filter.filter(carOnlyNetwork, modes);
        } else {
            carOnlyNetwork = this.network;
        }
        switch (this.facilitiesConfigGroup.getFacilitiesSource()) {
            case none: {
                break;
            }
            case fromFile: 
            case setInScenario: {
                Gbl.assertIf(!this.activityFacilities.getFacilities().isEmpty());
                break;
            }
            case onePerActivityLinkInPlansFile: 
            case onePerActivityLocationInPlansFile: {
                FacilitiesFromPopulation facilitiesFromPopulation = new FacilitiesFromPopulation(this.scenario);
                facilitiesFromPopulation.run(this.population);
                break;
            }
            default: {
                throw new RuntimeException("Facilities source '" + (Object)((Object)this.facilitiesConfigGroup.getFacilitiesSource()) + "' is not implemented.");
            }
        }
        XY2LinksForFacilities.run(carOnlyNetwork, this.activityFacilities);
        this.createAndAddVehiclesForEveryNetworkMode();
        ParallelPersonAlgorithmUtils.run(this.population, this.globalConfigGroup.getNumberOfThreads(), () -> new PersonPrepareForSim(new PlanRouter(this.tripRouterProvider.get(), this.activityFacilities), this.scenario, carOnlyNetwork));
        if (this.scenario instanceof Lockable) {
            ((Lockable)((Object)this.scenario)).setLocked();
        }
        if (this.population instanceof Lockable) {
            ((Lockable)((Object)this.population)).setLocked();
        }
        if (this.network instanceof Lockable) {
            ((Lockable)((Object)this.network)).setLocked();
        }
        if (this.activityFacilities instanceof Lockable) {
            ((Lockable)((Object)this.activityFacilities)).setLocked();
        }
    }

    private void createAndAddVehiclesForEveryNetworkMode() {
        Map<String, VehicleType> modeVehicleTypes = this.getVehicleTypesForAllNetworkAndMainModes();
        for (Map.Entry<String, VehicleType> modeType : modeVehicleTypes.entrySet()) {
            for (Person person : this.scenario.getPopulation().getPersons().values()) {
                Id<Vehicle> vehicleId = VehicleUtils.createVehicleId(person, modeType.getKey());
                if (this.qSimConfigGroup.getUsePersonIdForMissingVehicleId() && "car".equals(modeType.getKey())) {
                    if (!hasWarned) {
                        log.warn("'usePersonIdForMissingVehicleId' is deprecated. It will be removed soon.");
                        hasWarned = true;
                    }
                    vehicleId = Id.createVehicleId(person.getId());
                }
                this.createAndAddVehicleIfNecessary(vehicleId, modeType.getValue());
                VehicleUtils.insertVehicleIdIntoAttributes(person, modeType.getKey(), vehicleId);
            }
        }
    }

    private Map<String, VehicleType> getVehicleTypesForAllNetworkAndMainModes() {
        HashMap<String, VehicleType> modeVehicleTypes = new HashMap<String, VehicleType>();
        if (this.qSimConfigGroup.getVehiclesSource().equals((Object)QSimConfigGroup.VehiclesSource.fromVehiclesData)) {
            return modeVehicleTypes;
        }
        HashSet<String> modes = new HashSet<String>(this.qSimConfigGroup.getMainModes());
        modes.addAll(this.scenario.getConfig().plansCalcRoute().getNetworkModes());
        for (String mode : modes) {
            VehicleType type = null;
            switch (this.qSimConfigGroup.getVehiclesSource()) {
                case defaultVehicle: {
                    type = VehicleUtils.getDefaultVehicleType();
                    if (this.scenario.getVehicles().getVehicleTypes().containsKey(type.getId())) break;
                    this.scenario.getVehicles().addVehicleType(type);
                    break;
                }
                case modeVehicleTypesFromVehiclesData: {
                    type = this.scenario.getVehicles().getVehicleTypes().get(Id.create(mode, VehicleType.class));
                    break;
                }
                default: {
                    throw new RuntimeException(this.qSimConfigGroup.getVehiclesSource().toString() + " is not implemented yet.");
                }
            }
            Gbl.assertNotNull(type);
            modeVehicleTypes.put(mode, type);
        }
        return modeVehicleTypes;
    }

    private void createAndAddVehicleIfNecessary(Id<Vehicle> vehicleId, VehicleType vehicleType) {
        if (!this.scenario.getVehicles().getVehicles().containsKey(vehicleId)) {
            switch (this.qSimConfigGroup.getVehiclesSource()) {
                case defaultVehicle: 
                case modeVehicleTypesFromVehiclesData: {
                    Vehicle vehicle = this.scenario.getVehicles().getFactory().createVehicle(vehicleId, vehicleType);
                    this.scenario.getVehicles().addVehicle(vehicle);
                    break;
                }
                default: {
                    throw new RuntimeException("Expecting a vehicle id which is missing in the vehicles database: " + vehicleId);
                }
            }
        }
    }
}

