/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.controler;

import org.matsim.api.core.v01.Scenario;
import org.matsim.core.controler.AbstractModule;
import org.matsim.core.controler.DefaultPrepareForSimModule;
import org.matsim.core.controler.Injector;
import org.matsim.core.controler.PrepareForSim;
import org.matsim.core.events.EventsManagerModule;
import org.matsim.core.router.TripRouterModule;
import org.matsim.core.router.costcalculators.TravelDisutilityModule;
import org.matsim.core.scenario.ScenarioByInstanceModule;
import org.matsim.core.trafficmonitoring.TravelTimeCalculatorModule;

public class PrepareForSimUtils {
    public static PrepareForSim createDefaultPrepareForSim(final Scenario scenario) {
        com.google.inject.Injector injector = Injector.createInjector(scenario.getConfig(), new AbstractModule(){

            @Override
            public void install() {
                this.install(new ScenarioByInstanceModule(scenario));
                this.install(new EventsManagerModule());
                this.install(new TripRouterModule());
                this.install(new TravelDisutilityModule());
                this.install(new TravelTimeCalculatorModule());
                this.install(new DefaultPrepareForSimModule());
            }
        });
        return injector.getInstance(PrepareForSim.class);
    }
}

