/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.controler;

import java.util.Set;
import javax.inject.Inject;
import org.matsim.core.api.experimental.events.EventsManager;
import org.matsim.core.config.Config;
import org.matsim.core.controler.AbstractModule;
import org.matsim.core.controler.ControlerListenerManager;
import org.matsim.core.controler.ControlerListenerManagerImpl;
import org.matsim.core.controler.Injector;
import org.matsim.core.controler.events.AfterMobsimEvent;
import org.matsim.core.controler.events.BeforeMobsimEvent;
import org.matsim.core.controler.events.IterationEndsEvent;
import org.matsim.core.controler.events.IterationStartsEvent;
import org.matsim.core.controler.events.ShutdownEvent;
import org.matsim.core.controler.events.StartupEvent;
import org.matsim.core.controler.listener.AfterMobsimListener;
import org.matsim.core.controler.listener.BeforeMobsimListener;
import org.matsim.core.controler.listener.ControlerListener;
import org.matsim.core.controler.listener.IterationEndsListener;
import org.matsim.core.controler.listener.IterationStartsListener;
import org.matsim.core.controler.listener.ShutdownListener;
import org.matsim.core.controler.listener.StartupListener;
import org.matsim.core.events.MatsimEventsReader;

public final class ReplayEvents {
    @Inject
    Set<ControlerListener> controlerListenersDeclaredByModules;
    @Inject
    ControlerListenerManager controlerListenerManager;
    @Inject
    EventsManager eventsManager;

    public static Results run(Config config, String eventsFilename, final AbstractModule ... modules) {
        final com.google.inject.Injector injector = Injector.createInjector(config, new Module(), new AbstractModule(){

            @Override
            public void install() {
                for (AbstractModule module : modules) {
                    this.install(module);
                }
            }
        });
        ReplayEvents instance = injector.getInstance(ReplayEvents.class);
        instance.playEventsFile(eventsFilename, 1);
        return new Results(){

            @Override
            public <T> T get(Class<? extends T> type) {
                return injector.getInstance(type);
            }
        };
    }

    public void playEventsFile(String eventsFilename, int iterationNumber) {
        ((ControlerListenerManagerImpl)this.controlerListenerManager).fireControlerStartupEvent();
        for (ControlerListener controlerListener : this.controlerListenersDeclaredByModules) {
            if (!(controlerListener instanceof StartupListener)) continue;
            ((StartupListener)controlerListener).notifyStartup(new StartupEvent(null));
        }
        ((ControlerListenerManagerImpl)this.controlerListenerManager).fireControlerIterationStartsEvent(iterationNumber);
        for (ControlerListener controlerListener : this.controlerListenersDeclaredByModules) {
            if (!(controlerListener instanceof IterationStartsListener)) continue;
            ((IterationStartsListener)controlerListener).notifyIterationStarts(new IterationStartsEvent(null, iterationNumber));
        }
        ((ControlerListenerManagerImpl)this.controlerListenerManager).fireControlerBeforeMobsimEvent(iterationNumber);
        for (ControlerListener controlerListener : this.controlerListenersDeclaredByModules) {
            if (!(controlerListener instanceof BeforeMobsimListener)) continue;
            ((BeforeMobsimListener)controlerListener).notifyBeforeMobsim(new BeforeMobsimEvent(null, iterationNumber));
        }
        new MatsimEventsReader(this.eventsManager).readFile(eventsFilename);
        ((ControlerListenerManagerImpl)this.controlerListenerManager).fireControlerAfterMobsimEvent(iterationNumber);
        for (ControlerListener controlerListener : this.controlerListenersDeclaredByModules) {
            if (!(controlerListener instanceof AfterMobsimListener)) continue;
            ((AfterMobsimListener)controlerListener).notifyAfterMobsim(new AfterMobsimEvent(null, iterationNumber));
        }
        ((ControlerListenerManagerImpl)this.controlerListenerManager).fireControlerIterationEndsEvent(iterationNumber);
        for (ControlerListener controlerListener : this.controlerListenersDeclaredByModules) {
            if (!(controlerListener instanceof IterationEndsListener)) continue;
            ((IterationEndsListener)controlerListener).notifyIterationEnds(new IterationEndsEvent(null, iterationNumber));
        }
        ((ControlerListenerManagerImpl)this.controlerListenerManager).fireControlerShutdownEvent(false);
        for (ControlerListener controlerListener : this.controlerListenersDeclaredByModules) {
            if (!(controlerListener instanceof ShutdownListener)) continue;
            ((ShutdownListener)controlerListener).notifyShutdown(new ShutdownEvent(null, false));
        }
    }

    public static class Module
    extends AbstractModule {
        @Override
        public void install() {
            this.bind(ReplayEvents.class).asEagerSingleton();
            this.bind(ControlerListenerManager.class).to(ControlerListenerManagerImpl.class).asEagerSingleton();
        }
    }

    public static interface Results {
        public <T> T get(Class<? extends T> var1);
    }
}

