/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.controler;

import org.apache.log4j.Logger;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.network.Network;
import org.matsim.core.network.NetworkUtils;
import org.matsim.facilities.ActivityFacilities;
import org.matsim.facilities.ActivityFacility;
import org.matsim.facilities.ActivityFacilityImpl;

public class XY2LinksForFacilities {
    public static final Logger LOGGER = Logger.getLogger(XY2LinksForFacilities.class);

    public static void run(Network network, ActivityFacilities facilities) {
        int coordNullWarn = 0;
        int linkNullWarn = 0;
        for (ActivityFacility activityFacility : facilities.getFacilities().values()) {
            if (activityFacility.getCoord() == null && activityFacility.getLinkId() == null) {
                throw new RuntimeException("Neither coordinate nor linkId are available for facility id " + activityFacility.getId() + ". Aborting....");
            }
            if (activityFacility.getLinkId() == null) {
                Link link;
                if (linkNullWarn == 0) {
                    LOGGER.warn("There is no link for at least a facility. Assigning links for such facilities from coords.");
                    LOGGER.warn(" This message given only once.");
                    ++linkNullWarn;
                }
                if ((link = NetworkUtils.getNearestLink(network, activityFacility.getCoord())) == null) {
                    LOGGER.warn("No nearest link is found for coord " + activityFacility.getCoord());
                    continue;
                }
                ((ActivityFacilityImpl)activityFacility).setLinkId(link.getId());
                continue;
            }
            if (activityFacility.getCoord() != null || coordNullWarn != 0) continue;
            LOGGER.warn("There is no coord for the facility.");
            LOGGER.warn(" This message given only once.");
            ++coordNullWarn;
        }
    }
}

