/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.controler.corelisteners;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Collections;
import java.util.Map;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.network.Network;
import org.matsim.api.core.v01.population.Population;
import org.matsim.api.core.v01.population.PopulationWriter;
import org.matsim.core.config.Config;
import org.matsim.core.config.ConfigWriter;
import org.matsim.core.config.groups.ControlerConfigGroup;
import org.matsim.core.config.groups.VspExperimentalConfigGroup;
import org.matsim.core.controler.OutputDirectoryHierarchy;
import org.matsim.core.controler.corelisteners.DumpDataAtEnd;
import org.matsim.core.controler.events.ShutdownEvent;
import org.matsim.core.controler.listener.ShutdownListener;
import org.matsim.core.network.NetworkUtils;
import org.matsim.core.network.io.NetworkChangeEventsWriter;
import org.matsim.core.network.io.NetworkWriter;
import org.matsim.core.utils.geometry.CoordinateTransformation;
import org.matsim.core.utils.geometry.transformations.TransformationFactory;
import org.matsim.core.utils.io.UncheckedIOException;
import org.matsim.counts.Counts;
import org.matsim.counts.CountsWriter;
import org.matsim.facilities.ActivityFacilities;
import org.matsim.facilities.FacilitiesWriter;
import org.matsim.households.Households;
import org.matsim.households.HouseholdsWriterV10;
import org.matsim.lanes.Lanes;
import org.matsim.lanes.LanesWriter;
import org.matsim.pt.transitSchedule.api.Transit;
import org.matsim.pt.transitSchedule.api.TransitSchedule;
import org.matsim.pt.transitSchedule.api.TransitScheduleWriter;
import org.matsim.utils.objectattributes.AttributeConverter;
import org.matsim.vehicles.VehicleWriterV1;
import org.matsim.vehicles.Vehicles;

@Singleton
final class DumpDataAtEndImpl
implements DumpDataAtEnd,
ShutdownListener {
    private static final Logger log = Logger.getLogger(DumpDataAtEndImpl.class);
    @Inject
    private Config config;
    @Inject
    private ControlerConfigGroup controlerConfigGroup;
    @Inject
    private VspExperimentalConfigGroup vspConfig;
    @Inject
    private Network network;
    @Inject
    private Population population;
    @Inject
    private ActivityFacilities activityFacilities;
    @Inject
    private Vehicles vehicles;
    @Inject(optional=true)
    private TransitSchedule transitSchedule = null;
    @Inject(optional=true)
    @Transit
    private Vehicles transitVehicles = null;
    @Inject(optional=true)
    private Counts<Link> counts = null;
    @Inject
    private Households households;
    @Inject
    private Lanes lanes;
    @Inject
    private OutputDirectoryHierarchy controlerIO;
    @Inject
    private Map<Class<?>, AttributeConverter<?>> attributeConverters = Collections.emptyMap();

    DumpDataAtEndImpl() {
    }

    @Override
    public void notifyShutdown(ShutdownEvent event) {
        if (event.isUnexpected()) {
            return;
        }
        this.dumpPlans();
        this.dumpNetwork();
        this.dumpConfig();
        this.dumpFacilities();
        this.dumpNetworkChangeEvents();
        this.dumpTransitSchedule();
        this.dumpTransitVehicles();
        this.dumpVehicles();
        this.dumpHouseholds();
        this.dumpLanes();
        this.dumpCounts();
        if (!event.isUnexpected() && this.vspConfig.isWritingOutputEvents() && this.controlerConfigGroup.getWriteEventsInterval() != 0) {
            this.dumpOutputEvents();
        }
        this.dumpExperiencedPlans();
    }

    private void dumpOutputEvents() {
        try {
            File toFile = new File(this.controlerIO.getOutputFilename("output_events.xml.gz"));
            File fromFile = new File(this.controlerIO.getIterationFilename(this.controlerConfigGroup.getLastIteration(), "events.xml.gz"));
            try {
                Files.copy(fromFile.toPath(), toFile.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        catch (Exception ee) {
            Logger.getLogger(this.getClass()).error("writing output events did not work; probably parameters were such that no events were generated in the final iteration");
        }
    }

    private void dumpExperiencedPlans() {
        if (this.config.planCalcScore().isWriteExperiencedPlans()) {
            try {
                File toFile = new File(this.controlerIO.getOutputFilename("output_experienced_plans.xml.gz"));
                File fromFile = new File(this.controlerIO.getIterationFilename(this.controlerConfigGroup.getLastIteration(), "experienced_plans.xml.gz"));
                try {
                    Files.copy(fromFile.toPath(), toFile.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            catch (Exception ee) {
                Logger.getLogger(this.getClass()).error("writing output experienced plans did not work; probably parameters were such that they were not generated in the final iteration", ee);
            }
        }
    }

    private void dumpCounts() {
        try {
            if (this.counts != null) {
                String inputCRS = this.config.counts().getInputCRS();
                String internalCRS = this.config.global().getCoordinateSystem();
                if (inputCRS == null) {
                    new CountsWriter(this.counts).write(this.controlerIO.getOutputFilename("output_counts.xml.gz"));
                } else {
                    log.info("re-projecting counts from " + internalCRS + " back to " + inputCRS + " for export");
                    CoordinateTransformation transformation = TransformationFactory.getCoordinateTransformation(internalCRS, inputCRS);
                    new CountsWriter(transformation, this.counts).write(this.controlerIO.getOutputFilename("output_counts.xml.gz"));
                }
            }
        }
        catch (Exception ee) {
            log.error("Exception writing counts.", ee);
        }
    }

    private void dumpLanes() {
        try {
            new LanesWriter(this.lanes).write(this.controlerIO.getOutputFilename("output_lanes.xml.gz"));
        }
        catch (Exception ee) {
            log.error("Exception writing lanes.", ee);
        }
    }

    private void dumpHouseholds() {
        try {
            new HouseholdsWriterV10(this.households).writeFile(this.controlerIO.getOutputFilename("output_households.xml.gz"));
        }
        catch (Exception ee) {
            log.error("Exception writing households.", ee);
        }
    }

    private void dumpVehicles() {
        try {
            new VehicleWriterV1(this.vehicles).writeFile(this.controlerIO.getOutputFilename("output_vehicles.xml.gz"));
        }
        catch (Exception ee) {
            log.error("Exception writing vehicles.", ee);
        }
    }

    private void dumpTransitVehicles() {
        try {
            if (this.transitVehicles != null) {
                new VehicleWriterV1(this.transitVehicles).writeFile(this.controlerIO.getOutputFilename("output_transitVehicles.xml.gz"));
            }
        }
        catch (Exception ee) {
            log.error("Exception writing transit vehicles.", ee);
        }
    }

    private void dumpTransitSchedule() {
        try {
            if (this.transitSchedule != null) {
                String inputCRS = this.config.transit().getInputScheduleCRS();
                String internalCRS = this.config.global().getCoordinateSystem();
                new TransitScheduleWriter(this.transitSchedule).writeFile(this.controlerIO.getOutputFilename("output_transitSchedule.xml.gz"));
            }
        }
        catch (Exception ee) {
            log.error("Exception writing transit schedule.", ee);
        }
    }

    private void dumpNetworkChangeEvents() {
        if (this.config.network().isTimeVariantNetwork()) {
            new NetworkChangeEventsWriter().write(this.controlerIO.getOutputFilename("output_change_events.xml.gz"), NetworkUtils.getNetworkChangeEvents(this.network));
        }
    }

    private void dumpFacilities() {
        try {
            String inputCRS = this.config.facilities().getInputCRS();
            String internalCRS = this.config.global().getCoordinateSystem();
            new FacilitiesWriter(this.activityFacilities).write(this.controlerIO.getOutputFilename("output_facilities.xml.gz"));
        }
        catch (Exception ee) {
            log.error("Exception writing facilities.", ee);
        }
    }

    private void dumpConfig() {
        new ConfigWriter(this.config).write(this.controlerIO.getOutputFilename("output_config.xml"));
        new ConfigWriter(this.config, ConfigWriter.Verbosity.minimal).write(this.controlerIO.getOutputFilename("output_config_reduced.xml"));
    }

    private void dumpNetwork() {
        new NetworkWriter(this.network).write(this.controlerIO.getOutputFilename("output_network.xml.gz"));
    }

    private void dumpPlans() {
        PopulationWriter writer = new PopulationWriter(this.population, this.network);
        writer.putAttributeConverters(this.attributeConverters);
        writer.write(this.controlerIO.getOutputFilename("output_plans.xml.gz"));
    }
}

