/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.controler.corelisteners;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.matsim.core.api.experimental.events.EventsManager;
import org.matsim.core.config.groups.ControlerConfigGroup;
import org.matsim.core.controler.OutputDirectoryHierarchy;
import org.matsim.core.controler.corelisteners.EventsHandling;
import org.matsim.core.controler.events.BeforeMobsimEvent;
import org.matsim.core.controler.events.IterationEndsEvent;
import org.matsim.core.controler.events.ShutdownEvent;
import org.matsim.core.controler.listener.BeforeMobsimListener;
import org.matsim.core.controler.listener.IterationEndsListener;
import org.matsim.core.controler.listener.ShutdownListener;
import org.matsim.core.events.algorithms.EventWriter;
import org.matsim.core.events.algorithms.EventWriterXML;

@Singleton
final class EventsHandlingImpl
implements EventsHandling,
BeforeMobsimListener,
IterationEndsListener,
ShutdownListener {
    private static final Logger log = Logger.getLogger(EventsHandlingImpl.class);
    private final EventsManager eventsManager;
    private final int lastIteration;
    private List<EventWriter> eventWriters = new LinkedList<EventWriter>();
    private int writeEventsInterval;
    private Set<ControlerConfigGroup.EventsFileFormat> eventsFileFormats;
    private OutputDirectoryHierarchy controlerIO;
    private int writeMoreUntilIteration;

    @Inject
    EventsHandlingImpl(EventsManager eventsManager, ControlerConfigGroup config, OutputDirectoryHierarchy controlerIO) {
        this.eventsManager = eventsManager;
        this.writeEventsInterval = config.getWriteEventsInterval();
        this.lastIteration = config.getLastIteration();
        this.eventsFileFormats = config.getEventsFileFormats();
        this.controlerIO = controlerIO;
        this.writeMoreUntilIteration = config.getWriteEventsUntilIteration();
    }

    @Override
    public void notifyBeforeMobsim(BeforeMobsimEvent event) {
        boolean lastIteration;
        this.eventsManager.resetHandlers(event.getIteration());
        boolean writingEventsAtAll = this.writeEventsInterval > 0;
        boolean regularWriteEvents = writingEventsAtAll && event.getIteration() > 0 && event.getIteration() % this.writeEventsInterval == 0;
        boolean earlyIteration = event.getIteration() <= this.writeMoreUntilIteration;
        boolean bl = lastIteration = event.getIteration() == this.lastIteration;
        if (writingEventsAtAll && (regularWriteEvents || earlyIteration || lastIteration)) {
            block3: for (ControlerConfigGroup.EventsFileFormat format : this.eventsFileFormats) {
                switch (format) {
                    case xml: {
                        this.eventWriters.add(new EventWriterXML(this.controlerIO.getIterationFilename(event.getIteration(), "events.xml.gz")));
                        continue block3;
                    }
                }
                log.warn("Unknown events file format specified: " + format.toString() + ".");
            }
            for (EventWriter writer : this.eventWriters) {
                this.eventsManager.addHandler(writer);
            }
        }
    }

    @Override
    public void notifyIterationEnds(IterationEndsEvent event) {
        for (EventWriter writer : this.eventWriters) {
            writer.closeFile();
            this.eventsManager.removeHandler(writer);
        }
        this.eventWriters.clear();
    }

    @Override
    public void notifyShutdown(ShutdownEvent event) {
        for (EventWriter writer : this.eventWriters) {
            writer.closeFile();
        }
    }
}

