/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.controler.corelisteners;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import org.apache.log4j.Logger;
import org.matsim.analysis.IterationStopWatch;
import org.matsim.api.core.v01.network.Network;
import org.matsim.api.core.v01.population.Population;
import org.matsim.api.core.v01.population.PopulationWriter;
import org.matsim.core.config.Config;
import org.matsim.core.config.groups.ControlerConfigGroup;
import org.matsim.core.controler.OutputDirectoryHierarchy;
import org.matsim.core.controler.corelisteners.PlansDumping;
import org.matsim.core.controler.events.BeforeMobsimEvent;
import org.matsim.core.controler.listener.BeforeMobsimListener;
import org.matsim.core.utils.geometry.CoordinateTransformation;
import org.matsim.core.utils.geometry.transformations.TransformationFactory;

@Singleton
final class PlansDumpingImpl
implements PlansDumping,
BeforeMobsimListener {
    private static final Logger log = Logger.getLogger(PlansDumpingImpl.class);
    @Inject
    private Config config;
    @Inject
    private Network network;
    @Inject
    private Population population;
    @Inject
    private IterationStopWatch stopwatch;
    @Inject
    private OutputDirectoryHierarchy controlerIO;
    private int writePlansInterval;
    private int writeMoreUntilIteration;

    @Inject
    PlansDumpingImpl(ControlerConfigGroup config) {
        this.writePlansInterval = config.getWritePlansInterval();
        this.writeMoreUntilIteration = config.getWritePlansUntilIteration();
    }

    @Override
    public void notifyBeforeMobsim(BeforeMobsimEvent event) {
        boolean earlyIteration;
        boolean writingPlansAtAll = this.writePlansInterval > 0;
        boolean regularWritePlans = writingPlansAtAll && event.getIteration() > 0 && event.getIteration() % this.writePlansInterval == 0;
        boolean bl = earlyIteration = event.getIteration() <= this.writeMoreUntilIteration;
        if (writingPlansAtAll && (regularWritePlans || earlyIteration)) {
            this.stopwatch.beginOperation("dump all plans");
            log.info("dumping plans...");
            String inputCRS = this.config.plans().getInputCRS();
            String internalCRS = this.config.global().getCoordinateSystem();
            if (inputCRS == null) {
                new PopulationWriter(this.population, this.network).write(this.controlerIO.getIterationFilename(event.getIteration(), "plans.xml.gz"));
            } else {
                log.info("re-projecting population from " + internalCRS + " back to " + inputCRS + " for export");
                CoordinateTransformation transformation = TransformationFactory.getCoordinateTransformation(internalCRS, inputCRS);
                new PopulationWriter(transformation, this.population, this.network).write(this.controlerIO.getIterationFilename(event.getIteration(), "plans.xml.gz"));
            }
            log.info("finished plans dump.");
            this.stopwatch.endOperation("dump all plans");
        }
    }
}

