/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.controler.corelisteners;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import javax.inject.Provider;
import org.matsim.api.core.v01.population.Population;
import org.matsim.core.controler.corelisteners.PlansReplanning;
import org.matsim.core.controler.events.ReplanningEvent;
import org.matsim.core.controler.listener.ReplanningListener;
import org.matsim.core.replanning.ReplanningContext;
import org.matsim.core.replanning.StrategyManager;

@Singleton
final class PlansReplanningImpl
implements PlansReplanning,
ReplanningListener {
    private final Provider<ReplanningContext> replanningContextProvider;
    private Population population;
    private StrategyManager strategyManager;

    @Inject
    PlansReplanningImpl(StrategyManager strategyManager, Population pop, Provider<ReplanningContext> replanningContextProvider) {
        this.population = pop;
        this.strategyManager = strategyManager;
        this.replanningContextProvider = replanningContextProvider;
    }

    @Override
    public void notifyReplanning(ReplanningEvent event) {
        this.strategyManager.run(this.population, event.getIteration(), this.replanningContextProvider.get());
    }
}

