/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.events;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.events.LinkEnterEvent;
import org.matsim.api.core.v01.events.LinkLeaveEvent;
import org.matsim.api.core.v01.events.PersonLeavesVehicleEvent;
import org.matsim.api.core.v01.events.VehicleEntersTrafficEvent;
import org.matsim.api.core.v01.events.VehicleLeavesTrafficEvent;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.population.Person;
import org.matsim.core.api.experimental.events.EventsManager;
import org.matsim.core.events.EventsReaderXMLv1;
import org.matsim.core.utils.io.MatsimXmlParser;
import org.matsim.vehicles.Vehicle;
import org.xml.sax.Attributes;

public final class EventsConverterXML
extends MatsimXmlParser {
    private static final String EVENT = "event";
    private static final String ATTRIBUTE_PERSON = "person";
    private final EventsManager events;
    private final EventsReaderXMLv1 basicEventsReader;
    private boolean containsVehicleLeavesTrafficEvents = false;
    private Map<Id<Person>, Id<Vehicle>> driverToVeh = new HashMap<Id<Person>, Id<Vehicle>>();
    private Map<Id<Person>, String> personToLegMode = new HashMap<Id<Person>, String>();

    public EventsConverterXML(EventsManager events) {
        this.events = events;
        this.setValidating(false);
        this.basicEventsReader = new EventsReaderXMLv1(events);
    }

    @Override
    public void startTag(String name, Attributes atts, Stack<String> context) {
        if (EVENT.equals(name)) {
            String eventType;
            double time = Double.parseDouble(atts.getValue("time"));
            switch (eventType = atts.getValue("type")) {
                case "departure": {
                    this.personToLegMode.put(Id.createPersonId(atts.getValue(ATTRIBUTE_PERSON)), atts.getValue("legMode"));
                    this.basicEventsReader.startTag(name, atts, context);
                    break;
                }
                case "vehicle enters traffic": 
                case "wait2link": {
                    Id<Person> driverId = Id.createPersonId(atts.getValue(ATTRIBUTE_PERSON));
                    Id<Vehicle> vehicleId = atts.getValue("vehicle") == null || atts.getValue("vehicle").equals("null") ? Id.create(driverId, Vehicle.class) : Id.create(atts.getValue("vehicle"), Vehicle.class);
                    assert (vehicleId != null);
                    String networkMode = atts.getValue("networkMode");
                    if (networkMode == null) {
                        networkMode = this.personToLegMode.get(driverId);
                    }
                    this.driverToVeh.put(driverId, vehicleId);
                    this.events.processEvent(new VehicleEntersTrafficEvent(time, driverId, Id.createLinkId(atts.getValue("link")), vehicleId, networkMode, 1.0));
                    break;
                }
                case "entered link": {
                    if (atts.getValue("vehicle") == null || atts.getValue("vehicle").equals("null")) {
                        this.events.processEvent(new LinkEnterEvent(time, this.driverToVeh.get(Id.createPersonId(atts.getValue(ATTRIBUTE_PERSON))), Id.create(atts.getValue("link"), Link.class)));
                        break;
                    }
                    this.basicEventsReader.startTag(name, atts, context);
                    break;
                }
                case "left link": {
                    if (atts.getValue("vehicle") == null || atts.getValue("vehicle").equals("null")) {
                        Id<Person> personId = Id.createPersonId(atts.getValue(ATTRIBUTE_PERSON));
                        assert (personId != null);
                        Id<Link> linkId = Id.create(atts.getValue("link"), Link.class);
                        assert (linkId != null);
                        Id<Vehicle> vehicleId = this.driverToVeh.get(personId);
                        assert (vehicleId != null);
                        this.events.processEvent(new LinkLeaveEvent(time, vehicleId, linkId));
                        break;
                    }
                    this.basicEventsReader.startTag(name, atts, context);
                    break;
                }
                case "vehicle leaves traffic": {
                    this.containsVehicleLeavesTrafficEvents = true;
                    this.basicEventsReader.startTag(name, atts, context);
                    break;
                }
                case "PersonLeavesVehicle": {
                    if (this.driverToVeh.containsKey(Id.createPersonId(atts.getValue(ATTRIBUTE_PERSON))) && !this.containsVehicleLeavesTrafficEvents) break;
                    this.basicEventsReader.startTag(name, atts, context);
                    break;
                }
                case "arrival": {
                    Id<Person> personId = Id.createPersonId(atts.getValue(ATTRIBUTE_PERSON));
                    Id<Link> linkId = Id.createLinkId(atts.getValue("link"));
                    String mode = atts.getValue("legMode");
                    if (this.driverToVeh.containsKey(personId) && !this.containsVehicleLeavesTrafficEvents) {
                        Id<Vehicle> vehicleIdOfDriver = this.driverToVeh.remove(personId);
                        this.events.processEvent(new VehicleLeavesTrafficEvent(time, personId, linkId, vehicleIdOfDriver, mode, 1.0));
                        this.events.processEvent(new PersonLeavesVehicleEvent(time, personId, vehicleIdOfDriver));
                    }
                    this.basicEventsReader.startTag(name, atts, context);
                    break;
                }
                default: {
                    this.basicEventsReader.startTag(name, atts, context);
                }
            }
        }
    }

    @Override
    public void endTag(String name, String content, Stack<String> context) {
    }
}

