/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.events;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.events.ActivityEndEvent;
import org.matsim.api.core.v01.events.ActivityStartEvent;
import org.matsim.api.core.v01.events.Event;
import org.matsim.api.core.v01.events.LinkEnterEvent;
import org.matsim.api.core.v01.events.LinkLeaveEvent;
import org.matsim.api.core.v01.events.PersonArrivalEvent;
import org.matsim.api.core.v01.events.PersonDepartureEvent;
import org.matsim.api.core.v01.events.PersonEntersVehicleEvent;
import org.matsim.api.core.v01.events.PersonLeavesVehicleEvent;
import org.matsim.api.core.v01.events.PersonMoneyEvent;
import org.matsim.api.core.v01.events.PersonStuckEvent;
import org.matsim.api.core.v01.events.TransitDriverStartsEvent;
import org.matsim.api.core.v01.events.VehicleEntersTrafficEvent;
import org.matsim.api.core.v01.events.handler.ActivityEndEventHandler;
import org.matsim.api.core.v01.events.handler.ActivityStartEventHandler;
import org.matsim.api.core.v01.events.handler.LinkEnterEventHandler;
import org.matsim.api.core.v01.events.handler.LinkLeaveEventHandler;
import org.matsim.api.core.v01.events.handler.PersonArrivalEventHandler;
import org.matsim.api.core.v01.events.handler.PersonDepartureEventHandler;
import org.matsim.api.core.v01.events.handler.PersonEntersVehicleEventHandler;
import org.matsim.api.core.v01.events.handler.PersonLeavesVehicleEventHandler;
import org.matsim.api.core.v01.events.handler.PersonMoneyEventHandler;
import org.matsim.api.core.v01.events.handler.PersonStuckEventHandler;
import org.matsim.api.core.v01.events.handler.TransitDriverStartsEventHandler;
import org.matsim.api.core.v01.events.handler.VehicleEntersTrafficEventHandler;
import org.matsim.core.api.experimental.events.AgentWaitingForPtEvent;
import org.matsim.core.api.experimental.events.EventsManager;
import org.matsim.core.api.experimental.events.VehicleArrivesAtFacilityEvent;
import org.matsim.core.api.experimental.events.VehicleDepartsAtFacilityEvent;
import org.matsim.core.api.experimental.events.handler.AgentWaitingForPtEventHandler;
import org.matsim.core.api.experimental.events.handler.VehicleArrivesAtFacilityEventHandler;
import org.matsim.core.api.experimental.events.handler.VehicleDepartsAtFacilityEventHandler;
import org.matsim.core.events.handler.BasicEventHandler;
import org.matsim.core.events.handler.EventHandler;

public final class EventsManagerImpl
implements EventsManager {
    private static final Logger log = Logger.getLogger(EventsManagerImpl.class);
    private final List<HandlerData> handlerData = new ArrayList<HandlerData>();
    private final Map<Class<?>, HandlerInfo[]> cacheHandlers = new ConcurrentHashMap(15);
    private long counter = 0L;
    private long nextCounterMsg = 1L;

    private HandlerData findHandler(Class<?> evklass) {
        for (HandlerData handler : this.handlerData) {
            if (handler.eventklass != evklass) continue;
            return handler;
        }
        return null;
    }

    @Override
    public void processEvent(Event event) {
        ++this.counter;
        if (this.counter == this.nextCounterMsg) {
            this.nextCounterMsg *= 4L;
            log.info(" event # " + this.counter);
        }
        this.computeEvent(event);
    }

    @Override
    public void addHandler(EventHandler handler) {
        Class<?> test;
        HashSet addedHandlers = new HashSet();
        log.info("adding Event-Handler: " + test.getName());
        for (test = handler.getClass(); test != Object.class; test = test.getSuperclass()) {
            for (Class<?> theInterface : test.getInterfaces()) {
                if (addedHandlers.contains(theInterface)) continue;
                log.info("  " + theInterface.getName());
                this.addHandlerInterfaces(handler, theInterface);
                addedHandlers.add(theInterface);
            }
        }
        this.cacheHandlers.clear();
        log.info("");
    }

    @Override
    public void removeHandler(EventHandler handler) {
        log.info("removing Event-Handler: " + handler.getClass().getName());
        for (HandlerData handlerList : this.handlerData) {
            handlerList.removeHandler(handler);
        }
        this.cacheHandlers.clear();
    }

    @Override
    public void resetHandlers(int iteration) {
        log.info("resetting Event-Handlers");
        this.counter = 0L;
        this.nextCounterMsg = 1L;
        HashSet<EventHandler> resetHandlers = new HashSet<EventHandler>();
        for (HandlerData handlerdata : this.handlerData) {
            for (EventHandler handler : handlerdata.handlerList) {
                if (resetHandlers.contains(handler)) continue;
                log.info("  " + handler.getClass().getName());
                handler.reset(iteration);
                resetHandlers.add(handler);
            }
        }
    }

    @Override
    public void initProcessing() {
    }

    @Override
    public void afterSimStep(double time) {
    }

    @Override
    public void finishProcessing() {
    }

    private void addHandlerInterfaces(EventHandler handler, Class<?> handlerClass) {
        Method[] classmethods;
        for (Method method : classmethods = handlerClass.getMethods()) {
            Class<?>[] params;
            if (!method.getName().equals("handleEvent") || (params = method.getParameterTypes()).length != 1) continue;
            Class<?> eventClass = params[0];
            log.info("    > " + eventClass.getName());
            HandlerData dat = this.findHandler(eventClass);
            if (dat == null) {
                dat = new HandlerData(eventClass, method);
                this.handlerData.add(dat);
            }
            dat.handlerList.add(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeEvent(Event event) {
        for (HandlerInfo info : this.getHandlersForClass(event.getClass())) {
            EventHandler eventHandler = info.eventHandler;
            synchronized (eventHandler) {
                if (this.callHandlerFast(info.eventClass, event, info.eventHandler)) {
                    continue;
                }
                try {
                    info.method.invoke((Object)info.eventHandler, event);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    throw new RuntimeException("problem invoking EventHandler " + info.eventHandler.getClass().getCanonicalName() + " for event-class " + info.eventClass.getCanonicalName(), e);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException("problem invoking EventHandler " + info.eventHandler.getClass().getCanonicalName() + " for event-class " + info.eventClass.getCanonicalName(), e.getCause());
                }
            }
        }
    }

    private HandlerInfo[] getHandlersForClass(Class<?> eventClass) {
        HandlerInfo[] cache = this.cacheHandlers.get(eventClass);
        if (cache != null) {
            return cache;
        }
        ArrayList<HandlerInfo> info = new ArrayList<HandlerInfo>();
        for (Class<?> klass = eventClass; klass != Object.class; klass = klass.getSuperclass()) {
            HandlerData dat = this.findHandler(klass);
            if (dat == null) continue;
            for (EventHandler handler : dat.handlerList) {
                info.add(new HandlerInfo(klass, handler, dat.method));
            }
        }
        for (Class<?> intfc : this.getAllInterfaces(eventClass)) {
            HandlerData dat = this.findHandler(intfc);
            if (dat == null) continue;
            for (EventHandler handler : dat.handlerList) {
                info.add(new HandlerInfo(intfc, handler, dat.method));
            }
        }
        cache = info.toArray(new HandlerInfo[info.size()]);
        this.cacheHandlers.put(eventClass, cache);
        return cache;
    }

    private Set<Class<?>> getAllInterfaces(Class<?> klass) {
        HashSet intfs = new HashSet();
        for (Class<?> intf : klass.getInterfaces()) {
            intfs.add(intf);
            intfs.addAll(this.getAllInterfaces(intf));
        }
        if (!klass.isInterface()) {
            for (Class<?> superclass = klass.getSuperclass(); superclass != Object.class; superclass = superclass.getSuperclass()) {
                intfs.addAll(this.getAllInterfaces(superclass));
            }
        }
        return intfs;
    }

    private boolean callHandlerFast(Class<?> klass, Event ev, EventHandler handler) {
        if (klass == LinkLeaveEvent.class) {
            ((LinkLeaveEventHandler)handler).handleEvent((LinkLeaveEvent)ev);
            return true;
        }
        if (klass == LinkEnterEvent.class) {
            ((LinkEnterEventHandler)handler).handleEvent((LinkEnterEvent)ev);
            return true;
        }
        if (klass == VehicleEntersTrafficEvent.class) {
            ((VehicleEntersTrafficEventHandler)handler).handleEvent((VehicleEntersTrafficEvent)ev);
            return true;
        }
        if (klass == PersonArrivalEvent.class) {
            ((PersonArrivalEventHandler)handler).handleEvent((PersonArrivalEvent)ev);
            return true;
        }
        if (klass == PersonDepartureEvent.class) {
            ((PersonDepartureEventHandler)handler).handleEvent((PersonDepartureEvent)ev);
            return true;
        }
        if (klass == ActivityEndEvent.class) {
            ((ActivityEndEventHandler)handler).handleEvent((ActivityEndEvent)ev);
            return true;
        }
        if (klass == ActivityStartEvent.class) {
            ((ActivityStartEventHandler)handler).handleEvent((ActivityStartEvent)ev);
            return true;
        }
        if (klass == TransitDriverStartsEvent.class) {
            ((TransitDriverStartsEventHandler)handler).handleEvent((TransitDriverStartsEvent)ev);
            return true;
        }
        if (klass == PersonStuckEvent.class) {
            ((PersonStuckEventHandler)handler).handleEvent((PersonStuckEvent)ev);
            return true;
        }
        if (klass == PersonMoneyEvent.class) {
            ((PersonMoneyEventHandler)handler).handleEvent((PersonMoneyEvent)ev);
            return true;
        }
        if (klass == AgentWaitingForPtEvent.class) {
            ((AgentWaitingForPtEventHandler)handler).handleEvent((AgentWaitingForPtEvent)ev);
            return true;
        }
        if (klass == PersonEntersVehicleEvent.class) {
            ((PersonEntersVehicleEventHandler)handler).handleEvent((PersonEntersVehicleEvent)ev);
            return true;
        }
        if (klass == PersonLeavesVehicleEvent.class) {
            ((PersonLeavesVehicleEventHandler)handler).handleEvent((PersonLeavesVehicleEvent)ev);
            return true;
        }
        if (klass == VehicleDepartsAtFacilityEvent.class) {
            ((VehicleDepartsAtFacilityEventHandler)handler).handleEvent((VehicleDepartsAtFacilityEvent)ev);
            return true;
        }
        if (klass == VehicleArrivesAtFacilityEvent.class) {
            ((VehicleArrivesAtFacilityEventHandler)handler).handleEvent((VehicleArrivesAtFacilityEvent)ev);
            return true;
        }
        if (klass == Event.class) {
            ((BasicEventHandler)handler).handleEvent(ev);
            return true;
        }
        return false;
    }

    public void printEventHandlers() {
        log.info("currently registered event-handlers:");
        for (HandlerData handlerType : this.handlerData) {
            log.info("+ " + handlerType.eventklass.getName());
            for (EventHandler handler : handlerType.handlerList) {
                log.info("  - " + handler.getClass().getName());
            }
        }
    }

    private static class HandlerInfo {
        protected final Class<?> eventClass;
        protected final EventHandler eventHandler;
        protected final Method method;

        protected HandlerInfo(Class<?> eventClass, EventHandler eventHandler, Method method) {
            this.eventClass = eventClass;
            this.eventHandler = eventHandler;
            this.method = method;
        }
    }

    private static class HandlerData {
        protected Class<?> eventklass;
        protected ArrayList<EventHandler> handlerList = new ArrayList(5);
        protected Method method;

        protected HandlerData(Class<?> eventklass, Method method) {
            this.eventklass = eventklass;
            this.method = method;
        }

        protected void removeHandler(EventHandler handler) {
            this.handlerList.remove(handler);
        }
    }
}

