/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.events;

import java.util.Set;
import javax.inject.Inject;
import org.matsim.core.api.experimental.events.EventsManager;
import org.matsim.core.controler.AbstractModule;
import org.matsim.core.events.ParallelEventsManager;
import org.matsim.core.events.ParallelEventsManagerImpl;
import org.matsim.core.events.SimStepParallelEventsManagerImpl;
import org.matsim.core.events.handler.EventHandler;

public final class EventsManagerModule
extends AbstractModule {
    @Override
    public void install() {
        if (this.getConfig().parallelEventHandling().getOneThreadPerHandler() != null && this.getConfig().parallelEventHandling().getOneThreadPerHandler().booleanValue()) {
            this.bindEventsManager().to(ParallelEventsManager.class).asEagerSingleton();
        } else if (this.getConfig().parallelEventHandling().getNumberOfThreads() != null) {
            if (this.getConfig().parallelEventHandling().getSynchronizeOnSimSteps() != null && this.getConfig().parallelEventHandling().getSynchronizeOnSimSteps().booleanValue()) {
                this.bindEventsManager().to(SimStepParallelEventsManagerImpl.class).asEagerSingleton();
            } else {
                this.bindEventsManager().to(ParallelEventsManagerImpl.class).asEagerSingleton();
            }
        } else {
            this.bindEventsManager().to(SimStepParallelEventsManagerImpl.class).asEagerSingleton();
        }
        this.bind(EventHandlerRegistrator.class).asEagerSingleton();
    }

    public static class EventHandlerRegistrator {
        @Inject
        EventHandlerRegistrator(EventsManager eventsManager, Set<EventHandler> eventHandlersDeclaredByModules) {
            for (EventHandler eventHandler : eventHandlersDeclaredByModules) {
                eventsManager.addHandler(eventHandler);
            }
        }
    }
}

