/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.events;

import java.io.BufferedReader;
import java.io.IOException;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.events.ActivityEndEvent;
import org.matsim.api.core.v01.events.ActivityStartEvent;
import org.matsim.api.core.v01.events.Event;
import org.matsim.api.core.v01.events.LinkEnterEvent;
import org.matsim.api.core.v01.events.LinkLeaveEvent;
import org.matsim.api.core.v01.events.PersonArrivalEvent;
import org.matsim.api.core.v01.events.PersonDepartureEvent;
import org.matsim.api.core.v01.events.VehicleEntersTrafficEvent;
import org.matsim.api.core.v01.network.Link;
import org.matsim.core.api.experimental.events.EventsManager;
import org.matsim.core.events.algorithms.EventWriterTXT;
import org.matsim.core.utils.io.IOUtils;
import org.matsim.core.utils.misc.StringUtils;
import org.matsim.vehicles.Vehicle;

public final class EventsReaderTXT {
    private final EventsManager em;

    public EventsReaderTXT(EventsManager em) {
        this.em = em;
    }

    public void runEventsFile(String file) throws IOException {
        BufferedReader br = IOUtils.getBufferedReader(file);
        String l = br.readLine();
        l = br.readLine();
        while (l != null) {
            String[] expl = StringUtils.explode(l, '\t');
            double time = Double.parseDouble(expl[0]);
            Id<Vehicle> vehicleId = Id.create(expl[1], Vehicle.class);
            Id<Link> linkId = Id.createLinkId(expl[3]);
            String type = expl[5];
            Event e = null;
            int typeIndex = Integer.parseInt(type);
            if (typeIndex == EventWriterTXT.Number.ActivityEnd.ordinal()) {
                e = new ActivityEndEvent(time, Id.createPersonId(vehicleId), linkId, null, null);
            } else if (typeIndex == EventWriterTXT.Number.PersonDeparture.ordinal()) {
                e = new PersonDepartureEvent(time, Id.createPersonId(vehicleId), linkId, "car");
            } else if (typeIndex == EventWriterTXT.Number.VehicleEntersTraffic.ordinal()) {
                e = new VehicleEntersTrafficEvent(time, Id.createPersonId(vehicleId), linkId, vehicleId, "car", 0.0);
            } else if (typeIndex == EventWriterTXT.Number.LinkLeave.ordinal()) {
                e = new LinkLeaveEvent(time, vehicleId, linkId);
            } else if (typeIndex == EventWriterTXT.Number.LinkEnter.ordinal()) {
                e = new LinkEnterEvent(time, vehicleId, linkId);
            } else if (typeIndex == EventWriterTXT.Number.PersonArrival.ordinal()) {
                e = new PersonArrivalEvent(time, Id.createPersonId(vehicleId), linkId, "car");
            } else if (typeIndex == EventWriterTXT.Number.ActivityStart.ordinal()) {
                e = new ActivityStartEvent(time, Id.createPersonId(vehicleId), linkId, null, null);
            } else {
                throw new RuntimeException("Unsupported event type:" + l);
            }
            this.em.processEvent(e);
            l = br.readLine();
        }
        br.close();
    }
}

