/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.events;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.events.ActivityEndEvent;
import org.matsim.api.core.v01.events.ActivityStartEvent;
import org.matsim.api.core.v01.events.Event;
import org.matsim.api.core.v01.events.GenericEvent;
import org.matsim.api.core.v01.events.LinkEnterEvent;
import org.matsim.api.core.v01.events.LinkLeaveEvent;
import org.matsim.api.core.v01.events.PersonArrivalEvent;
import org.matsim.api.core.v01.events.PersonDepartureEvent;
import org.matsim.api.core.v01.events.PersonEntersVehicleEvent;
import org.matsim.api.core.v01.events.PersonLeavesVehicleEvent;
import org.matsim.api.core.v01.events.PersonMoneyEvent;
import org.matsim.api.core.v01.events.PersonStuckEvent;
import org.matsim.api.core.v01.events.TransitDriverStartsEvent;
import org.matsim.api.core.v01.events.VehicleAbortsEvent;
import org.matsim.api.core.v01.events.VehicleEntersTrafficEvent;
import org.matsim.api.core.v01.events.VehicleLeavesTrafficEvent;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.population.Person;
import org.matsim.core.api.experimental.events.AgentWaitingForPtEvent;
import org.matsim.core.api.experimental.events.BoardingDeniedEvent;
import org.matsim.core.api.experimental.events.EventsManager;
import org.matsim.core.api.experimental.events.TeleportationArrivalEvent;
import org.matsim.core.api.experimental.events.VehicleArrivesAtFacilityEvent;
import org.matsim.core.api.experimental.events.VehicleDepartsAtFacilityEvent;
import org.matsim.core.events.MatsimXmlEventsParser;
import org.matsim.facilities.ActivityFacility;
import org.matsim.pt.transitSchedule.api.Departure;
import org.matsim.pt.transitSchedule.api.TransitLine;
import org.matsim.pt.transitSchedule.api.TransitRoute;
import org.matsim.pt.transitSchedule.api.TransitStopFacility;
import org.matsim.vehicles.Vehicle;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public final class EventsReaderXMLv1
extends MatsimXmlEventsParser {
    public static final String EVENT = "event";
    private final EventsManager events;
    private final Map<String, CustomEventMapper> customEventMappers = new HashMap<String, CustomEventMapper>();

    public EventsReaderXMLv1(EventsManager events) {
        this.events = events;
        this.setValidating(false);
    }

    @Override
    public void addCustomEventMapper(String eventType, CustomEventMapper cem) {
        this.customEventMappers.put(eventType, cem);
    }

    @Override
    public void startTag(String name, Attributes atts, Stack<String> context) {
        if (EVENT.equals(name)) {
            this.startEvent(atts);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void endTag(String name, String content, Stack<String> context) {
    }

    private void startEvent(Attributes atts) {
        double time = Double.parseDouble(atts.getValue("time"));
        String eventType = atts.getValue("type");
        if ("left link".equals(eventType)) {
            this.events.processEvent(new LinkLeaveEvent(time, Id.create(atts.getValue("vehicle"), Vehicle.class), Id.create(atts.getValue("link"), Link.class)));
        } else if ("entered link".equals(eventType)) {
            this.events.processEvent(new LinkEnterEvent(time, Id.create(atts.getValue("vehicle"), Vehicle.class), Id.create(atts.getValue("link"), Link.class)));
        } else if ("vehicle enters traffic".equals(eventType)) {
            this.events.processEvent(new VehicleEntersTrafficEvent(time, Id.create(atts.getValue("person"), Person.class), Id.create(atts.getValue("link"), Link.class), Id.create(atts.getValue("vehicle"), Vehicle.class), atts.getValue("networkMode"), Double.parseDouble(atts.getValue("relativePosition"))));
        } else if ("wait2link".equals(eventType)) {
            Id<Vehicle> vehicleId = atts.getValue("vehicle") != null ? Id.create(atts.getValue("vehicle"), Vehicle.class) : Id.create(atts.getValue("person"), Vehicle.class);
            double position = atts.getValue("relativePosition") != null ? Double.parseDouble(atts.getValue("relativePosition")) : 1.0;
            this.events.processEvent(new VehicleEntersTrafficEvent(time, Id.create(atts.getValue("person"), Person.class), Id.create(atts.getValue("link"), Link.class), vehicleId, atts.getValue("networkMode"), position));
        } else if ("vehicle leaves traffic".equals(eventType)) {
            this.events.processEvent(new VehicleLeavesTrafficEvent(time, Id.create(atts.getValue("person"), Person.class), Id.create(atts.getValue("link"), Link.class), atts.getValue("vehicle") == null ? null : Id.create(atts.getValue("vehicle"), Vehicle.class), atts.getValue("networkMode"), Double.parseDouble(atts.getValue("relativePosition"))));
        } else if ("actend".equals(eventType)) {
            this.events.processEvent(new ActivityEndEvent(time, Id.create(atts.getValue("person"), Person.class), Id.create(atts.getValue("link"), Link.class), atts.getValue("facility") == null ? null : Id.create(atts.getValue("facility"), ActivityFacility.class), atts.getValue("actType")));
        } else if ("actstart".equals(eventType)) {
            this.events.processEvent(new ActivityStartEvent(time, Id.create(atts.getValue("person"), Person.class), Id.create(atts.getValue("link"), Link.class), atts.getValue("facility") == null ? null : Id.create(atts.getValue("facility"), ActivityFacility.class), atts.getValue("actType")));
        } else if ("arrival".equals(eventType)) {
            String legMode = atts.getValue("legMode");
            String mode = legMode == null ? null : legMode.intern();
            this.events.processEvent(new PersonArrivalEvent(time, Id.create(atts.getValue("person"), Person.class), Id.create(atts.getValue("link"), Link.class), mode));
        } else if ("departure".equals(eventType)) {
            String legMode = atts.getValue("legMode");
            String mode = legMode == null ? null : legMode.intern();
            this.events.processEvent(new PersonDepartureEvent(time, Id.create(atts.getValue("person"), Person.class), Id.create(atts.getValue("link"), Link.class), mode));
        } else if ("stuckAndAbort".equals(eventType)) {
            String legMode = atts.getValue("legMode");
            String mode = legMode == null ? null : legMode.intern();
            String linkIdString = atts.getValue("link");
            Id<Link> linkId = linkIdString == null ? null : Id.create(linkIdString, Link.class);
            this.events.processEvent(new PersonStuckEvent(time, Id.create(atts.getValue("person"), Person.class), linkId, mode));
        } else if ("vehicle aborts".equals(eventType)) {
            String linkIdString = atts.getValue("link");
            Id<Link> linkId = linkIdString == null ? null : Id.create(linkIdString, Link.class);
            this.events.processEvent(new VehicleAbortsEvent(time, Id.create(atts.getValue("vehicle"), Vehicle.class), linkId));
        } else if ("personMoney".equals(eventType) || "agentMoney".equals(eventType)) {
            this.events.processEvent(new PersonMoneyEvent(time, Id.create(atts.getValue("person"), Person.class), Double.parseDouble(atts.getValue("amount"))));
        } else if ("PersonEntersVehicle".equals(eventType)) {
            String personString = atts.getValue("person");
            String vehicleString = atts.getValue("vehicle");
            this.events.processEvent(new PersonEntersVehicleEvent(time, Id.create(personString, Person.class), Id.create(vehicleString, Vehicle.class)));
        } else if ("PersonLeavesVehicle".equals(eventType)) {
            Id<Person> pId = Id.create(atts.getValue("person"), Person.class);
            Id<Vehicle> vId = Id.create(atts.getValue("vehicle"), Vehicle.class);
            this.events.processEvent(new PersonLeavesVehicleEvent(time, pId, vId));
        } else if ("travelled".equals(eventType)) {
            this.events.processEvent(new TeleportationArrivalEvent(time, Id.create(atts.getValue("person"), Person.class), Double.parseDouble(atts.getValue("distance"))));
        } else if ("VehicleArrivesAtFacility".equals(eventType)) {
            String delay = atts.getValue("delay");
            this.events.processEvent(new VehicleArrivesAtFacilityEvent(time, Id.create(atts.getValue("vehicle"), Vehicle.class), Id.create(atts.getValue("facility"), TransitStopFacility.class), delay == null ? 0.0 : Double.parseDouble(delay)));
        } else if ("VehicleDepartsAtFacility".equals(eventType)) {
            String delay = atts.getValue("delay");
            this.events.processEvent(new VehicleDepartsAtFacilityEvent(time, Id.create(atts.getValue("vehicle"), Vehicle.class), Id.create(atts.getValue("facility"), TransitStopFacility.class), delay == null ? 0.0 : Double.parseDouble(delay)));
        } else if ("TransitDriverStarts".equals(eventType)) {
            this.events.processEvent(new TransitDriverStartsEvent(time, Id.create(atts.getValue("driverId"), Person.class), Id.create(atts.getValue("vehicleId"), Vehicle.class), Id.create(atts.getValue("transitLineId"), TransitLine.class), Id.create(atts.getValue("transitRouteId"), TransitRoute.class), Id.create(atts.getValue("departureId"), Departure.class)));
        } else if ("BoardingDeniedEvent".equals(eventType)) {
            Id<Person> personId = Id.create(atts.getValue("person"), Person.class);
            Id<Vehicle> vehicleId = Id.create(atts.getValue("vehicle"), Vehicle.class);
            this.events.processEvent(new BoardingDeniedEvent(time, personId, vehicleId));
        } else if ("waitingForPt".equals(eventType)) {
            Id<Person> agentId = Id.create(atts.getValue("agent"), Person.class);
            Id<TransitStopFacility> waitStopId = Id.create(atts.getValue("atStop"), TransitStopFacility.class);
            Id<TransitStopFacility> destinationStopId = Id.create(atts.getValue("destinationStop"), TransitStopFacility.class);
            this.events.processEvent(new AgentWaitingForPtEvent(time, agentId, waitStopId, destinationStopId));
        } else {
            GenericEvent event = new GenericEvent(eventType, time);
            for (int ii = 0; ii < atts.getLength(); ++ii) {
                String key = atts.getLocalName(ii);
                if (key.equals("time") || key.equals("type")) continue;
                String value = atts.getValue(ii);
                event.getAttributes().put(key, value);
            }
            CustomEventMapper cem = this.customEventMappers.get(eventType);
            if (cem != null) {
                this.events.processEvent((Event)cem.apply(event));
            } else {
                this.events.processEvent(event);
            }
        }
    }

    public static interface CustomEventMapper<T extends Event> {
        public T apply(GenericEvent var1);
    }
}

