/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.events;

import org.matsim.core.api.experimental.events.EventsManager;
import org.matsim.core.config.Config;
import org.matsim.core.controler.Injector;
import org.matsim.core.events.EventsManagerImpl;
import org.matsim.core.events.EventsManagerModule;
import org.matsim.core.events.MatsimEventsReader;
import org.matsim.core.events.ParallelEventsManager;
import org.matsim.core.events.SimStepParallelEventsManagerImpl;
import org.matsim.core.events.SynchronizedEventsManagerImpl;
import org.matsim.utils.eventsfilecomparison.EventsFileComparator;

public class EventsUtils {
    public static EventsManager createEventsManager() {
        EventsManagerImpl events = new EventsManagerImpl();
        return events;
    }

    public static EventsManager createEventsManager(Config config) {
        EventsManager events = Injector.createInjector(config, new EventsManagerModule()).getInstance(EventsManager.class);
        return events;
    }

    public static EventsManager getParallelFeedableInstance(EventsManager events) {
        if (events instanceof SimStepParallelEventsManagerImpl) {
            return events;
        }
        if (events instanceof ParallelEventsManager) {
            return events;
        }
        if (events instanceof SynchronizedEventsManagerImpl) {
            return events;
        }
        return new SynchronizedEventsManagerImpl(events);
    }

    public static void readEvents(EventsManager events, String filename) {
        new MatsimEventsReader(events).readFile(filename);
    }

    public static EventsFileComparator.Result compareEventsFiles(String filename1, String filename2) {
        EventsFileComparator.Result result = EventsFileComparator.compare(filename1, filename2);
        return result;
    }
}

