/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.events;

import java.io.InputStream;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import org.apache.log4j.Logger;
import org.matsim.core.api.experimental.events.EventsManager;
import org.matsim.core.api.internal.MatsimReader;
import org.matsim.core.events.EventsReaderXMLv1;
import org.matsim.core.events.MatsimXmlEventsParser;
import org.matsim.core.utils.io.MatsimXmlParser;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public final class MatsimEventsReader
implements MatsimReader {
    private static final Logger log = Logger.getLogger(MatsimEventsReader.class);
    private final EventsManager events;
    private final Map<String, EventsReaderXMLv1.CustomEventMapper> map = new LinkedHashMap<String, EventsReaderXMLv1.CustomEventMapper>();

    public void addCustomEventMapper(String eventType, EventsReaderXMLv1.CustomEventMapper mapper) {
        this.map.put(eventType, mapper);
    }

    public MatsimEventsReader(EventsManager events) {
        this.events = events;
    }

    @Override
    public void readFile(String filename) {
        String lcFilename = filename.toLowerCase(Locale.ROOT);
        if (!lcFilename.endsWith(".xml") && !lcFilename.endsWith(".xml.gz")) {
            if (lcFilename.endsWith(".txt") || lcFilename.endsWith(".txt.gz")) {
                throw new RuntimeException("text events are no longer supported. Please use MATSim 0.6.1 or earlier to read text events.");
            }
            throw new IllegalArgumentException("Cannot recognize the format of the events-file " + filename);
        }
        new XmlEventsReader(this.events, this.map).readFile(filename);
    }

    public void readStream(InputStream stream) {
        new XmlEventsReader(this.events, this.map).parse(stream);
    }

    @Override
    public void readURL(URL url) {
        new XmlEventsReader(this.events, this.map).readURL(url);
    }

    private static class XmlEventsReader
    extends MatsimXmlParser {
        final EventsManager events;
        private static final String EVENTS_V1 = "events_v1.dtd";
        private MatsimXmlEventsParser delegate = null;
        private final Map<String, EventsReaderXMLv1.CustomEventMapper> map;

        private XmlEventsReader(EventsManager events, Map<String, EventsReaderXMLv1.CustomEventMapper> map) {
            this.events = events;
            this.map = map;
            this.setValidating(false);
            this.setDoctype(EVENTS_V1);
        }

        @Override
        public void startTag(String name, Attributes atts, Stack<String> context) {
            this.delegate.startTag(name, atts, context);
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
        }

        @Override
        public void endTag(String name, String content, Stack<String> context) {
            this.delegate.endTag(name, content, context);
        }

        @Override
        protected void setDoctype(String doctype) {
            super.setDoctype(doctype);
            if (EVENTS_V1.equals(doctype)) {
                this.delegate = new EventsReaderXMLv1(this.events);
                for (Map.Entry<String, EventsReaderXMLv1.CustomEventMapper> entry : this.map.entrySet()) {
                    this.delegate.addCustomEventMapper(entry.getKey(), entry.getValue());
                }
            } else {
                throw new IllegalArgumentException("Doctype \"" + doctype + "\" not known.");
            }
            log.info("using events_v1-reader.");
        }
    }
}

