/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.events;

import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Phaser;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.events.Event;
import org.matsim.core.api.experimental.events.EventsManager;
import org.matsim.core.config.Config;
import org.matsim.core.events.EventsManagerImpl;
import org.matsim.core.events.LastEventOfIteration;
import org.matsim.core.events.LastEventOfSimStep;
import org.matsim.core.events.SingleHandlerEventsManager;
import org.matsim.core.events.handler.EventHandler;
import org.matsim.core.gbl.Gbl;
import org.matsim.core.utils.misc.Time;

public final class ParallelEventsManager
implements EventsManager {
    private static final Logger log = Logger.getLogger(ParallelEventsManager.class);
    private Phaser simStepEndBarrier;
    private Phaser iterationEndBarrier;
    private Phaser waitForEmptyQueuesBarrier;
    private Distributor distributor;
    private EventsManager singleThreadEventsHandler;
    private EventsManager[] eventsManagers;
    private final List<EventHandler> eventsHandlers;
    private ProcessedEventsChecker processedEventsChecker;
    private final boolean syncOnTimeSteps;
    private final boolean oneThreadPerHandler;
    private final int numOfThreads;
    private boolean parallelMode = false;
    private final AtomicBoolean hadException;
    private ExceptionHandler uncaughtExceptionHandler;
    private boolean locked = false;
    private final int eventsQueueSize = 0x100000;
    private final int eventsArraySize;

    @Inject
    ParallelEventsManager(Config config) {
        this(config.parallelEventHandling().getSynchronizeOnSimSteps() != null ? config.parallelEventHandling().getSynchronizeOnSimSteps() : true);
    }

    public ParallelEventsManager(boolean syncOnTimeSteps) {
        this(syncOnTimeSteps, true, -1);
    }

    public ParallelEventsManager(boolean syncOnTimeSteps, int numOfThreads) {
        this(syncOnTimeSteps, false, numOfThreads);
    }

    ParallelEventsManager(boolean syncOnTimeSteps, boolean oneThreadPerHandler, int numOfThreads) {
        this.syncOnTimeSteps = syncOnTimeSteps;
        this.oneThreadPerHandler = oneThreadPerHandler;
        this.numOfThreads = numOfThreads;
        this.hadException = new AtomicBoolean(false);
        this.simStepEndBarrier = new Phaser(1);
        this.iterationEndBarrier = new Phaser(1);
        this.eventsHandlers = new ArrayList<EventHandler>();
        this.singleThreadEventsHandler = new EventsManagerImpl();
        this.eventsArraySize = syncOnTimeSteps ? 512 : 32768;
    }

    @Override
    public void processEvent(Event event) {
        if (this.parallelMode) {
            this.distributor.processEvent(event);
        } else {
            this.singleThreadEventsHandler.processEvent(event);
        }
    }

    @Override
    public void addHandler(EventHandler handler) {
        if (this.locked) {
            throw new RuntimeException("Cannot add an event handler at the moment!");
        }
        this.eventsHandlers.add(handler);
        this.singleThreadEventsHandler.addHandler(handler);
    }

    @Override
    public void removeHandler(EventHandler handler) {
        if (this.parallelMode) {
            log.warn("Removing EventHandler while ParallelEventsHandler is in 'parallel' mode. This is not expected to happen :?");
        }
        this.eventsHandlers.remove(handler);
        this.singleThreadEventsHandler.removeHandler(handler);
        if (this.eventsManagers != null) {
            for (EventsManager eventsManager : this.eventsManagers) {
                if (eventsManager instanceof SingleHandlerEventsManager) {
                    ((SingleHandlerEventsManager)eventsManager).deactivate();
                    continue;
                }
                eventsManager.removeHandler(handler);
            }
        }
    }

    @Override
    public void resetHandlers(int iteration) {
        this.singleThreadEventsHandler.resetHandlers(iteration);
    }

    @Override
    public void initProcessing() {
        int i;
        this.locked = true;
        int numHandlers = this.oneThreadPerHandler ? this.eventsHandlers.size() : Math.min(this.numOfThreads, this.eventsHandlers.size());
        this.eventsManagers = new EventsManager[numHandlers];
        if (this.oneThreadPerHandler) {
            for (i = 0; i < this.eventsHandlers.size(); ++i) {
                this.eventsManagers[i] = new SingleHandlerEventsManager(this.eventsHandlers.get(i));
            }
        } else {
            for (i = 0; i < this.numOfThreads; ++i) {
                this.eventsManagers[i] = new EventsManagerImpl();
            }
            for (i = 0; i < this.eventsHandlers.size(); ++i) {
                this.eventsManagers[this.eventsHandlers.size() % this.numOfThreads].addHandler(this.eventsHandlers.get(i));
            }
        }
        for (EventsManager eventsManager : this.eventsManagers) {
            eventsManager.initProcessing();
        }
        ProcessEventsRunnable[] eventsRunnables = new ProcessEventsRunnable[numHandlers];
        this.distributor = new Distributor(eventsRunnables);
        this.simStepEndBarrier = new Phaser(numHandlers + 1);
        this.iterationEndBarrier = new Phaser(numHandlers + 1);
        if (this.syncOnTimeSteps) {
            this.processedEventsChecker = new ProcessedEventsChecker(this, this.distributor.inputQueue);
            this.waitForEmptyQueuesBarrier = new Phaser(numHandlers){

                @Override
                protected boolean onAdvance(int phase, int registeredParties) {
                    ParallelEventsManager.this.processedEventsChecker.run();
                    return super.onAdvance(phase, registeredParties);
                }
            };
        } else {
            this.waitForEmptyQueuesBarrier = null;
            this.processedEventsChecker = null;
        }
        this.hadException.set(false);
        this.uncaughtExceptionHandler = new ExceptionHandler(this.hadException, this.waitForEmptyQueuesBarrier, this.simStepEndBarrier, this.iterationEndBarrier);
        for (int i2 = 0; i2 < this.eventsManagers.length; ++i2) {
            ProcessEventsRunnable processEventsRunnable;
            EventsManager eventsManager = this.eventsManagers[i2];
            eventsRunnables[i2] = processEventsRunnable = new ProcessEventsRunnable(eventsManager, this.processedEventsChecker, this.waitForEmptyQueuesBarrier, this.simStepEndBarrier, this.iterationEndBarrier);
            Thread thread = new Thread(processEventsRunnable);
            thread.setDaemon(true);
            thread.setUncaughtExceptionHandler(this.uncaughtExceptionHandler);
            if (eventsManager instanceof SingleHandlerEventsManager) {
                thread.setName("SingleHandlerEventsManager: " + ((SingleHandlerEventsManager)eventsManager).getEventHandlerClassName());
            } else {
                thread.setName(ProcessEventsRunnable.class.toString() + i2);
            }
            thread.start();
        }
        Thread distributorThread = new Thread(this.distributor);
        distributorThread.setDaemon(true);
        distributorThread.setUncaughtExceptionHandler(this.uncaughtExceptionHandler);
        distributorThread.setName("EventsDistributor");
        distributorThread.start();
        this.parallelMode = true;
    }

    @Override
    public synchronized void finishProcessing() {
        if (!this.hadException.get()) {
            this.processEvent(new LastEventOfIteration(Double.MAX_VALUE));
            this.iterationEndBarrier.arriveAndAwaitAdvance();
        }
        for (EventsManager eventsManager : this.eventsManagers) {
            eventsManager.finishProcessing();
        }
        this.singleThreadEventsHandler.finishProcessing();
        this.eventsManagers = null;
        this.distributor = null;
        this.parallelMode = false;
        if (this.hadException.get()) {
            throw new RuntimeException("Exception while processing events. Cannot guarantee that all events have been fully processed.");
        }
        this.locked = false;
    }

    @Override
    public void afterSimStep(double time) {
        if (this.hadException.get()) {
            return;
        }
        if (this.syncOnTimeSteps) {
            this.processedEventsChecker.setTime(time);
            this.processEvent(new LastEventOfSimStep(time));
            this.simStepEndBarrier.arriveAndAwaitAdvance();
        }
    }

    private static class ExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private final AtomicBoolean hadException;
        private final Phaser simStepEndBarrier;
        private final Phaser iterationEndBarrier;
        private final Phaser waitForEmptyQueuesBarrier;

        ExceptionHandler(AtomicBoolean hadException, Phaser waitForEmptyQueuesBarrier, Phaser simStepEndBarrier, Phaser iterationEndBarrier) {
            this.hadException = hadException;
            this.waitForEmptyQueuesBarrier = waitForEmptyQueuesBarrier;
            this.simStepEndBarrier = simStepEndBarrier;
            this.iterationEndBarrier = iterationEndBarrier;
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            this.hadException.set(true);
            log.error("Thread " + t.getName() + " died with exception while handling events.", e);
            this.simStepEndBarrier.forceTermination();
            this.iterationEndBarrier.forceTermination();
            this.waitForEmptyQueuesBarrier.forceTermination();
        }
    }

    private static class ProcessedEventsChecker
    implements Runnable {
        private final EventsManager eventsManager;
        private final Queue<Event> eventsQueue;
        private boolean allEventsProcessed;
        private double time;

        public ProcessedEventsChecker(EventsManager eventsManager, Queue<Event> eventsQueue) {
            this.eventsManager = eventsManager;
            this.eventsQueue = eventsQueue;
            this.allEventsProcessed = true;
        }

        public void setTime(double time) {
            this.time = time;
        }

        public boolean allEventsProcessed() {
            return this.allEventsProcessed;
        }

        @Override
        public void run() {
            if (!this.eventsQueue.isEmpty()) {
                this.allEventsProcessed = false;
                this.eventsManager.processEvent(new LastEventOfSimStep(this.time));
                return;
            }
            this.eventsQueue.clear();
            this.allEventsProcessed = true;
        }
    }

    private class ProcessEventsRunnable
    implements Runnable {
        private final EventsManager eventsManager;
        private final ProcessedEventsChecker processedEventsChecker;
        private final Phaser waitForEmptyQueuesBarrier;
        private final Phaser simStepEndBarrier;
        private final Phaser iterationEndBarrier;
        private final BlockingQueue<Event[]> eventsQueue;
        private double lastEventTime = Time.getUndefinedTime();

        public ProcessEventsRunnable(EventsManager eventsManager, ProcessedEventsChecker processedEventsChecker, Phaser waitForEmptyQueuesBarrier, Phaser simStepEndBarrier, Phaser iterationEndBarrier) {
            this.eventsManager = eventsManager;
            this.processedEventsChecker = processedEventsChecker;
            this.waitForEmptyQueuesBarrier = waitForEmptyQueuesBarrier;
            this.simStepEndBarrier = simStepEndBarrier;
            this.iterationEndBarrier = iterationEndBarrier;
            this.eventsQueue = new LinkedBlockingQueue<Event[]>();
        }

        @Override
        public void run() {
            try {
                boolean foundLastEventOfIteration = false;
                block2: while (!foundLastEventOfIteration) {
                    Event[] events;
                    for (Event event : events = this.eventsQueue.take()) {
                        if (event.getTime() < this.lastEventTime) {
                            throw new RuntimeException("Events in the queue are not ordered chronologically. This should never happen. Is the ParallelEventsManager registered as a MobsimAfterSimStepListener?");
                        }
                        this.lastEventTime = event.getTime();
                        if (event instanceof LastEventOfSimStep) {
                            this.waitForEmptyQueuesBarrier.arriveAndAwaitAdvance();
                            if (!this.processedEventsChecker.allEventsProcessed()) continue;
                            this.simStepEndBarrier.arriveAndAwaitAdvance();
                            continue block2;
                        }
                        if (event instanceof LastEventOfIteration) {
                            foundLastEventOfIteration = true;
                            continue block2;
                        }
                        this.eventsManager.processEvent(event);
                    }
                }
            }
            catch (InterruptedException e) {
                ParallelEventsManager.this.hadException.set(true);
            }
            this.iterationEndBarrier.arriveAndAwaitAdvance();
            Gbl.printCurrentThreadCpuTime();
        }
    }

    private class Distributor
    implements Runnable {
        private final ProcessEventsRunnable[] runnables;
        private final BlockingQueue<Event> inputQueue;

        public Distributor(ProcessEventsRunnable[] runnables) {
            this.runnables = runnables;
            this.inputQueue = new ArrayBlockingQueue<Event>(0x100000);
        }

        public final void processEvent(Event event) {
            this.inputQueue.add(event);
        }

        @Override
        public final void run() {
            try {
                int arrayPos = 0;
                Event[] events = new Event[ParallelEventsManager.this.eventsArraySize];
                while (true) {
                    Event event;
                    events[arrayPos] = event = this.inputQueue.take();
                    if (++arrayPos != ParallelEventsManager.this.eventsArraySize && (!ParallelEventsManager.this.syncOnTimeSteps || !(event instanceof LastEventOfSimStep)) && !(event instanceof LastEventOfIteration)) continue;
                    for (ProcessEventsRunnable runnable : this.runnables) {
                        runnable.eventsQueue.add(events);
                    }
                    events = new Event[ParallelEventsManager.this.eventsArraySize];
                    arrayPos = 0;
                    if (event instanceof LastEventOfIteration) break;
                }
            }
            catch (InterruptedException e) {
                ParallelEventsManager.this.hadException.set(true);
            }
        }
    }
}

