/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.events;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.events.Event;
import org.matsim.core.api.experimental.events.EventsManager;
import org.matsim.core.config.Config;
import org.matsim.core.events.EventsManagerImpl;
import org.matsim.core.events.EventsUtils;
import org.matsim.core.events.ProcessEventThread;
import org.matsim.core.events.handler.EventHandler;

public final class ParallelEventsManagerImpl
implements EventsManager {
    private boolean parallelMode = true;
    private int numberOfThreads;
    private EventsManagerImpl[] events = null;
    private ProcessEventThread[] eventsProcessThread = null;
    private Thread[] threads = null;
    private int numberOfAddedEventsHandler = 0;
    private final AtomicBoolean hadException = new AtomicBoolean(false);
    private final ExceptionHandler uncaughtExceptionHandler = new ExceptionHandler(this.hadException);
    private static final Logger log = Logger.getLogger(ParallelEventsManagerImpl.class);
    private int preInputBufferMaxLength = 100000;

    @Inject
    ParallelEventsManagerImpl(Config config) {
        if (config.parallelEventHandling().getEstimatedNumberOfEvents() != null) {
            this.preInputBufferMaxLength = (int)(config.parallelEventHandling().getEstimatedNumberOfEvents() / 10L);
        }
        this.init(config.parallelEventHandling().getNumberOfThreads());
    }

    public ParallelEventsManagerImpl(int numberOfThreads) {
        this.init(numberOfThreads);
    }

    public ParallelEventsManagerImpl(int numberOfThreads, long estimatedNumberOfEvents) {
        this.preInputBufferMaxLength = (int)(estimatedNumberOfEvents / 10L);
        this.init(numberOfThreads);
    }

    @Override
    public void processEvent(Event event) {
        if (this.parallelMode) {
            for (int i = 0; i < this.eventsProcessThread.length; ++i) {
                this.eventsProcessThread[i].processEvent(event);
            }
        } else {
            for (int i = 0; i < this.eventsProcessThread.length; ++i) {
                this.eventsProcessThread[i].getEvents().processEvent(event);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addHandler(EventHandler handler) {
        ParallelEventsManagerImpl parallelEventsManagerImpl = this;
        synchronized (parallelEventsManagerImpl) {
            log.info("adding Event-Handler " + handler.getClass().getName() + " to thread " + this.numberOfAddedEventsHandler);
            this.events[this.numberOfAddedEventsHandler].addHandler(handler);
            this.numberOfAddedEventsHandler = (this.numberOfAddedEventsHandler + 1) % this.numberOfThreads;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetHandlers(int iteration) {
        ParallelEventsManagerImpl parallelEventsManagerImpl = this;
        synchronized (parallelEventsManagerImpl) {
            for (int i = 0; i < this.events.length; ++i) {
                this.events[i].resetHandlers(iteration);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeHandler(EventHandler handler) {
        ParallelEventsManagerImpl parallelEventsManagerImpl = this;
        synchronized (parallelEventsManagerImpl) {
            for (int i = 0; i < this.events.length; ++i) {
                this.events[i].removeHandler(handler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printEventHandlers() {
        ParallelEventsManagerImpl parallelEventsManagerImpl = this;
        synchronized (parallelEventsManagerImpl) {
            for (int i = 0; i < this.events.length; ++i) {
                log.info("registered event handlers for thread " + i + ":");
                this.events[i].printEventHandlers();
            }
        }
    }

    private void init(int numberOfThreads) {
        this.numberOfThreads = numberOfThreads;
        this.events = new EventsManagerImpl[numberOfThreads];
        this.eventsProcessThread = new ProcessEventThread[numberOfThreads];
        this.threads = new Thread[numberOfThreads];
        for (int i = 0; i < numberOfThreads; ++i) {
            this.events[i] = (EventsManagerImpl)EventsUtils.createEventsManager();
        }
    }

    @Override
    public void finishProcessing() {
        for (int i = 0; i < this.eventsProcessThread.length; ++i) {
            this.eventsProcessThread[i].close();
        }
        try {
            for (Thread t : this.threads) {
                t.join();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.printEventHandlers();
        this.parallelMode = false;
        if (this.hadException.get()) {
            throw new RuntimeException("Exception while processing events. Cannot guarantee that all events have been fully processed.");
        }
    }

    @Override
    public void initProcessing() {
        for (int i = 0; i < this.numberOfThreads; ++i) {
            this.eventsProcessThread[i] = new ProcessEventThread(this.events[i], this.preInputBufferMaxLength);
            this.threads[i] = new Thread((Runnable)this.eventsProcessThread[i], "Events-" + i);
            this.threads[i].setUncaughtExceptionHandler(this.uncaughtExceptionHandler);
            this.threads[i].start();
        }
        this.parallelMode = true;
    }

    @Override
    public void afterSimStep(double time) {
    }

    private static class ExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private final AtomicBoolean hadException;

        public ExceptionHandler(AtomicBoolean hadException) {
            this.hadException = hadException;
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            log.error("Thread " + t.getName() + " died with exception while handling events.", e);
            this.hadException.set(true);
        }
    }
}

