/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.events;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.matsim.api.core.v01.events.Event;
import org.matsim.core.api.experimental.events.EventsManager;
import org.matsim.core.events.LastEventOfIteration;
import org.matsim.core.gbl.Gbl;

class ProcessEventThread
implements Runnable {
    private final List<Event> preInputBuffer;
    private final BlockingQueue<Event> eventQueue;
    private final EventsManager events;
    private final int preInputBufferMaxLength;

    public ProcessEventThread(EventsManager events, int preInputBufferMaxLength) {
        this.events = events;
        this.preInputBufferMaxLength = preInputBufferMaxLength;
        this.eventQueue = new LinkedBlockingQueue<Event>();
        this.preInputBuffer = new ArrayList<Event>(preInputBufferMaxLength + 1);
    }

    public synchronized void processEvent(Event event) {
        this.preInputBuffer.add(event);
        if (this.preInputBuffer.size() > this.preInputBufferMaxLength) {
            this.emptyPreBuffer();
        }
    }

    private void emptyPreBuffer() {
        this.eventQueue.addAll(this.preInputBuffer);
        this.preInputBuffer.clear();
    }

    @Override
    public void run() {
        try {
            while (true) {
                Event nextEvent;
                if ((nextEvent = this.eventQueue.take()) instanceof LastEventOfIteration) {
                    Gbl.printCurrentThreadCpuTime();
                    if (this.eventQueue.size() > 0) {
                        this.processEvent(nextEvent);
                        this.emptyPreBuffer();
                        nextEvent = this.eventQueue.take();
                    } else {
                        return;
                    }
                }
                this.getEvents().processEvent(nextEvent);
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized void close() {
        this.processEvent(new LastEventOfIteration(0.0));
        this.emptyPreBuffer();
    }

    public EventsManager getEvents() {
        return this.events;
    }
}

