/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.events;

import java.util.ArrayList;
import java.util.Queue;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.events.Event;
import org.matsim.core.api.experimental.events.EventsManager;
import org.matsim.core.config.groups.ParallelEventHandlingConfigGroup;
import org.matsim.core.events.EventsManagerImpl;
import org.matsim.core.events.LastEventOfIteration;
import org.matsim.core.events.LastEventOfSimStep;
import org.matsim.core.events.handler.EventHandler;
import org.matsim.core.gbl.Gbl;

class SimStepParallelEventsManagerImpl
implements EventsManager {
    private static final Logger log = Logger.getLogger(SimStepParallelEventsManagerImpl.class);
    private final int numOfThreads;
    private CyclicBarrier simStepEndBarrier;
    private CyclicBarrier iterationEndBarrier;
    private ProcessEventsRunnable[] runnables;
    private EventsManagerImpl[] eventsManagers;
    private EventsManagerImpl delegate;
    private ProcessedEventsChecker processedEventsChecker;
    private boolean parallelMode = false;
    private int handlerCount = 0;
    private AtomicLong counter;
    private AtomicReference<Throwable> hadException = new AtomicReference();

    @Inject
    SimStepParallelEventsManagerImpl(ParallelEventHandlingConfigGroup config) {
        this(config.getNumberOfThreads() != null ? config.getNumberOfThreads() : 1);
    }

    public SimStepParallelEventsManagerImpl() {
        this(1);
    }

    public SimStepParallelEventsManagerImpl(int numOfThreads) {
        this.numOfThreads = numOfThreads;
        log.info("number of threads=" + numOfThreads);
        this.init();
    }

    private void init() {
        this.counter = new AtomicLong(0L);
        this.simStepEndBarrier = new CyclicBarrier(this.numOfThreads + 1);
        this.iterationEndBarrier = new CyclicBarrier(this.numOfThreads + 1);
        this.delegate = new EventsManagerImpl();
        this.eventsManagers = new EventsManagerImpl[this.numOfThreads];
        for (int i = 0; i < this.numOfThreads; ++i) {
            this.eventsManagers[i] = new EventsManagerImpl();
        }
    }

    @Override
    public void processEvent(Event event) {
        this.counter.incrementAndGet();
        if (this.parallelMode) {
            this.runnables[0].processEvent(event);
        } else {
            this.delegate.processEvent(event);
        }
    }

    @Override
    public void addHandler(EventHandler handler) {
        this.delegate.addHandler(handler);
        this.eventsManagers[this.handlerCount % this.numOfThreads].addHandler(handler);
        ++this.handlerCount;
    }

    @Override
    public void removeHandler(EventHandler handler) {
        this.delegate.removeHandler(handler);
        for (EventsManagerImpl eventsManager : this.eventsManagers) {
            eventsManager.removeHandler(handler);
        }
    }

    @Override
    public void resetHandlers(int iteration) {
        this.delegate.resetHandlers(iteration);
        this.counter.set(0L);
    }

    @Override
    public void initProcessing() {
        this.delegate.initProcessing();
        for (EventsManagerImpl eventsManager : this.eventsManagers) {
            eventsManager.initProcessing();
        }
        Queue[] eventsQueuesArray = new Queue[this.numOfThreads];
        ArrayList eventsQueues = new ArrayList();
        for (int i = 0; i < this.numOfThreads; ++i) {
            LinkedBlockingQueue eventsQueue = new LinkedBlockingQueue();
            eventsQueues.add(eventsQueue);
            eventsQueuesArray[i] = eventsQueue;
        }
        eventsQueues.add(null);
        this.processedEventsChecker = new ProcessedEventsChecker(this, eventsQueuesArray);
        CyclicBarrier waitForEmptyQueuesBarrier = new CyclicBarrier(this.numOfThreads, this.processedEventsChecker);
        this.hadException = new AtomicReference();
        ExceptionHandler uncaughtExceptionHandler = new ExceptionHandler(this.hadException, waitForEmptyQueuesBarrier, this.simStepEndBarrier, this.iterationEndBarrier);
        this.runnables = new ProcessEventsRunnable[this.numOfThreads];
        for (int i = 0; i < this.numOfThreads; ++i) {
            ProcessEventsRunnable processEventsRunnable;
            this.runnables[i] = processEventsRunnable = new ProcessEventsRunnable(this.eventsManagers[i], this.processedEventsChecker, waitForEmptyQueuesBarrier, this.simStepEndBarrier, this.iterationEndBarrier, (Queue)eventsQueues.get(i), (Queue)eventsQueues.get(i + 1));
            Thread thread = new Thread(processEventsRunnable);
            thread.setDaemon(true);
            thread.setUncaughtExceptionHandler(uncaughtExceptionHandler);
            thread.setName(ProcessEventsRunnable.class.toString() + i);
            thread.start();
        }
        this.parallelMode = true;
    }

    @Override
    public synchronized void finishProcessing() {
        Throwable throwable = this.hadException.get();
        if (throwable == null) {
            try {
                this.processEvent(new LastEventOfIteration(Double.POSITIVE_INFINITY));
                this.iterationEndBarrier.await();
            }
            catch (InterruptedException | BrokenBarrierException e) {
                this.hadException.set(e);
            }
        }
        this.delegate.finishProcessing();
        for (EventsManagerImpl eventsManager : this.eventsManagers) {
            eventsManager.finishProcessing();
        }
        this.parallelMode = false;
        if (throwable != null) {
            throw new RuntimeException("Exception while processing events. Cannot guarantee that all events have been fully processed.", throwable);
        }
    }

    @Override
    public void afterSimStep(double time) {
        if (this.hadException.get() != null) {
            return;
        }
        try {
            Gbl.assertNotNull(this.processedEventsChecker);
            this.processedEventsChecker.setTime(time);
            this.processEvent(new LastEventOfSimStep(time));
            this.simStepEndBarrier.await();
        }
        catch (InterruptedException | BrokenBarrierException e) {
            throw new RuntimeException(e);
        }
    }

    private static class ExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private final AtomicReference<Throwable> hadException;
        private final CyclicBarrier simStepEndBarrier;
        private final CyclicBarrier iterationEndBarrier;
        private final CyclicBarrier waitForEmptyQueuesBarrier;

        public ExceptionHandler(AtomicReference<Throwable> hadException, CyclicBarrier waitForEmptyQueuesBarrier, CyclicBarrier simStepEndBarrier, CyclicBarrier iterationEndBarrier) {
            this.hadException = hadException;
            this.waitForEmptyQueuesBarrier = waitForEmptyQueuesBarrier;
            this.simStepEndBarrier = simStepEndBarrier;
            this.iterationEndBarrier = iterationEndBarrier;
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            this.hadException.set(e);
            log.error("Thread " + t.getName() + " died with exception while handling events.", e);
            this.simStepEndBarrier.reset();
            this.iterationEndBarrier.reset();
            this.waitForEmptyQueuesBarrier.reset();
        }
    }

    private static class ProcessedEventsChecker
    implements Runnable {
        private final EventsManager evenentsManger;
        private final Queue<Event>[] eventQueues;
        private boolean allEventsProcessed;
        private double time;

        public ProcessedEventsChecker(EventsManager evenentsManger, Queue<Event>[] eventQueues) {
            this.evenentsManger = evenentsManger;
            this.eventQueues = eventQueues;
            this.allEventsProcessed = true;
        }

        public void setTime(double time) {
            this.time = time;
        }

        public boolean allEventsProcessed() {
            return this.allEventsProcessed;
        }

        @Override
        public void run() {
            for (Queue<Event> eventsQueue : this.eventQueues) {
                if (eventsQueue.size() <= 0) continue;
                this.allEventsProcessed = false;
                this.evenentsManger.processEvent(new LastEventOfSimStep(this.time));
                return;
            }
            this.allEventsProcessed = true;
        }
    }

    private static class ProcessEventsRunnable
    implements Runnable {
        private final EventsManager eventsManager;
        private final ProcessedEventsChecker processedEventsChecker;
        private final CyclicBarrier waitForEmptyQueuesBarrier;
        private final CyclicBarrier simStepEndBarrier;
        private final CyclicBarrier iterationEndBarrier;
        private final Queue<Event> eventsQueue;
        private final Queue<Event> nextEventsQueue;
        private double lastEventTime = 0.0;

        public ProcessEventsRunnable(EventsManager eventsManager, ProcessedEventsChecker processedEventsChecker, CyclicBarrier waitForEmptyQueuesBarrier, CyclicBarrier simStepEndBarrier, CyclicBarrier iterationEndBarrier, Queue<Event> eventsQueue, Queue<Event> nextEventsQueue) {
            this.eventsManager = eventsManager;
            this.processedEventsChecker = processedEventsChecker;
            this.waitForEmptyQueuesBarrier = waitForEmptyQueuesBarrier;
            this.simStepEndBarrier = simStepEndBarrier;
            this.iterationEndBarrier = iterationEndBarrier;
            this.eventsQueue = eventsQueue;
            this.nextEventsQueue = nextEventsQueue;
        }

        @Override
        public void run() {
            try {
                this.lastEventTime = 0.0;
                while (true) {
                    Event event;
                    if ((event = (Event)((LinkedBlockingQueue)this.eventsQueue).take()).getTime() < this.lastEventTime) {
                        throw new RuntimeException("Events in the queue are not ordered chronologically. This should never happen. Is the SimTimeStepParallelEventsManager registered as a MobsimAfterSimStepListener?");
                    }
                    this.lastEventTime = event.getTime();
                    if (event instanceof LastEventOfSimStep) {
                        if (this.nextEventsQueue != null) {
                            this.nextEventsQueue.add(event);
                        }
                        this.waitForEmptyQueuesBarrier.await();
                        if (!this.processedEventsChecker.allEventsProcessed()) continue;
                        this.simStepEndBarrier.await();
                        continue;
                    }
                    if (this.nextEventsQueue != null) {
                        this.nextEventsQueue.add(event);
                    }
                    if (event instanceof LastEventOfIteration) break;
                    this.eventsManager.processEvent(event);
                }
                this.iterationEndBarrier.await();
            }
            catch (InterruptedException | BrokenBarrierException e) {
                throw new RuntimeException(e);
            }
            Gbl.printCurrentThreadCpuTime();
        }

        public void processEvent(Event event) {
            this.eventsQueue.add(event);
        }
    }
}

