/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.events;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.events.ActivityEndEvent;
import org.matsim.api.core.v01.events.ActivityStartEvent;
import org.matsim.api.core.v01.events.Event;
import org.matsim.api.core.v01.events.LinkEnterEvent;
import org.matsim.api.core.v01.events.LinkLeaveEvent;
import org.matsim.api.core.v01.events.PersonArrivalEvent;
import org.matsim.api.core.v01.events.PersonDepartureEvent;
import org.matsim.api.core.v01.events.PersonEntersVehicleEvent;
import org.matsim.api.core.v01.events.PersonLeavesVehicleEvent;
import org.matsim.api.core.v01.events.PersonMoneyEvent;
import org.matsim.api.core.v01.events.PersonStuckEvent;
import org.matsim.api.core.v01.events.TransitDriverStartsEvent;
import org.matsim.api.core.v01.events.VehicleAbortsEvent;
import org.matsim.api.core.v01.events.VehicleEntersTrafficEvent;
import org.matsim.api.core.v01.events.VehicleLeavesTrafficEvent;
import org.matsim.api.core.v01.events.handler.ActivityEndEventHandler;
import org.matsim.api.core.v01.events.handler.ActivityStartEventHandler;
import org.matsim.api.core.v01.events.handler.LinkEnterEventHandler;
import org.matsim.api.core.v01.events.handler.LinkLeaveEventHandler;
import org.matsim.api.core.v01.events.handler.PersonArrivalEventHandler;
import org.matsim.api.core.v01.events.handler.PersonDepartureEventHandler;
import org.matsim.api.core.v01.events.handler.PersonEntersVehicleEventHandler;
import org.matsim.api.core.v01.events.handler.PersonLeavesVehicleEventHandler;
import org.matsim.api.core.v01.events.handler.PersonMoneyEventHandler;
import org.matsim.api.core.v01.events.handler.PersonStuckEventHandler;
import org.matsim.api.core.v01.events.handler.TransitDriverStartsEventHandler;
import org.matsim.api.core.v01.events.handler.VehicleAbortsEventHandler;
import org.matsim.api.core.v01.events.handler.VehicleEntersTrafficEventHandler;
import org.matsim.api.core.v01.events.handler.VehicleLeavesTrafficEventHandler;
import org.matsim.core.api.experimental.events.AgentWaitingForPtEvent;
import org.matsim.core.api.experimental.events.EventsManager;
import org.matsim.core.api.experimental.events.TeleportationArrivalEvent;
import org.matsim.core.api.experimental.events.VehicleArrivesAtFacilityEvent;
import org.matsim.core.api.experimental.events.VehicleDepartsAtFacilityEvent;
import org.matsim.core.api.experimental.events.handler.AgentWaitingForPtEventHandler;
import org.matsim.core.api.experimental.events.handler.TeleportationArrivalEventHandler;
import org.matsim.core.api.experimental.events.handler.VehicleArrivesAtFacilityEventHandler;
import org.matsim.core.api.experimental.events.handler.VehicleDepartsAtFacilityEventHandler;
import org.matsim.core.events.handler.BasicEventHandler;
import org.matsim.core.events.handler.EventHandler;

public final class SingleHandlerEventsManager
implements EventsManager {
    private static final Logger log = Logger.getLogger(SingleHandlerEventsManager.class);
    private final Map<Class<?>, HandlerInfo> methodToHandle = new HashMap();
    private final EventHandler eventHandler;
    private final boolean isLeaveLinkHandler;
    private final boolean isLinkEnterHandler;
    private final boolean isWait2LinkHandler;
    private final boolean isPersonArrivalHandler;
    private final boolean isPersonDepatureHandler;
    private final boolean isActivityEndHandler;
    private final boolean isActivityStartHandler;
    private final boolean isTeleportationArrivalHandler;
    private final boolean isTransitDriverStartsHandler;
    private final boolean isPersonStuckHandler;
    private final boolean isPersonMoneyHandler;
    private final boolean isAgentWaitingForPtHandler;
    private final boolean isPersonEntersVehicleHandler;
    private final boolean isPersonLeavesVehicleHandler;
    private final boolean isVehicleDepartsAtFacilityHandler;
    private final boolean isVehicleArrivesAtFacilityHandler;
    private final boolean isVehicleLeavesTrafficHandler;
    private final boolean isVehicleAbortsHandler;
    private final boolean isBasicEventHandler;
    private long counter = 0L;
    private long nextCounterMsg = 1L;
    private boolean isActive = true;

    public SingleHandlerEventsManager(EventHandler eventHandler) {
        Class<?> test;
        this.eventHandler = eventHandler;
        this.isLeaveLinkHandler = this.eventHandler instanceof LinkLeaveEventHandler;
        this.isLinkEnterHandler = this.eventHandler instanceof LinkEnterEventHandler;
        this.isWait2LinkHandler = this.eventHandler instanceof VehicleEntersTrafficEventHandler;
        this.isPersonArrivalHandler = this.eventHandler instanceof PersonArrivalEventHandler;
        this.isPersonDepatureHandler = this.eventHandler instanceof PersonDepartureEventHandler;
        this.isActivityEndHandler = this.eventHandler instanceof ActivityEndEventHandler;
        this.isActivityStartHandler = this.eventHandler instanceof ActivityStartEventHandler;
        this.isTeleportationArrivalHandler = this.eventHandler instanceof TeleportationArrivalEventHandler;
        this.isTransitDriverStartsHandler = this.eventHandler instanceof TransitDriverStartsEventHandler;
        this.isPersonStuckHandler = this.eventHandler instanceof PersonStuckEventHandler;
        this.isPersonMoneyHandler = this.eventHandler instanceof PersonMoneyEventHandler;
        this.isAgentWaitingForPtHandler = this.eventHandler instanceof AgentWaitingForPtEventHandler;
        this.isPersonEntersVehicleHandler = this.eventHandler instanceof PersonEntersVehicleEventHandler;
        this.isPersonLeavesVehicleHandler = this.eventHandler instanceof PersonLeavesVehicleEventHandler;
        this.isVehicleDepartsAtFacilityHandler = this.eventHandler instanceof VehicleDepartsAtFacilityEventHandler;
        this.isVehicleArrivesAtFacilityHandler = this.eventHandler instanceof VehicleArrivesAtFacilityEventHandler;
        this.isVehicleLeavesTrafficHandler = this.eventHandler instanceof VehicleLeavesTrafficEventHandler;
        this.isVehicleAbortsHandler = this.eventHandler instanceof VehicleAbortsEventHandler;
        this.isBasicEventHandler = this.eventHandler instanceof BasicEventHandler;
        HashSet addedHandlers = new HashSet();
        log.info("adding Event-Handler: " + test.getName());
        for (test = eventHandler.getClass(); test != Object.class; test = test.getSuperclass()) {
            for (Class<?> theInterface : test.getInterfaces()) {
                if (addedHandlers.contains(theInterface)) continue;
                log.info("  " + theInterface.getName());
                this.addHandlerInterfaces(theInterface);
                addedHandlers.add(theInterface);
            }
        }
        log.info("");
    }

    public void deactivate() {
        this.isActive = false;
    }

    @Override
    public void processEvent(Event event) {
        if (!this.isActive) {
            return;
        }
        ++this.counter;
        if (this.counter == this.nextCounterMsg) {
            this.nextCounterMsg *= 2L;
            log.info(" event # " + this.counter);
        }
        this.computeEvent(event);
    }

    @Override
    public void addHandler(EventHandler handler) {
        throw new UnsupportedOperationException("This implementation supports only a single EventHandler which has to be provided upon creation. Aborting!");
    }

    @Override
    public void removeHandler(EventHandler handler) {
        throw new UnsupportedOperationException("This implementation supports only a single EventHandler which has to be provided upon creation. Aborting!");
    }

    @Override
    public void resetHandlers(int iteration) {
        log.info("resetting Event-Handler");
        this.counter = 0L;
        this.nextCounterMsg = 1L;
        this.eventHandler.reset(iteration);
    }

    @Override
    public void initProcessing() {
    }

    @Override
    public void afterSimStep(double time) {
    }

    @Override
    public void finishProcessing() {
    }

    public EventHandler getEventHandler() {
        return this.eventHandler;
    }

    public String getEventHandlerClassName() {
        return this.eventHandler.getClass().toString();
    }

    private void computeEvent(Event event) {
        if (this.callHandlerFast(event)) {
            return;
        }
        try {
            Method method = this.getHandlersForClass(event.getClass());
            if (method != null) {
                method.invoke((Object)this.eventHandler, event);
            }
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("problem invoking EventHandler " + this.eventHandler.getClass().getCanonicalName() + " for event-class " + event.getClass().getCanonicalName(), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("problem invoking EventHandler " + this.eventHandler.getClass().getCanonicalName() + " for event-class " + event.getClass().getCanonicalName(), e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("problem invoking EventHandler " + this.eventHandler.getClass().getCanonicalName() + " for event-class " + event.getClass().getCanonicalName(), e);
        }
    }

    private Method getHandlersForClass(Class<?> eventClass) {
        HandlerInfo info = this.methodToHandle.get(eventClass);
        if (info != null) {
            return info.method;
        }
        Method method = null;
        for (Class<?> klass = eventClass; klass != Object.class; klass = klass.getSuperclass()) {
            info = this.methodToHandle.get(klass);
            if (info == null) continue;
            method = info.method;
            break;
        }
        if (method == null) {
            for (Class<?> intfc : this.getAllInterfaces(eventClass)) {
                info = this.methodToHandle.get(intfc);
                if (info == null) continue;
                method = info.method;
                break;
            }
        }
        info = new HandlerInfo(method);
        this.methodToHandle.put(eventClass, new HandlerInfo(info.method));
        return method;
    }

    private void addHandlerInterfaces(Class<?> handlerClass) {
        Method[] classmethods;
        for (Method method : classmethods = handlerClass.getMethods()) {
            Class<?>[] params;
            if (!method.getName().equals("handleEvent") || (params = method.getParameterTypes()).length != 1) continue;
            Class<?> eventClass = params[0];
            log.info("    > " + eventClass.getName());
            if (this.methodToHandle.containsKey(eventClass)) continue;
            HandlerInfo info = new HandlerInfo(method);
            this.methodToHandle.put(eventClass, info);
        }
    }

    private Set<Class<?>> getAllInterfaces(Class<?> klass) {
        HashSet intfs = new HashSet();
        for (Class<?> intf : klass.getInterfaces()) {
            intfs.add(intf);
            intfs.addAll(this.getAllInterfaces(intf));
        }
        if (!klass.isInterface()) {
            for (Class<?> superclass = klass.getSuperclass(); superclass != Object.class; superclass = superclass.getSuperclass()) {
                intfs.addAll(this.getAllInterfaces(superclass));
            }
        }
        return intfs;
    }

    private boolean callHandlerFast(Event ev) {
        Class<?> klass = ev.getClass();
        if (this.isLeaveLinkHandler && klass == LinkLeaveEvent.class) {
            ((LinkLeaveEventHandler)this.eventHandler).handleEvent((LinkLeaveEvent)ev);
            return true;
        }
        if (this.isLinkEnterHandler && klass == LinkEnterEvent.class) {
            ((LinkEnterEventHandler)this.eventHandler).handleEvent((LinkEnterEvent)ev);
            return true;
        }
        if (this.isWait2LinkHandler && klass == VehicleEntersTrafficEvent.class) {
            ((VehicleEntersTrafficEventHandler)this.eventHandler).handleEvent((VehicleEntersTrafficEvent)ev);
            return true;
        }
        if (this.isPersonArrivalHandler && klass == PersonArrivalEvent.class) {
            ((PersonArrivalEventHandler)this.eventHandler).handleEvent((PersonArrivalEvent)ev);
            return true;
        }
        if (this.isPersonDepatureHandler && klass == PersonDepartureEvent.class) {
            ((PersonDepartureEventHandler)this.eventHandler).handleEvent((PersonDepartureEvent)ev);
            return true;
        }
        if (this.isActivityEndHandler && klass == ActivityEndEvent.class) {
            ((ActivityEndEventHandler)this.eventHandler).handleEvent((ActivityEndEvent)ev);
            return true;
        }
        if (this.isActivityStartHandler && klass == ActivityStartEvent.class) {
            ((ActivityStartEventHandler)this.eventHandler).handleEvent((ActivityStartEvent)ev);
            return true;
        }
        if (this.isTeleportationArrivalHandler && klass == TeleportationArrivalEvent.class) {
            ((TeleportationArrivalEventHandler)this.eventHandler).handleEvent((TeleportationArrivalEvent)ev);
            return true;
        }
        if (this.isTransitDriverStartsHandler && klass == TransitDriverStartsEvent.class) {
            ((TransitDriverStartsEventHandler)this.eventHandler).handleEvent((TransitDriverStartsEvent)ev);
            return true;
        }
        if (this.isPersonStuckHandler && klass == PersonStuckEvent.class) {
            ((PersonStuckEventHandler)this.eventHandler).handleEvent((PersonStuckEvent)ev);
            return true;
        }
        if (this.isPersonMoneyHandler && klass == PersonMoneyEvent.class) {
            ((PersonMoneyEventHandler)this.eventHandler).handleEvent((PersonMoneyEvent)ev);
            return true;
        }
        if (this.isAgentWaitingForPtHandler && klass == AgentWaitingForPtEvent.class) {
            ((AgentWaitingForPtEventHandler)this.eventHandler).handleEvent((AgentWaitingForPtEvent)ev);
            return true;
        }
        if (this.isPersonEntersVehicleHandler && klass == PersonEntersVehicleEvent.class) {
            ((PersonEntersVehicleEventHandler)this.eventHandler).handleEvent((PersonEntersVehicleEvent)ev);
            return true;
        }
        if (this.isPersonLeavesVehicleHandler && klass == PersonLeavesVehicleEvent.class) {
            ((PersonLeavesVehicleEventHandler)this.eventHandler).handleEvent((PersonLeavesVehicleEvent)ev);
            return true;
        }
        if (this.isVehicleDepartsAtFacilityHandler && klass == VehicleDepartsAtFacilityEvent.class) {
            ((VehicleDepartsAtFacilityEventHandler)this.eventHandler).handleEvent((VehicleDepartsAtFacilityEvent)ev);
            return true;
        }
        if (this.isVehicleArrivesAtFacilityHandler && klass == VehicleArrivesAtFacilityEvent.class) {
            ((VehicleArrivesAtFacilityEventHandler)this.eventHandler).handleEvent((VehicleArrivesAtFacilityEvent)ev);
            return true;
        }
        if (this.isVehicleLeavesTrafficHandler && klass == VehicleLeavesTrafficEvent.class) {
            ((VehicleLeavesTrafficEventHandler)this.eventHandler).handleEvent((VehicleLeavesTrafficEvent)ev);
            return true;
        }
        if (this.isVehicleAbortsHandler && klass == VehicleAbortsEvent.class) {
            ((VehicleAbortsEventHandler)this.eventHandler).handleEvent((VehicleAbortsEvent)ev);
            return true;
        }
        if (this.isBasicEventHandler && klass == Event.class) {
            ((BasicEventHandler)this.eventHandler).handleEvent(ev);
            return true;
        }
        return false;
    }

    private static class HandlerInfo {
        protected final Method method;

        protected HandlerInfo(Method method) {
            this.method = method;
        }
    }
}

