/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.events.algorithms;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.events.ActivityEndEvent;
import org.matsim.api.core.v01.events.ActivityStartEvent;
import org.matsim.api.core.v01.events.LinkEnterEvent;
import org.matsim.api.core.v01.events.LinkLeaveEvent;
import org.matsim.api.core.v01.events.PersonArrivalEvent;
import org.matsim.api.core.v01.events.PersonDepartureEvent;
import org.matsim.api.core.v01.events.PersonMoneyEvent;
import org.matsim.api.core.v01.events.PersonStuckEvent;
import org.matsim.api.core.v01.events.VehicleEntersTrafficEvent;
import org.matsim.api.core.v01.events.handler.ActivityEndEventHandler;
import org.matsim.api.core.v01.events.handler.ActivityStartEventHandler;
import org.matsim.api.core.v01.events.handler.LinkEnterEventHandler;
import org.matsim.api.core.v01.events.handler.LinkLeaveEventHandler;
import org.matsim.api.core.v01.events.handler.PersonArrivalEventHandler;
import org.matsim.api.core.v01.events.handler.PersonDepartureEventHandler;
import org.matsim.api.core.v01.events.handler.PersonMoneyEventHandler;
import org.matsim.api.core.v01.events.handler.PersonStuckEventHandler;
import org.matsim.api.core.v01.events.handler.VehicleEntersTrafficEventHandler;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.population.Person;
import org.matsim.core.events.algorithms.EventWriter;
import org.matsim.core.utils.io.IOUtils;
import org.matsim.vehicles.Vehicle;

public class EventWriterTXT
implements EventWriter,
ActivityEndEventHandler,
ActivityStartEventHandler,
PersonArrivalEventHandler,
PersonDepartureEventHandler,
PersonStuckEventHandler,
PersonMoneyEventHandler,
VehicleEntersTrafficEventHandler,
LinkEnterEventHandler,
LinkLeaveEventHandler {
    private BufferedWriter out = null;
    private double lastTime = Double.NaN;
    private String timeString = null;
    private Map<Id<Vehicle>, Id<Person>> vehicleToDriverMap = new HashMap<Id<Vehicle>, Id<Person>>();

    public EventWriterTXT(String filename) {
        this.init(filename);
    }

    @Override
    public void closeFile() {
        if (this.out != null) {
            try {
                this.out.close();
                this.out = null;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void init(String outfilename) {
        if (this.out != null) {
            try {
                this.out.close();
                this.out = null;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            this.out = IOUtils.getBufferedWriter(outfilename);
            String eventsTxtFile = "T_GBL\t";
            eventsTxtFile = eventsTxtFile + "VEH_ID\t";
            eventsTxtFile = eventsTxtFile + "LEG_NR\t";
            eventsTxtFile = eventsTxtFile + "LINK_ID\t";
            eventsTxtFile = eventsTxtFile + "FROM_NODE_ID\t";
            eventsTxtFile = eventsTxtFile + "EVENT_FLAG\t";
            eventsTxtFile = eventsTxtFile + "DESCRIPTION\n";
            this.out.write(eventsTxtFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void reset(int iter) {
        this.closeFile();
    }

    private void writeLine(double time, Id<Person> agentId, Id<Link> linkId, int flag, String description) {
        try {
            this.out.write(this.getTimeString(time));
            if (agentId != null) {
                this.out.write(agentId.toString());
            }
            this.out.write(9);
            this.out.write(9);
            if (linkId != null) {
                this.out.write(linkId.toString());
            }
            this.out.write(9);
            this.out.write(48);
            this.out.write(9);
            this.out.write(Integer.toString(flag));
            this.out.write(9);
            if (description != null) {
                this.out.write(description);
            }
            this.out.write(10);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String getTimeString(double time) {
        if (time != this.lastTime) {
            this.lastTime = time;
            this.timeString = Long.toString((long)this.lastTime) + "\t";
        }
        return this.timeString;
    }

    @Override
    public void handleEvent(ActivityEndEvent event) {
        this.writeLine(event.getTime(), event.getPersonId(), event.getLinkId(), Number.ActivityEnd.ordinal(), "actend " + event.getActType());
    }

    @Override
    public void handleEvent(ActivityStartEvent event) {
        this.writeLine(event.getTime(), event.getPersonId(), event.getLinkId(), Number.ActivityStart.ordinal(), "actstart " + event.getActType());
    }

    @Override
    public void handleEvent(PersonArrivalEvent event) {
        this.writeLine(event.getTime(), event.getPersonId(), event.getLinkId(), Number.PersonArrival.ordinal(), "arrival");
    }

    @Override
    public void handleEvent(PersonDepartureEvent event) {
        this.writeLine(event.getTime(), event.getPersonId(), event.getLinkId(), Number.PersonDeparture.ordinal(), "departure");
    }

    @Override
    public void handleEvent(PersonStuckEvent event) {
        this.writeLine(event.getTime(), event.getPersonId(), event.getLinkId(), Number.PersonStuck.ordinal(), "stuckAndAbort");
    }

    @Override
    public void handleEvent(PersonMoneyEvent event) {
        this.writeLine(event.getTime(), event.getPersonId(), null, Number.PersonMoney.ordinal(), "agentMoney\t" + event.getAmount());
    }

    @Override
    public void handleEvent(VehicleEntersTrafficEvent event) {
        this.writeLine(event.getTime(), event.getPersonId(), event.getLinkId(), Number.VehicleEntersTraffic.ordinal(), "vehicle enters traffic");
        this.vehicleToDriverMap.put(event.getVehicleId(), event.getPersonId());
    }

    @Override
    public void handleEvent(LinkEnterEvent event) {
        this.writeLine(event.getTime(), this.vehicleToDriverMap.get(event.getVehicleId()), event.getLinkId(), Number.LinkEnter.ordinal(), "entered link");
    }

    @Override
    public void handleEvent(LinkLeaveEvent event) {
        this.writeLine(event.getTime(), this.vehicleToDriverMap.get(event.getVehicleId()), event.getLinkId(), Number.LinkLeave.ordinal(), "left link");
    }

    public static enum Number {
        PersonArrival,
        dummy,
        LinkLeave,
        PersonStuck,
        VehicleEntersTraffic,
        LinkEnter,
        PersonDeparture,
        ActivityStart,
        ActivityEnd,
        PersonMoney;

    }
}

