/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.events.algorithms;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.matsim.api.core.v01.events.Event;
import org.matsim.core.events.algorithms.EventWriter;
import org.matsim.core.events.handler.BasicEventHandler;
import org.matsim.core.utils.io.IOUtils;
import org.matsim.core.utils.io.UncheckedIOException;

public class EventWriterXML
implements EventWriter,
BasicEventHandler {
    private final BufferedWriter out;

    public EventWriterXML(String outfilename) {
        this.out = IOUtils.getBufferedWriter(outfilename);
        this.writeHeader();
    }

    public EventWriterXML(OutputStream stream) {
        this.out = new BufferedWriter(new OutputStreamWriter(stream, StandardCharsets.UTF_8));
        this.writeHeader();
    }

    private void writeHeader() {
        try {
            this.out.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<events version=\"1.0\">\n");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void closeFile() {
        try {
            this.out.write("</events>");
            this.out.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void reset(int iter) {
    }

    @Override
    public void handleEvent(Event event) {
        try {
            this.out.append("\t<event ");
            Map<String, String> attr = event.getAttributes();
            for (Map.Entry<String, String> entry : attr.entrySet()) {
                this.out.append(entry.getKey());
                this.out.append("=\"");
                this.out.append(this.encodeAttributeValue(entry.getValue()));
                this.out.append("\" ");
            }
            this.out.append(" />\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String encodeAttributeValue(String attributeValue) {
        if (attributeValue == null) {
            return null;
        }
        int len = attributeValue.length();
        boolean encode = false;
        for (int pos = 0; pos < len; ++pos) {
            char ch = attributeValue.charAt(pos);
            if (ch == '<') {
                encode = true;
                break;
            }
            if (ch == '>') {
                encode = true;
                break;
            }
            if (ch == '\"') {
                encode = true;
                break;
            }
            if (ch != '&') continue;
            encode = true;
            break;
        }
        if (encode) {
            StringBuilder bf = new StringBuilder(attributeValue.length() + 30);
            for (int pos = 0; pos < len; ++pos) {
                char ch = attributeValue.charAt(pos);
                if (ch == '<') {
                    bf.append("&lt;");
                    continue;
                }
                if (ch == '>') {
                    bf.append("&gt;");
                    continue;
                }
                if (ch == '\"') {
                    bf.append("&quot;");
                    continue;
                }
                if (ch == '&') {
                    bf.append("&amp;");
                    continue;
                }
                bf.append(ch);
            }
            return bf.toString();
        }
        return attributeValue;
    }
}

