/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.events.algorithms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.events.LinkEnterEvent;
import org.matsim.api.core.v01.events.LinkLeaveEvent;
import org.matsim.api.core.v01.events.PersonArrivalEvent;
import org.matsim.api.core.v01.events.PersonDepartureEvent;
import org.matsim.api.core.v01.events.PersonStuckEvent;
import org.matsim.api.core.v01.events.VehicleEntersTrafficEvent;
import org.matsim.api.core.v01.events.VehicleLeavesTrafficEvent;
import org.matsim.api.core.v01.events.handler.LinkEnterEventHandler;
import org.matsim.api.core.v01.events.handler.LinkLeaveEventHandler;
import org.matsim.api.core.v01.events.handler.PersonArrivalEventHandler;
import org.matsim.api.core.v01.events.handler.PersonDepartureEventHandler;
import org.matsim.api.core.v01.events.handler.PersonStuckEventHandler;
import org.matsim.api.core.v01.events.handler.VehicleEntersTrafficEventHandler;
import org.matsim.api.core.v01.events.handler.VehicleLeavesTrafficEventHandler;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.network.Network;
import org.matsim.api.core.v01.population.Person;
import org.matsim.core.config.groups.QSimConfigGroup;
import org.matsim.core.events.algorithms.Vehicle2DriverEventHandler;
import org.matsim.core.network.NetworkUtils;
import org.matsim.core.utils.geometry.CoordUtils;
import org.matsim.core.utils.misc.Time;
import org.matsim.vis.snapshotwriters.AgentSnapshotInfo;
import org.matsim.vis.snapshotwriters.AgentSnapshotInfoFactory;
import org.matsim.vis.snapshotwriters.SnapshotLinkWidthCalculator;
import org.matsim.vis.snapshotwriters.SnapshotWriter;

public class SnapshotGenerator
implements PersonDepartureEventHandler,
PersonArrivalEventHandler,
LinkEnterEventHandler,
LinkLeaveEventHandler,
VehicleEntersTrafficEventHandler,
PersonStuckEventHandler,
VehicleLeavesTrafficEventHandler {
    private static final Logger log = Logger.getLogger(SnapshotGenerator.class);
    private final Network network;
    private int lastSnapshotIndex = -1;
    private final double snapshotPeriod;
    private final HashMap<Id<Link>, EventLink> eventLinks;
    private final ArrayList<EventLink> linkList;
    private final HashMap<Id<Person>, EventAgent> eventAgents;
    private final List<SnapshotWriter> snapshotWriters = new ArrayList<SnapshotWriter>();
    private final double capCorrectionFactor;
    private final double storageCapFactor;
    private final QSimConfigGroup.SnapshotStyle snapshotStyle;
    private double skipUntil = 0.0;
    private final SnapshotLinkWidthCalculator linkWidthCalculator = new SnapshotLinkWidthCalculator();
    private final AgentSnapshotInfoFactory snapshotInfoFactory = new AgentSnapshotInfoFactory(this.linkWidthCalculator);
    private Vehicle2DriverEventHandler delegate = new Vehicle2DriverEventHandler();

    public SnapshotGenerator(Network network, double snapshotPeriod, QSimConfigGroup config) {
        this.network = network;
        int initialCapacity = (int)((double)network.getLinks().size() * 1.1);
        this.eventLinks = new HashMap(initialCapacity, 0.95f);
        this.linkList = new ArrayList(initialCapacity);
        this.eventAgents = new HashMap(1000, 0.95f);
        this.snapshotPeriod = snapshotPeriod;
        this.capCorrectionFactor = config.getFlowCapFactor() / network.getCapacityPeriod();
        this.storageCapFactor = config.getStorageCapFactor();
        this.snapshotStyle = config.getSnapshotStyle();
        if (!Double.isNaN(config.getLinkWidthForVis())) {
            this.linkWidthCalculator.setLinkWidthForVis(config.getLinkWidthForVis());
        }
        if (!Double.isNaN(network.getEffectiveLaneWidth())) {
            this.linkWidthCalculator.setLaneWidth(network.getEffectiveLaneWidth());
        }
        this.reset(-1);
    }

    public final void addSnapshotWriter(SnapshotWriter writer) {
        this.snapshotWriters.add(writer);
    }

    public final boolean removeSnapshotWriter(SnapshotWriter writer) {
        return this.snapshotWriters.remove(writer);
    }

    @Override
    public void handleEvent(PersonDepartureEvent event) {
        this.testForSnapshot(event.getTime());
        this.eventLinks.get(event.getLinkId()).departure(this.getEventAgent(event.getPersonId(), event.getTime()));
    }

    @Override
    public void handleEvent(PersonArrivalEvent event) {
        this.testForSnapshot(event.getTime());
        this.eventLinks.get(event.getLinkId()).arrival(this.getEventAgent(event.getPersonId(), event.getTime()));
    }

    @Override
    public void handleEvent(LinkEnterEvent event) {
        this.testForSnapshot(event.getTime());
        this.eventLinks.get(event.getLinkId()).enter(this.getEventAgent(this.delegate.getDriverOfVehicle(event.getVehicleId()), event.getTime()));
    }

    @Override
    public void handleEvent(LinkLeaveEvent event) {
        this.testForSnapshot(event.getTime());
        this.eventLinks.get(event.getLinkId()).leave(this.getEventAgent(this.delegate.getDriverOfVehicle(event.getVehicleId()), event.getTime()));
    }

    @Override
    public void handleEvent(VehicleEntersTrafficEvent event) {
        this.testForSnapshot(event.getTime());
        this.eventLinks.get(event.getLinkId()).wait2link(this.getEventAgent(event.getPersonId(), event.getTime()));
        this.delegate.handleEvent(event);
    }

    @Override
    public void handleEvent(PersonStuckEvent event) {
        this.testForSnapshot(event.getTime());
        if (event.getLinkId() != null) {
            this.eventLinks.get(event.getLinkId()).stuck(this.getEventAgent(event.getPersonId(), event.getTime()));
        }
    }

    @Override
    public void reset(int iteration) {
        this.eventLinks.clear();
        for (Link link : this.network.getLinks().values()) {
            double effectiveCellSize = this.network.getEffectiveCellSize();
            this.eventLinks.put(link.getId(), new EventLink(link, this.capCorrectionFactor, effectiveCellSize, this.storageCapFactor));
        }
        this.linkList.clear();
        this.linkList.addAll(this.eventLinks.values());
        this.eventAgents.clear();
        this.lastSnapshotIndex = -1;
        this.delegate.reset(iteration);
    }

    private EventAgent getEventAgent(Id<Person> id, double time) {
        EventAgent agent = this.eventAgents.get(id);
        if (agent == null) {
            agent = new EventAgent(id, time);
            this.eventAgents.put(id, agent);
        }
        agent.time = time;
        return agent;
    }

    private void testForSnapshot(double time) {
        int snapshotIndex = (int)(time / this.snapshotPeriod);
        if (this.lastSnapshotIndex == -1) {
            this.lastSnapshotIndex = snapshotIndex;
        }
        while (snapshotIndex > this.lastSnapshotIndex) {
            ++this.lastSnapshotIndex;
            double snapshotTime = (double)this.lastSnapshotIndex * this.snapshotPeriod;
            this.doSnapshot(snapshotTime);
        }
    }

    private void doSnapshot(double time) {
        if (time >= this.skipUntil && !this.snapshotWriters.isEmpty()) {
            Collection<AgentSnapshotInfo> positions = this.getVehiclePositions(time);
            for (SnapshotWriter writer : this.snapshotWriters) {
                writer.beginSnapshot(time);
                for (AgentSnapshotInfo position : positions) {
                    writer.addAgent(position);
                }
                writer.endSnapshot();
            }
        }
    }

    private Collection<AgentSnapshotInfo> getVehiclePositions(double time) {
        ArrayList<AgentSnapshotInfo> positions = new ArrayList<AgentSnapshotInfo>();
        if (this.snapshotStyle == QSimConfigGroup.SnapshotStyle.queue) {
            for (EventLink link : this.linkList) {
                link.getVehiclePositionsQueue(positions, time, this.snapshotInfoFactory);
            }
        } else if (this.snapshotStyle == QSimConfigGroup.SnapshotStyle.equiDist) {
            for (EventLink link : this.linkList) {
                link.getVehiclePositionsEquil(positions, time, this.snapshotInfoFactory);
            }
        } else {
            log.warn("Cannot generate snapshots offline (e.g., from events) for " + (Object)((Object)this.snapshotStyle) + ". This snapshot style is supported during simulation only.");
            throw new RuntimeException("The snapshotStyle \"" + (Object)((Object)this.snapshotStyle) + "\" is not supported.");
        }
        return positions;
    }

    public final void finish() {
        for (SnapshotWriter writer : this.snapshotWriters) {
            writer.finish();
        }
    }

    public final void skipUntil(double when) {
        this.skipUntil = when;
    }

    @Override
    public void handleEvent(VehicleLeavesTrafficEvent event) {
        this.delegate.handleEvent(event);
    }

    private static class EventAgent
    implements Comparable<EventAgent> {
        protected final Id<Person> id;
        protected final int intId;
        protected double time;
        protected EventLink currentLink = null;
        protected double speed = 0.0;
        protected int lane = 1;

        EventAgent(Id<Person> id, double time) {
            this.id = id;
            this.time = time;
            this.intId = id.hashCode();
        }

        @Override
        public int compareTo(EventAgent o) {
            return this.id.compareTo(o.id);
        }

        public boolean equals(Object o) {
            if (o instanceof EventAgent) {
                return this.id.equals(((EventAgent)o).id);
            }
            return false;
        }

        public int hashCode() {
            return this.id.hashCode();
        }
    }

    private static class EventLink {
        private final Link link;
        private final List<EventAgent> drivingQueue;
        private final List<EventAgent> parkingQueue;
        private final List<EventAgent> waitingQueue;
        private final List<EventAgent> buffer;
        private final double euklideanDist;
        private final double freespeedTravelTime;
        private final double spaceCap;
        private final double timeCap;
        private final double storageCapFactor;
        private final double inverseTimeCap;
        private final double effectiveCellSize;

        private EventLink(Link link2, double capCorrectionFactor, double effectiveCellSize, double storageCapFactor) {
            this.link = link2;
            this.drivingQueue = new ArrayList<EventAgent>();
            this.parkingQueue = new ArrayList<EventAgent>();
            this.waitingQueue = new ArrayList<EventAgent>();
            this.buffer = new ArrayList<EventAgent>();
            this.euklideanDist = CoordUtils.calcEuclideanDistance(link2.getFromNode().getCoord(), link2.getToNode().getCoord());
            this.freespeedTravelTime = Math.ceil(this.link.getLength() / this.link.getFreespeed()) + 1.0;
            this.timeCap = this.link.getCapacity() * capCorrectionFactor;
            this.storageCapFactor = storageCapFactor;
            this.inverseTimeCap = 1.0 / this.timeCap;
            this.effectiveCellSize = effectiveCellSize;
            this.spaceCap = this.link.getLength() * this.link.getNumberOfLanes() / this.effectiveCellSize * storageCapFactor;
        }

        private void enter(EventAgent agent) {
            if (agent.currentLink != null) {
                agent.currentLink.stuck(agent);
            }
            agent.currentLink = this;
            this.drivingQueue.add(agent);
        }

        private void leave(EventAgent agent) {
            this.drivingQueue.remove(agent);
            this.buffer.remove(agent);
            agent.currentLink = null;
        }

        private void arrival(EventAgent agent) {
            this.buffer.remove(agent);
            this.drivingQueue.remove(agent);
            this.parkingQueue.add(agent);
        }

        private void departure(EventAgent agent) {
            agent.currentLink = this;
            this.parkingQueue.remove(agent);
            this.waitingQueue.add(agent);
        }

        private void wait2link(EventAgent agent) {
            this.waitingQueue.remove(agent);
            this.buffer.add(agent);
        }

        private void stuck(EventAgent agent) {
            this.drivingQueue.remove(agent);
            this.parkingQueue.remove(agent);
            this.waitingQueue.remove(agent);
            this.buffer.remove(agent);
            agent.currentLink = null;
        }

        private void getVehiclePositionsQueue(Collection<AgentSnapshotInfo> positions, double time, AgentSnapshotInfoFactory snapshotInfoFactory) {
            AgentSnapshotInfo position;
            double queueEnd = this.link.getLength();
            double vehLen = Math.min(this.euklideanDist / this.spaceCap, this.effectiveCellSize / this.storageCapFactor);
            for (EventAgent agent : this.buffer) {
                double speed;
                int lane = 1 + agent.intId % NetworkUtils.getNumberOfLanesAsInt(time, this.link);
                int cmp = (int)(agent.time + this.freespeedTravelTime + this.inverseTimeCap + 2.0);
                agent.speed = speed = time > (double)cmp ? 0.0 : this.link.getFreespeed(time);
                AgentSnapshotInfo position2 = snapshotInfoFactory.createAgentSnapshotInfo(agent.id, this.link, queueEnd, lane);
                position2.setColorValueBetweenZeroAndOne(agent.speed);
                position2.setAgentState(AgentSnapshotInfo.AgentState.PERSON_DRIVING_CAR);
                positions.add(position2);
                queueEnd -= vehLen;
            }
            double lastDistance = 2.147483647E9;
            for (EventAgent agent : this.drivingQueue) {
                int cmp;
                double speed;
                double distanceOnLink;
                double travelTime = time - agent.time;
                double d = distanceOnLink = this.freespeedTravelTime == 0.0 ? 0.0 : travelTime / this.freespeedTravelTime * this.euklideanDist;
                if (distanceOnLink > queueEnd) {
                    distanceOnLink = queueEnd;
                    queueEnd -= vehLen;
                }
                if (distanceOnLink >= lastDistance && (distanceOnLink = lastDistance - vehLen) < 0.0) {
                    distanceOnLink = 0.0;
                }
                agent.speed = speed = time > (double)(cmp = (int)(agent.time + this.freespeedTravelTime + this.inverseTimeCap + 2.0)) ? 0.0 : this.link.getFreespeed(time);
                int lane = 1 + agent.intId % NetworkUtils.getNumberOfLanesAsInt(Time.getUndefinedTime(), this.link);
                AgentSnapshotInfo position3 = snapshotInfoFactory.createAgentSnapshotInfo(agent.id, this.link, distanceOnLink, lane);
                position3.setColorValueBetweenZeroAndOne(agent.speed);
                position3.setAgentState(AgentSnapshotInfo.AgentState.PERSON_DRIVING_CAR);
                positions.add(position3);
                lastDistance = distanceOnLink;
            }
            int lane = NetworkUtils.getNumberOfLanesAsInt(Time.getUndefinedTime(), this.link) + 1;
            for (EventAgent agent : this.waitingQueue) {
                position = snapshotInfoFactory.createAgentSnapshotInfo(agent.id, this.link, this.effectiveCellSize, lane);
                position.setColorValueBetweenZeroAndOne(0.0);
                position.setAgentState(AgentSnapshotInfo.AgentState.PERSON_AT_ACTIVITY);
                positions.add(position);
            }
            lane = NetworkUtils.getNumberOfLanesAsInt(Time.getUndefinedTime(), this.link) + 2;
            for (EventAgent agent : this.parkingQueue) {
                position = snapshotInfoFactory.createAgentSnapshotInfo(agent.id, this.link, this.effectiveCellSize, lane);
                position.setColorValueBetweenZeroAndOne(0.0);
                position.setAgentState(AgentSnapshotInfo.AgentState.PERSON_AT_ACTIVITY);
                positions.add(position);
            }
        }

        private void getVehiclePositionsEquil(Collection<AgentSnapshotInfo> positions, double time, AgentSnapshotInfoFactory snapshotInfoFactory) {
            int parkingQueueSize;
            int waitingQueueSize;
            int drivingQueueSize;
            int bufferSize = this.buffer.size();
            if (bufferSize + (drivingQueueSize = this.drivingQueue.size()) + (waitingQueueSize = this.waitingQueue.size()) + (parkingQueueSize = this.parkingQueue.size()) > 0) {
                AgentSnapshotInfo position;
                double distFromFromNode;
                double cellSize;
                int cnt = bufferSize + drivingQueueSize;
                int nLanes = NetworkUtils.getNumberOfLanesAsInt(time, this.link);
                double linkLength = this.link.getLength();
                if (cnt > 0) {
                    AgentSnapshotInfo position2;
                    int cmp;
                    double cellSize2 = linkLength / (double)cnt;
                    double distFromFromNode2 = linkLength - cellSize2 / 2.0;
                    double freespeed = this.link.getFreespeed(time);
                    for (EventAgent agent : this.buffer) {
                        agent.lane = 1 + agent.intId % nLanes;
                        cmp = (int)(agent.time + this.freespeedTravelTime + this.inverseTimeCap + 2.0);
                        agent.speed = time > (double)cmp ? 0.0 : freespeed;
                        position2 = snapshotInfoFactory.createAgentSnapshotInfo(agent.id, this.link, distFromFromNode2, agent.lane);
                        position2.setColorValueBetweenZeroAndOne(agent.speed);
                        position2.setAgentState(AgentSnapshotInfo.AgentState.PERSON_DRIVING_CAR);
                        positions.add(position2);
                        distFromFromNode2 -= cellSize2;
                    }
                    for (EventAgent agent : this.drivingQueue) {
                        agent.lane = 1 + agent.intId % nLanes;
                        cmp = (int)(agent.time + this.freespeedTravelTime + this.inverseTimeCap + 2.0);
                        agent.speed = time > (double)cmp ? 0.0 : freespeed;
                        position2 = snapshotInfoFactory.createAgentSnapshotInfo(agent.id, this.link, distFromFromNode2, agent.lane);
                        position2.setColorValueBetweenZeroAndOne(agent.speed);
                        position2.setAgentState(AgentSnapshotInfo.AgentState.PERSON_DRIVING_CAR);
                        positions.add(position2);
                        distFromFromNode2 -= cellSize2;
                    }
                }
                if (waitingQueueSize > 0) {
                    int lane = nLanes + 2;
                    cellSize = Math.min(this.effectiveCellSize, linkLength / (double)waitingQueueSize);
                    distFromFromNode = linkLength - cellSize / 2.0;
                    for (EventAgent agent : this.waitingQueue) {
                        agent.lane = lane;
                        agent.speed = 0.0;
                        position = snapshotInfoFactory.createAgentSnapshotInfo(agent.id, this.link, distFromFromNode, agent.lane);
                        position.setColorValueBetweenZeroAndOne(agent.speed);
                        position.setAgentState(AgentSnapshotInfo.AgentState.PERSON_AT_ACTIVITY);
                        positions.add(position);
                        distFromFromNode -= cellSize;
                    }
                }
                if (parkingQueueSize > 0) {
                    int lane = nLanes + 4;
                    cellSize = linkLength / (double)parkingQueueSize;
                    distFromFromNode = linkLength - cellSize / 2.0;
                    for (EventAgent agent : this.parkingQueue) {
                        agent.lane = lane;
                        agent.speed = 0.0;
                        position = snapshotInfoFactory.createAgentSnapshotInfo(agent.id, this.link, distFromFromNode, agent.lane);
                        position.setColorValueBetweenZeroAndOne(agent.speed);
                        position.setAgentState(AgentSnapshotInfo.AgentState.PERSON_AT_ACTIVITY);
                        positions.add(position);
                        distFromFromNode -= cellSize;
                    }
                }
            }
        }
    }
}

