/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.events.algorithms;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.events.VehicleEntersTrafficEvent;
import org.matsim.api.core.v01.events.VehicleLeavesTrafficEvent;
import org.matsim.api.core.v01.events.handler.VehicleEntersTrafficEventHandler;
import org.matsim.api.core.v01.events.handler.VehicleLeavesTrafficEventHandler;
import org.matsim.api.core.v01.population.Person;
import org.matsim.vehicles.Vehicle;

public final class Vehicle2DriverEventHandler
implements VehicleEntersTrafficEventHandler,
VehicleLeavesTrafficEventHandler {
    private final Map<Id<Vehicle>, Id<Person>> driverAgents = new ConcurrentHashMap<Id<Vehicle>, Id<Person>>();

    @Override
    public void reset(int iteration) {
        this.driverAgents.clear();
    }

    @Override
    public void handleEvent(VehicleEntersTrafficEvent event) {
        this.driverAgents.put(event.getVehicleId(), event.getPersonId());
    }

    @Override
    public void handleEvent(VehicleLeavesTrafficEvent event) {
        this.driverAgents.remove(event.getVehicleId());
    }

    public Id<Person> getDriverOfVehicle(Id<Vehicle> vehicleId) {
        return this.driverAgents.get(vehicleId);
    }
}

