/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.gbl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.apache.log4j.Logger;

public abstract class Gbl {
    private static final Logger log = Logger.getLogger(Gbl.class);
    public static final String ONLYONCE = " This message given only once.";
    public static final String FUTURE_SUPPRESSED = " Future occurences of this logging statement are suppressed.";
    public static final String SEPARATOR = "****************************";
    public static final String CREATE_ROUTING_ALGORITHM_WARNING_MESSAGE = "This class wants to overwrite createRoutingAlgorithm(), which is no longer possible.  Making createRoutingAlgorithm() non-final would not help since, after recent code changes, it is only used during initialization but not in replanning.  kai, may'13.  Aborting ...";
    public static final String NOT_IMPLEMENTED = "not implemented";
    public static final String ABSORBED_INTO_CORE = "This execution path is no longer supported.  The functionality has been absorbed into the core.";
    public static final String INVALID = "invalid";
    private static long measurementStartTime = Long.MAX_VALUE;
    private static final ThreadMXBean tbe = ManagementFactory.getThreadMXBean();
    public static final String RUN_MOB_SIM_NO_LONGER_POSSIBLE = "overriding runMobSim() no longer possible.  use the following syntax instead:\ncontroler.addOverridingModule(new AbstractModule(){\n@Override public void install() {\nthis.bindMobsim().toProvider(MyMobsimProvider.class) ;\n}\n});\nSee, e.g., the RunMobsimWithMultipleModeVehiclesExample class under tutorial.*.  Talk to MZ or KN if you need help. kai, may'15";
    public static final String SET_UP_IS_NOW_FINAL = "controler.setUp() is now final. You should be able to do whatever you need to do with a ControlerStartupListener. Please talk to MZ or KN if you have difficulties. kai, may'15";
    public static final String LOAD_DATA_IS_NOW_FINAL = "controler.loadData() is now final.  If you need this functionality, use ScenarioUtils.loadScenario(...), then modify the scenario, then pass it into new Controler( scenario ).  Talk to MZ or KN if you need help.  kai, may'15";
    public static final String CONTROLER_IS_NOW_FINAL = "The Controler class is now final.  Everything that used to be possible by inheritance should now be doable by other constructs.  See tutorial.programming.* for examples.  Please talkto MZ or KN if you would like to get help.  kai, may'15";
    public static final String RETROFIT_CONTROLER = "The Controler class is now final.  Everything that used to be possible by inheritance should now be doable by other constructs.  See tutorial.programming.* for examples.  Please talkto MZ or KN if you would like to get help.  kai, may'15 I tried to adapt this to new syntaxbut please check functionality. kai, mar'15";
    public static final String PROBLEM_WITH_ACCESS_EGRESS = "When the TripRouter also generates access/egress legs, within-day replanning needs to sort out if it wants that, or if it just wants to replan the current leg.  kai, feb'16";
    public static final String WRONG_IMPLEMENTATION = "wrong implementation of interface; ";
    public static final String COPY_PASTE_FROM_CORE_NO_LONGER_WORKING = "Another solution for this has been found in the core, and thus this copy-and-paste from the core is no longer working.";

    public static final void printMemoryUsage() {
        long totalMem = Runtime.getRuntime().totalMemory();
        long freeMem = Runtime.getRuntime().freeMemory();
        long usedMem = totalMem - freeMem;
        log.info("used RAM: " + usedMem + "B = " + usedMem / 1024L + "kB = " + usedMem / 1024L / 1024L + "MB" + "  free: " + freeMem + "B = " + freeMem / 1024L / 1024L + "MB  total: " + totalMem + "B = " + totalMem / 1024L / 1024L + "MB");
    }

    public static final void printSystemInfo() {
        log.info("JVM: " + System.getProperty("java.version") + "; " + System.getProperty("java.vm.vendor") + "; " + System.getProperty("java.vm.info") + "; " + System.getProperty("sun.arch.data.model") + "-bit");
        log.info("OS: " + System.getProperty("os.name") + "; " + System.getProperty("os.version") + "; " + System.getProperty("os.arch"));
        log.info("CPU cores: " + Runtime.getRuntime().availableProcessors());
        log.info("max. Memory: " + (double)Runtime.getRuntime().maxMemory() / 1024.0 / 1024.0 + "MB (" + Runtime.getRuntime().maxMemory() + "B)");
    }

    public static final String getBuildInfoString() {
        return Gbl.getBuildInfoString("MATSim", "/revision.txt");
    }

    public static final String getBuildInfoString(String component, String resourceFilename) {
        String revision = null;
        String date = null;
        URL url = Gbl.class.getResource(resourceFilename);
        if (url != null) {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream(), StandardCharsets.UTF_8));){
                revision = reader.readLine();
                date = reader.readLine();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (revision == null) {
                return component + "-Build: unknown";
            }
            return component + "-Build: " + revision + " (" + date + ")";
        }
        return component + "-Build: unknown";
    }

    public static final void printBuildInfo() {
        Gbl.printBuildInfo("MATSim", "/revision.txt");
    }

    public static final void printBuildInfo(String component, String resourceFilename) {
        String infoString = Gbl.getBuildInfoString(component, resourceFilename);
        log.info(infoString);
    }

    private static final String printTime() {
        if (measurementStartTime == Long.MAX_VALUE) {
            log.error("Did not start measurements.");
            return "";
        }
        return Gbl.printTimeDiff(System.currentTimeMillis(), measurementStartTime);
    }

    private static final String printTimeDiff(long later, long earlier) {
        long elapsedTimeMillis = later - earlier;
        float elapsedTimeSec = (float)elapsedTimeMillis / 1000.0f;
        float elapsedTimeMin = (float)elapsedTimeMillis / 60000.0f;
        float elapsedTimeHour = (float)elapsedTimeMillis / 3600000.0f;
        float elapsedTimeDay = (float)elapsedTimeMillis / 8.64E7f;
        return elapsedTimeMillis + " msecs; " + elapsedTimeSec + " secs; " + elapsedTimeMin + " mins; " + elapsedTimeHour + " hours; " + elapsedTimeDay + " days ###";
    }

    public static final void startMeasurement() {
        measurementStartTime = System.currentTimeMillis();
    }

    public static final void printElapsedTime() {
        log.info("### elapsed time: " + Gbl.printTime());
    }

    public static final void printRoundTime() {
        log.info("### round time: " + Gbl.printTime());
        Gbl.startMeasurement();
    }

    public static final boolean enableThreadCpuTimeMeasurement() {
        if (tbe.isThreadCpuTimeSupported()) {
            tbe.setThreadCpuTimeEnabled(true);
            return true;
        }
        return false;
    }

    public static final double getThreadCpuTime(Thread thread) {
        if (tbe.isThreadCpuTimeEnabled()) {
            return (double)tbe.getThreadCpuTime(thread.getId()) / 1.0E9;
        }
        return -1.0;
    }

    public static final void printThreadCpuTime(Thread thread) {
        if (tbe.isThreadCpuTimeEnabled()) {
            log.info("Thread performance: Thread=" + thread.getName() + "  cpu-time=" + Gbl.getThreadCpuTime(thread) + "sec");
        }
    }

    public static final void printCurrentThreadCpuTime() {
        Gbl.printThreadCpuTime(Thread.currentThread());
    }

    public static void assertIf(boolean flag) {
        if (!flag) {
            throw new RuntimeException("assertion error; follow stack trace");
        }
    }

    public static void assertNotNull(Object obj) {
        if (obj == null) {
            throw new RuntimeException("Object is null; follow stack trace");
        }
    }

    public static void fail() {
        throw new RuntimeException("failure; follow stack trace");
    }

    public static String aboutToWrite(String what, String filename) {
        return "about to write " + what + " to: " + filename;
    }

    public static String aboutToRead(String what, URL url) {
        return "about to read " + what + " from: " + url;
    }

    public static String aboutToRead(String what, String filename) {
        return "about to read " + what + " from: " + filename;
    }
}

