/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.gbl;

import java.util.Random;
import org.apache.log4j.Logger;

public abstract class MatsimRandom {
    private static final Logger log = Logger.getLogger(MatsimRandom.class);
    private static final long DEFAULT_RANDOM_SEED = 4711L;
    private static long lastUsedSeed = 4711L;
    private static int internalCounter = 0;
    private static final Random random = new Random(4711L);

    public static void reset() {
        MatsimRandom.reset(4711L);
    }

    public static void reset(long seed) {
        lastUsedSeed = seed;
        internalCounter = 0;
        MatsimRandom.getRandom().setSeed(seed);
    }

    public static Random getRandom() {
        return random;
    }

    public static Random getLocalInstance() {
        Random r = new Random(lastUsedSeed + (long)(++internalCounter) * 23L);
        MatsimRandom.prepareRNG(r);
        return r;
    }

    private static void prepareRNG(Random rng) {
        for (int i = 0; i < 100; ++i) {
            rng.nextDouble();
        }
    }

    public static final void printRNGState(String label) {
        if (random instanceof InstrumentedRandom) {
            log.warn("label=" + label + ";\tnumber of doubles draws = " + ((InstrumentedRandom)random).numberOfDrawnDoubles());
        }
        log.warn("label=" + label + ";\tnumber of local instances =" + internalCounter);
    }

    private static final class InstrumentedRandom
    extends Random {
        private long cntDbl = 0L;

        InstrumentedRandom(long defaultRandomSeed) {
            super(defaultRandomSeed);
        }

        @Override
        public double nextDouble() {
            ++this.cntDbl;
            return super.nextDouble();
        }

        long numberOfDrawnDoubles() {
            return this.cntDbl;
        }
    }
}

