/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.gbl;

import java.awt.Image;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.imageio.ImageIO;
import org.apache.log4j.Logger;

public abstract class MatsimResource {
    private static final String RES_PATH_JARFILE = "/res/";
    private static final String RES_PATH_LOCAL = "./res/";
    private static final String RES_PATH_LOCAL2 = "./src/main/resources/res/";
    private static final Logger log = Logger.getLogger(MatsimResource.class);

    public static final URL getAsURL(String filename) {
        URL url;
        File file = new File(RES_PATH_LOCAL + filename);
        if (file.exists()) {
            try {
                return file.toURI().toURL();
            }
            catch (MalformedURLException e) {
                log.warn("Found resource-file, but could not return URL for it.", e);
            }
        }
        if ((file = new File(RES_PATH_LOCAL2 + filename)).exists()) {
            try {
                return file.toURI().toURL();
            }
            catch (MalformedURLException e) {
                log.warn("Found resource-file, but could not return URL for it.", e);
            }
        }
        if ((url = MatsimResource.class.getResource(RES_PATH_JARFILE + filename)) == null) {
            log.warn("Resource '" + filename + "' not found!");
        }
        return url;
    }

    public static final InputStream getAsInputStream(String filename) {
        try {
            return new FileInputStream(RES_PATH_LOCAL + filename);
        }
        catch (FileNotFoundException e) {
            log.info("Resource '" + filename + "' not found locally. May not be fatal.");
            InputStream stream = MatsimResource.class.getResourceAsStream(RES_PATH_JARFILE + filename);
            if (stream == null) {
                log.warn("Resource '" + filename + "' not found!");
            }
            return stream;
        }
    }

    public static final Image getAsImage(String filename) {
        URL url = MatsimResource.getAsURL(filename);
        if (url == null) {
            return null;
        }
        try {
            return ImageIO.read(url);
        }
        catch (IOException e) {
            log.error("Could not load requested image", e);
            return null;
        }
    }
}

