/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.mobsim.external;

import java.io.FileNotFoundException;
import java.io.IOException;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Scenario;
import org.matsim.api.core.v01.population.Person;
import org.matsim.api.core.v01.population.Plan;
import org.matsim.api.core.v01.population.Population;
import org.matsim.api.core.v01.population.PopulationFactory;
import org.matsim.core.api.experimental.events.EventsManager;
import org.matsim.core.config.Config;
import org.matsim.core.config.ConfigGroup;
import org.matsim.core.config.ConfigUtils;
import org.matsim.core.config.ConfigWriter;
import org.matsim.core.config.groups.ExternalMobimConfigGroup;
import org.matsim.core.controler.OutputDirectoryHierarchy;
import org.matsim.core.events.MatsimEventsReader;
import org.matsim.core.gbl.Gbl;
import org.matsim.core.mobsim.framework.Mobsim;
import org.matsim.core.population.PopulationUtils;
import org.matsim.core.population.io.PopulationWriter;
import org.matsim.core.replanning.ReplanningContext;
import org.matsim.core.utils.misc.ExeRunner;

public class ExternalMobsim
implements Mobsim {
    private static final String CONFIG_MODULE = "simulation";
    protected final Scenario scenario;
    protected final EventsManager events;
    protected String plansFileName = null;
    protected String eventsFileName = null;
    protected String configFileName = null;
    protected String executable = null;
    private static final Logger log = Logger.getLogger(ExternalMobsim.class);
    private Integer iterationNumber = null;
    protected OutputDirectoryHierarchy controlerIO;
    private ExternalMobimConfigGroup simConfig;

    @Inject
    public ExternalMobsim(Scenario scenario, EventsManager events) {
        this.scenario = scenario;
        this.events = events;
        this.init();
    }

    protected void init() {
        this.plansFileName = "ext_plans.xml";
        this.eventsFileName = "ext_events.txt";
        this.configFileName = "ext_config.xml";
        this.simConfig = ConfigUtils.addOrGetModule(this.scenario.getConfig(), "externalMobsim", ExternalMobimConfigGroup.class);
        this.executable = this.simConfig.getExternalExe();
    }

    @Override
    public void run() {
        String iterationPlansFile = this.controlerIO.getIterationFilename(this.iterationNumber, this.plansFileName);
        String iterationEventsFile = this.controlerIO.getIterationFilename(this.iterationNumber, this.eventsFileName);
        String iterationConfigFile = this.controlerIO.getIterationFilename(this.iterationNumber, this.configFileName);
        try {
            this.writePlans(iterationPlansFile);
            this.writeConfig(iterationPlansFile, iterationEventsFile, iterationConfigFile);
            this.runExe(iterationConfigFile);
            this.readEvents(iterationEventsFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void writeConfig(String iterationPlansFile, String iterationEventsFile, String iterationConfigFile) throws FileNotFoundException, IOException {
        log.info("writing config for external mobsim");
        Config thisConfig = this.scenario.getConfig();
        Config extConfig = new Config();
        ConfigGroup module = extConfig.createModule("network");
        module.addParam("inputNetworkFile", thisConfig.network().getInputFile());
        module.addParam("localInputDTD", "dtd/matsim_v1.dtd");
        module = extConfig.createModule("plans");
        module.addParam("inputPlansFile", iterationPlansFile);
        module.addParam("inputVersion", "matsimXMLv4");
        module = extConfig.createModule("events");
        module.addParam("outputFile", iterationEventsFile);
        module.addParam("outputFormat", "matsimTXTv1");
        module = extConfig.createModule(CONFIG_MODULE);
        module.addParam("startTime", Double.toString(this.simConfig.getStartTime()));
        module.addParam("endTime", Double.toString(this.simConfig.getEndTime()));
        new ConfigWriter(extConfig).write(iterationConfigFile);
    }

    protected void writePlans(String iterationPlansFile) {
        log.info("writing plans for external mobsim");
        log.warn("I don't know if this works; was changed after the streaming api changed, and never tested after that.  Pls let us know. kai, jul'16");
        Population pop2 = PopulationUtils.createPopulation(ConfigUtils.createConfig());
        PopulationFactory pf = pop2.getFactory();
        for (Person person : this.scenario.getPopulation().getPersons().values()) {
            Person person2 = pf.createPerson(person.getId());
            Plan plan2 = pf.createPlan();
            PopulationUtils.copyFromTo((Plan)person.getSelectedPlan(), plan2);
            person2.addPlan(plan2);
            pop2.addPerson(person2);
        }
        PopulationWriter writer = new PopulationWriter(pop2);
        writer.writeV4(iterationPlansFile);
    }

    protected void runExe(String iterationConfigFile) throws FileNotFoundException, IOException {
        String cmd = this.executable + " " + iterationConfigFile;
        log.info("running command: " + cmd);
        Gbl.printMemoryUsage();
        String logfileName = this.controlerIO.getIterationFilename(this.getIterationNumber(), "mobsim.log");
        int timeout = this.simConfig.getExternalTimeOut();
        int exitcode = ExeRunner.run(cmd, logfileName, timeout);
        if (exitcode != 0) {
            throw new RuntimeException("There was a problem running the external mobsim. exit code: " + exitcode);
        }
    }

    protected void readEvents(String iterationEventsFile) throws FileNotFoundException, IOException {
        log.info("reading events from external mobsim");
        new MatsimEventsReader(this.events).readFile(iterationEventsFile);
    }

    public Integer getIterationNumber() {
        return this.iterationNumber;
    }

    public void setIterationNumber(Integer iterationNumber) {
        this.iterationNumber = iterationNumber;
    }

    @Inject
    public void setControlerIO(OutputDirectoryHierarchy controlerIO) {
        this.controlerIO = controlerIO;
    }

    @Inject
    void setIterationNumberFrom(ReplanningContext replanningContext) {
        this.iterationNumber = replanningContext.getIteration();
    }
}

