/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.mobsim.framework;

import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.util.Modules;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.matsim.core.config.Config;

public abstract class AbstractMobsimModule
extends AbstractModule {
    private Optional<Config> config = Optional.empty();
    private Optional<AbstractMobsimModule> parent = Optional.empty();

    public final void setConfig(Config config) {
        this.config = Optional.of(config);
    }

    public final void setParent(AbstractMobsimModule parent) {
        this.parent = Optional.of(parent);
    }

    protected final Config getConfig() {
        if (this.config.isPresent()) {
            return this.config.get();
        }
        if (this.parent.isPresent()) {
            return this.parent.get().getConfig();
        }
        throw new IllegalStateException("No config set. Did you try to use the module outside of the QSim initialization process?");
    }

    @Override
    protected final void configure() {
        this.configureMobsim();
    }

    protected abstract void configureMobsim();

    public static AbstractMobsimModule overrideMobsimModules(Collection<AbstractMobsimModule> base, List<AbstractMobsimModule> overrides) {
        final Module composite = Modules.override(base).with(overrides);
        AbstractMobsimModule wrapper = new AbstractMobsimModule(){

            @Override
            protected void configureMobsim() {
                this.install(composite);
            }
        };
        base.forEach(m3 -> m3.setParent(wrapper));
        overrides.forEach(m3 -> m3.setParent(wrapper));
        return wrapper;
    }
}

