/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.mobsim.framework;

import java.util.concurrent.Phaser;
import java.util.concurrent.Semaphore;
import org.matsim.core.mobsim.framework.ObservableMobsim;
import org.matsim.core.mobsim.framework.PlayPauseSimulationControlI;
import org.matsim.core.mobsim.framework.events.MobsimAfterSimStepEvent;
import org.matsim.core.mobsim.framework.events.MobsimBeforeCleanupEvent;
import org.matsim.core.mobsim.framework.events.MobsimBeforeSimStepEvent;
import org.matsim.core.mobsim.framework.listeners.MobsimAfterSimStepListener;
import org.matsim.core.mobsim.framework.listeners.MobsimBeforeCleanupListener;
import org.matsim.core.mobsim.framework.listeners.MobsimBeforeSimStepListener;

public class PlayPauseSimulationControl
implements PlayPauseSimulationControlI {
    private volatile Status status = Status.PLAY;
    private final Semaphore access = new Semaphore(1, true);
    private volatile double localTime = -1.0;
    private final Phaser stepDone = new Phaser(1);

    public PlayPauseSimulationControl(ObservableMobsim qSim) {
        PlayPauseMobsimListener playPauseMobsimListener = new PlayPauseMobsimListener();
        qSim.addQueueSimulationListeners(playPauseMobsimListener);
    }

    @Override
    public final void doStep(int time) {
        if (this.status == Status.PLAY) {
            throw new IllegalStateException();
        }
        while (this.localTime < (double)time) {
            this.stepDone.arriveAndAwaitAdvance();
        }
    }

    @Override
    public final void pause() {
        if (this.status != Status.PAUSE) {
            this.stepDone.register();
            this.status = Status.PAUSE;
        }
    }

    @Override
    public final void play() {
        if (this.status != Status.PLAY) {
            this.stepDone.arriveAndDeregister();
            this.status = Status.PLAY;
        }
    }

    public final Semaphore getAccess() {
        return this.access;
    }

    public final boolean isFinished() {
        return this.localTime == Double.MAX_VALUE;
    }

    public final double getLocalTime() {
        return this.localTime;
    }

    private class PlayPauseMobsimListener
    implements MobsimBeforeSimStepListener,
    MobsimAfterSimStepListener,
    MobsimBeforeCleanupListener {
        private PlayPauseMobsimListener() {
        }

        @Override
        public void notifyMobsimBeforeSimStep(MobsimBeforeSimStepEvent event) {
            try {
                PlayPauseSimulationControl.this.access.acquire();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void notifyMobsimAfterSimStep(MobsimAfterSimStepEvent event) {
            PlayPauseSimulationControl.this.access.release();
            PlayPauseSimulationControl.this.localTime = (int)event.getSimulationTime();
            PlayPauseSimulationControl.this.stepDone.arriveAndAwaitAdvance();
        }

        @Override
        public void notifyMobsimBeforeCleanup(MobsimBeforeCleanupEvent e) {
            PlayPauseSimulationControl.this.localTime = Double.MAX_VALUE;
            PlayPauseSimulationControl.this.stepDone.arriveAndDeregister();
        }
    }

    public static enum Status {
        PAUSE,
        PLAY;

    }
}

