/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.mobsim.jdeqsim;

import java.util.List;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.events.ActivityStartEvent;
import org.matsim.api.core.v01.events.Event;
import org.matsim.api.core.v01.events.LinkEnterEvent;
import org.matsim.api.core.v01.events.PersonArrivalEvent;
import org.matsim.api.core.v01.events.VehicleLeavesTrafficEvent;
import org.matsim.api.core.v01.population.Activity;
import org.matsim.api.core.v01.population.Leg;
import org.matsim.api.core.v01.population.Plan;
import org.matsim.api.core.v01.population.PlanElement;
import org.matsim.core.config.groups.PlansConfigGroup;
import org.matsim.core.mobsim.jdeqsim.EventMessage;
import org.matsim.core.mobsim.jdeqsim.Road;
import org.matsim.core.mobsim.jdeqsim.Scheduler;
import org.matsim.core.mobsim.jdeqsim.Vehicle;
import org.matsim.core.mobsim.qsim.agents.ActivityDurationUtils;

public class EndLegMessage
extends EventMessage {
    private final PlansConfigGroup.ActivityDurationInterpretation activityDurationInterpretation;

    public EndLegMessage(Scheduler scheduler, Vehicle vehicle) {
        super(scheduler, vehicle);
        this.priority = 150;
        this.activityDurationInterpretation = vehicle == null ? PlansConfigGroup.ActivityDurationInterpretation.minOfDurationAndEndTime : vehicle.getActivityEndTimeInterpretation();
    }

    @Override
    public void handleMessage() {
        this.vehicle.setLegIndex(this.vehicle.getLegIndex() + 2);
        this.vehicle.setLinkIndex(-1);
        Plan plan = (Plan)this.vehicle.getOwnerPerson().getSelectedPlan();
        List<PlanElement> actsLegs = plan.getPlanElements();
        if (actsLegs.size() > this.vehicle.getLegIndex()) {
            this.vehicle.setCurrentLeg((Leg)actsLegs.get(this.vehicle.getLegIndex()));
            Activity currentAct = (Activity)actsLegs.get(this.vehicle.getLegIndex() - 1);
            double departureTime = ActivityDurationUtils.calculateDepartureTime(currentAct, this.getMessageArrivalTime(), this.activityDurationInterpretation);
            if (departureTime < this.getMessageArrivalTime()) {
                departureTime = this.getMessageArrivalTime();
            }
            this.vehicle.setCurrentLinkId(currentAct.getLinkId());
            Road road = Road.getRoad(this.vehicle.getCurrentLinkId());
            this.vehicle.scheduleStartingLegMessage(departureTime, road);
        }
    }

    @Override
    public void processEvent() {
        Event event = null;
        if (this.vehicle.getCurrentLeg().getMode().equals("car") && this.vehicle.getCurrentLinkRoute() != null && this.vehicle.getCurrentLinkRoute().length != 0) {
            event = new LinkEnterEvent(this.getMessageArrivalTime(), Id.create(this.vehicle.getOwnerPerson().getId().toString(), org.matsim.vehicles.Vehicle.class), this.vehicle.getCurrentLinkId());
            eventsManager.processEvent(event);
        }
        Id<org.matsim.vehicles.Vehicle> vehicleId = Id.create(this.vehicle.getOwnerPerson().getId(), org.matsim.vehicles.Vehicle.class);
        event = new VehicleLeavesTrafficEvent(this.getMessageArrivalTime(), this.vehicle.getOwnerPerson().getId(), this.vehicle.getCurrentLinkId(), vehicleId, this.vehicle.getCurrentLeg().getMode(), 1.0);
        eventsManager.processEvent(event);
        event = new PersonArrivalEvent(this.getMessageArrivalTime(), this.vehicle.getOwnerPerson().getId(), this.vehicle.getCurrentLinkId(), this.vehicle.getCurrentLeg().getMode());
        eventsManager.processEvent(event);
        Activity nextAct = this.vehicle.getNextActivity();
        double actStartEventTime = nextAct.getStartTime();
        if (this.getMessageArrivalTime() > actStartEventTime) {
            actStartEventTime = this.getMessageArrivalTime();
        }
        event = new ActivityStartEvent(actStartEventTime, this.vehicle.getOwnerPerson().getId(), this.vehicle.getCurrentLinkId(), nextAct.getFacilityId(), nextAct.getType());
        eventsManager.processEvent(event);
    }
}

