/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.mobsim.jdeqsim;

import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.events.Event;
import org.matsim.api.core.v01.events.LinkEnterEvent;
import org.matsim.api.core.v01.events.VehicleEntersTrafficEvent;
import org.matsim.core.mobsim.jdeqsim.EventMessage;
import org.matsim.core.mobsim.jdeqsim.Road;
import org.matsim.core.mobsim.jdeqsim.Scheduler;
import org.matsim.core.mobsim.jdeqsim.Vehicle;

public class EnterRoadMessage
extends EventMessage {
    @Override
    public void handleMessage() {
        Road road = Road.getRoad(this.vehicle.getCurrentLinkId());
        road.enterRoad(this.vehicle, this.getMessageArrivalTime());
    }

    public EnterRoadMessage(Scheduler scheduler, Vehicle vehicle) {
        super(scheduler, vehicle);
        this.priority = 100;
    }

    @Override
    public void processEvent() {
        Event event = null;
        event = this.vehicle.getLinkIndex() == -1 ? new VehicleEntersTrafficEvent(this.getMessageArrivalTime(), this.vehicle.getOwnerPerson().getId(), this.vehicle.getCurrentLinkId(), Id.create(this.vehicle.getOwnerPerson().getId(), org.matsim.vehicles.Vehicle.class), null, 1.0) : new LinkEnterEvent(this.getMessageArrivalTime(), Id.create(this.vehicle.getOwnerPerson().getId(), org.matsim.vehicles.Vehicle.class), this.vehicle.getCurrentLinkId());
        eventsManager.processEvent(event);
    }
}

