/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.mobsim.jdeqsim;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;

public class EventLog {
    double time = 0.0;
    int vehicleId = 0;
    int legNo = 0;
    int linkId = 0;
    int fromNodeId = 0;
    int toNodeId = 0;
    String type = null;

    public EventLog(double time, int vehicleId, int legNo, int linkId, int fromNodeId, int toNodeId, String type) {
        this.time = time;
        this.vehicleId = vehicleId;
        this.legNo = legNo;
        this.linkId = linkId;
        this.fromNodeId = fromNodeId;
        this.toNodeId = toNodeId;
        this.type = type;
    }

    public void print() {
        System.out.print("time: " + this.time);
        System.out.print(";vehicleId: " + this.vehicleId);
        System.out.print(";legNo: " + this.legNo);
        System.out.print(";linkId: " + this.linkId);
        System.out.print(";fromNodeId: " + this.fromNodeId);
        System.out.print(";toNodeId: " + this.toNodeId);
        System.out.print(";type: " + this.type);
        System.out.println();
    }

    public double getTime() {
        return this.time;
    }

    public void setTime(double time) {
        this.time = time;
    }

    public int getVehicleId() {
        return this.vehicleId;
    }

    public void setVehicleId(int vehicleId) {
        this.vehicleId = vehicleId;
    }

    public int getLegNo() {
        return this.legNo;
    }

    public void setLegNo(int legNo) {
        this.legNo = legNo;
    }

    public int getLinkId() {
        return this.linkId;
    }

    public void setLinkId(int linkId) {
        this.linkId = linkId;
    }

    public int getFromNodeId() {
        return this.fromNodeId;
    }

    public void setFromNodeId(int fromNodeId) {
        this.fromNodeId = fromNodeId;
    }

    public int getToNodeId() {
        return this.toNodeId;
    }

    public void setToNodeId(int toNodeId) {
        this.toNodeId = toNodeId;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public static boolean compare(ArrayList<EventLog> eventLog1, ArrayList<EventLog> eventLog2) {
        int NoOfNotEqualEvents = 0;
        assert (eventLog1.size() == eventLog2.size()) : "The size of both eventLogs must be the same!";
        for (int i = 0; i < eventLog1.size(); ++i) {
            if (EventLog.equals(eventLog1.get(i), eventLog2.get(i))) continue;
            return false;
        }
        System.out.println("# Events Java: " + eventLog1.size());
        System.out.println("# Events C++: " + eventLog2.size());
        System.out.println("NoOfNotEqualEvents: " + NoOfNotEqualEvents);
        return true;
    }

    public static boolean equals(EventLog eventLog1, EventLog eventLog2) {
        if (Math.rint(eventLog1.getTime() * 10000.0) == Math.rint(eventLog2.getTime() * 10000.0) && eventLog1.getLinkId() == eventLog2.getLinkId()) {
            return true;
        }
        System.out.println("====PROBLEM=====");
        eventLog1.print();
        eventLog2.print();
        System.out.println("=========");
        return false;
    }

    public static void print(ArrayList<EventLog> eventLog) {
        for (int i = 0; i < eventLog.size(); ++i) {
            eventLog.get(i).print();
        }
    }

    public static double absAverageLinkDiff(ArrayList<EventLog> eventLog1, ArrayList<EventLog> eventLog2) {
        HashMap<Integer, Double[]> hm = new HashMap<Integer, Double[]>();
        assert (eventLog1.size() == eventLog2.size()) : "The size of both eventLogs must be the same!" + eventLog1.size() + " - " + eventLog2.size();
        for (int i = 0; i < eventLog1.size(); ++i) {
            int link1 = eventLog1.get(i).getLinkId();
            if (!hm.containsKey(link1)) {
                Double[] d = new Double[]{0.0, 0.0, 0.0, 0.0};
                hm.put(link1, d);
            }
            ((Double[])hm.get((Object)Integer.valueOf((int)link1)))[1] = eventLog1.get((int)i).time - ((Double[])hm.get(link1))[0];
            int link2 = eventLog2.get(i).getLinkId();
            if (!hm.containsKey(link2)) {
                Double[] d = new Double[]{0.0, 0.0, 0.0, 0.0};
                hm.put(link2, d);
            }
            ((Double[])hm.get((Object)Integer.valueOf((int)link2)))[3] = eventLog2.get((int)i).time - ((Double[])hm.get(link2))[2];
        }
        double absSum = 0.0;
        double absAverage = 0.0;
        for (Double[] d : hm.values()) {
            absSum += Math.abs(d[1] - d[3]);
        }
        absAverage = absSum / (double)hm.size();
        System.out.println("absSumLink:" + absSum);
        System.out.println("absAverageLinkDiff:" + absAverage);
        return absAverage;
    }

    public static void filterEvents(int linkId, ArrayList<EventLog> eventLog1, ArrayList<EventLog> eventLog2) {
        LinkedList<EventLog> list1 = new LinkedList<EventLog>();
        LinkedList<EventLog> list2 = new LinkedList<EventLog>();
        assert (eventLog1.size() == eventLog2.size()) : "The size of both eventLogs must be the same!";
        for (int i = 0; i < eventLog1.size(); ++i) {
            if (eventLog1.get((int)i).linkId == linkId) {
                list1.add(eventLog1.get(i));
            }
            if (eventLog2.get((int)i).linkId != linkId) continue;
            list2.add(eventLog2.get(i));
        }
        assert (list1.size() == list2.size()) : "Inconsistent list size!";
        int noOfDifferentTimes = 0;
        for (int i = 0; i < list1.size(); ++i) {
            if (((EventLog)list1.get((int)i)).time == ((EventLog)list2.get((int)i)).time) continue;
            ++noOfDifferentTimes;
        }
        System.out.println("noOfDifferentTimes:" + noOfDifferentTimes);
    }

    public static double getTravelTime(ArrayList<EventLog> eventLog1, int vehicleId) {
        double travelTime = 0.0;
        double startLegTime = 0.0;
        for (int i = 0; i < eventLog1.size(); ++i) {
            if (eventLog1.get((int)i).vehicleId != vehicleId) continue;
            if (eventLog1.get((int)i).type.equalsIgnoreCase("start leg")) {
                startLegTime = eventLog1.get((int)i).time;
                continue;
            }
            if (!eventLog1.get((int)i).type.equalsIgnoreCase("end leg")) continue;
            travelTime += eventLog1.get((int)i).time - startLegTime;
        }
        return travelTime;
    }

    public static double getSumTravelTime(ArrayList<EventLog> eventLog1) {
        double travelTime = 0.0;
        HashMap<Integer, Double> startingTime = new HashMap<Integer, Double>();
        for (int i = 0; i < eventLog1.size(); ++i) {
            if (eventLog1.get((int)i).type.equalsIgnoreCase("start leg")) {
                startingTime.put(eventLog1.get((int)i).vehicleId, eventLog1.get((int)i).time);
                continue;
            }
            if (!eventLog1.get((int)i).type.equalsIgnoreCase("end leg")) continue;
            travelTime += eventLog1.get((int)i).time - (Double)startingTime.get(eventLog1.get((int)i).vehicleId);
        }
        return travelTime;
    }
}

