/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.mobsim.jdeqsim;

import org.matsim.core.config.ReflectiveConfigGroup;
import org.matsim.core.utils.misc.Time;

public class JDEQSimConfigGroup
extends ReflectiveConfigGroup {
    public static final String NAME = "JDEQSim";
    public static final String START_LEG = "start leg";
    public static final String END_LEG = "end leg";
    public static final String ENTER_LINK = "enter link";
    public static final String LEAVE_LINK = "leave link";
    public static final int PRIORITY_LEAVE_ROAD_MESSAGE = 200;
    public static final int PRIORITY_ARRIVAL_MESSAGE = 150;
    public static final int PRIORITY_DEPARTUARE_MESSAGE = 125;
    public static final int PRIORITY_ENTER_ROAD_MESSAGE = 100;
    public static final String SQUEEZE_TIME = "squeezeTime";
    public static final String FLOW_CAPACITY_FACTOR = "flowCapacityFactor";
    public static final String STORAGE_CAPACITY_FACTOR = "storageCapacityFactor";
    public static final String MINIMUM_INFLOW_CAPACITY = "minimumInFlowCapacity";
    public static final String CAR_SIZE = "carSize";
    public static final String GAP_TRAVEL_SPEED = "gapTravelSpeed";
    public static final String END_TIME = "endTime";
    private double simulationEndTime = Double.MAX_VALUE;
    private double gapTravelSpeed = 15.0;
    private double flowCapacityFactor = 1.0;
    private double storageCapacityFactor = 1.0;
    private double carSize = 7.5;
    private double minimumInFlowCapacity = 1800.0;
    private double squeezeTime = 1800.0;
    private static boolean GC_MESSAGES = false;

    public JDEQSimConfigGroup() {
        super(NAME);
    }

    public static boolean isGC_MESSAGES() {
        return GC_MESSAGES;
    }

    public static void setGC_MESSAGES(boolean gc_messages) {
        GC_MESSAGES = gc_messages;
    }

    @ReflectiveConfigGroup.StringGetter(value="endTime")
    public String getSimulationEndTimeAsString() {
        if (this.simulationEndTime != Double.MAX_VALUE) {
            return Time.writeTime(this.simulationEndTime);
        }
        return Time.writeTime(Time.getUndefinedTime());
    }

    @ReflectiveConfigGroup.StringSetter(value="endTime")
    public void setSimulationEndTime(String simulationEndTime) {
        double parsedTime = Time.parseTime(simulationEndTime);
        if (!Time.isUndefinedTime(parsedTime)) {
            this.simulationEndTime = parsedTime;
        }
    }

    public double getSimulationEndTime() {
        return this.simulationEndTime;
    }

    @ReflectiveConfigGroup.StringGetter(value="gapTravelSpeed")
    public double getGapTravelSpeed() {
        return this.gapTravelSpeed;
    }

    @ReflectiveConfigGroup.StringSetter(value="gapTravelSpeed")
    public void setGapTravelSpeed(double gapTravelSpeed) {
        this.gapTravelSpeed = gapTravelSpeed;
    }

    @ReflectiveConfigGroup.StringGetter(value="flowCapacityFactor")
    public double getFlowCapacityFactor() {
        return this.flowCapacityFactor;
    }

    @ReflectiveConfigGroup.StringSetter(value="flowCapacityFactor")
    public void setFlowCapacityFactor(double flowCapacityFactor) {
        this.flowCapacityFactor = flowCapacityFactor;
    }

    @ReflectiveConfigGroup.StringGetter(value="storageCapacityFactor")
    public double getStorageCapacityFactor() {
        return this.storageCapacityFactor;
    }

    @ReflectiveConfigGroup.StringSetter(value="storageCapacityFactor")
    public void setStorageCapacityFactor(double storageCapacityFactor) {
        this.storageCapacityFactor = storageCapacityFactor;
    }

    @ReflectiveConfigGroup.StringGetter(value="carSize")
    public double getCarSize() {
        return this.carSize;
    }

    @ReflectiveConfigGroup.StringSetter(value="carSize")
    public void setCarSize(double carSize) {
        this.carSize = carSize;
    }

    @ReflectiveConfigGroup.StringGetter(value="minimumInFlowCapacity")
    public double getMinimumInFlowCapacity() {
        return this.minimumInFlowCapacity;
    }

    @ReflectiveConfigGroup.StringSetter(value="minimumInFlowCapacity")
    public void setMinimumInFlowCapacity(double minimumInFlowCapacity) {
        this.minimumInFlowCapacity = minimumInFlowCapacity;
    }

    @ReflectiveConfigGroup.StringGetter(value="squeezeTime")
    public double getSqueezeTime() {
        return this.squeezeTime;
    }

    @ReflectiveConfigGroup.StringSetter(value="squeezeTime")
    public void setSqueezeTime(double squeezeTime) {
        this.squeezeTime = squeezeTime;
    }
}

