/*
 * Decompiled with CFR 0.152.
 */
package org.matsim.core.mobsim.jdeqsim;

import java.util.HashMap;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.matsim.api.core.v01.Id;
import org.matsim.api.core.v01.Scenario;
import org.matsim.api.core.v01.network.Link;
import org.matsim.api.core.v01.population.Person;
import org.matsim.core.api.experimental.events.EventsManager;
import org.matsim.core.config.groups.PlansConfigGroup;
import org.matsim.core.mobsim.framework.Mobsim;
import org.matsim.core.mobsim.jdeqsim.JDEQSimConfigGroup;
import org.matsim.core.mobsim.jdeqsim.Message;
import org.matsim.core.mobsim.jdeqsim.MessageQueue;
import org.matsim.core.mobsim.jdeqsim.Road;
import org.matsim.core.mobsim.jdeqsim.Scheduler;
import org.matsim.core.mobsim.jdeqsim.Vehicle;
import org.matsim.core.mobsim.jdeqsim.util.Timer;

public class JDEQSimulation
implements Mobsim {
    private static final Logger log = Logger.getLogger(JDEQSimulation.class);
    private final JDEQSimConfigGroup config;
    protected Scenario scenario;
    private final EventsManager events;
    protected final PlansConfigGroup.ActivityDurationInterpretation activityDurationInterpretation;

    @Inject
    public JDEQSimulation(JDEQSimConfigGroup config, Scenario scenario, EventsManager events) {
        Road.setConfig(config);
        Message.setEventsManager(events);
        this.config = config;
        this.scenario = scenario;
        this.events = events;
        this.activityDurationInterpretation = this.scenario.getConfig().plans().getActivityDurationInterpretation();
    }

    @Override
    public void run() {
        this.events.initProcessing();
        Timer t = new Timer();
        t.startTimer();
        Scheduler scheduler = new Scheduler(new MessageQueue(), this.config.getSimulationEndTime());
        Road.setAllRoads(new HashMap<Id<Link>, Road>());
        for (Link link : this.scenario.getNetwork().getLinks().values()) {
            Road road = new Road(scheduler, link);
            Road.getAllRoads().put(link.getId(), road);
        }
        for (Person person : this.scenario.getPopulation().getPersons().values()) {
            new Vehicle(scheduler, person, this.activityDurationInterpretation);
        }
        scheduler.startSimulation();
        t.endTimer();
        log.info("Time needed for one iteration (only JDEQSimulation part): " + t.getMeasuredTime() + "[ms]");
        this.events.finishProcessing();
    }
}

